/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.model.framestore;

import edu.stanford.smi.protege.util.HashUtils;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;

class MethodCall {
    private Method _method;
    private Object[] _args;
    private int _hashCode;
    private static final Object[] NULL_ARGS = new Object[0];

    MethodCall() {
    }

    MethodCall(Method m, Object[] args) {
        Object[] safeArgs = null;
        if (args != null) {
            safeArgs = new Object[args.length];
            for (int i = 0; i < args.length; ++i) {
                ArrayList o = args[i];
                if (o instanceof Collection) {
                    o = new ArrayList(o);
                }
                safeArgs[i] = o;
            }
        }
        this.set(m, safeArgs);
    }

    public void set(Method m, Object[] args) {
        this._method = m;
        this._args = args == null ? NULL_ARGS : args;
        this._hashCode = HashUtils.getHash((Object)m, this._args);
    }

    public int hashCode() {
        return this._hashCode;
    }

    public boolean equals(Object o) {
        MethodCall rhs = (MethodCall)o;
        boolean equals = this._method.equals(rhs._method);
        equals &= this._args.length == rhs._args.length;
        for (int i = 0; equals && i < this._args.length; ++i) {
            equals = this._args[i] == rhs._args[i];
        }
        return equals;
    }

    public String toString() {
        return "MethodCall";
    }
}

