/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.model.framestore;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Facet;
import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.model.FrameID;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.model.SimpleInstance;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.model.framestore.FrameStore;
import edu.stanford.smi.protege.model.framestore.ModificationFrameStore;
import edu.stanford.smi.protege.util.ApplicationProperties;
import edu.stanford.smi.protege.util.StandardDateFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Set;

public class ModificationRecordFrameStore
extends ModificationFrameStore {
    private Collection _authors = Collections.singleton(ApplicationProperties.getUserName());
    private Slot _creationAuthorSlot;
    private Slot _creationTimestampSlot;
    private Slot _modificationAuthorSlot;
    private Slot _modificationTimestampSlot;

    public void setAuthor(String name) {
        this._authors = Collections.singleton(name);
    }

    public void reinitialize() {
    }

    public void close() {
        this._authors = null;
        this._creationAuthorSlot = null;
        this._creationTimestampSlot = null;
        this._modificationAuthorSlot = null;
        this._modificationTimestampSlot = null;
    }

    public void onSetDelegate() {
        FrameStore delegate = this.getDelegate();
        if (delegate != null) {
            this._creationAuthorSlot = (Slot)delegate.getFrame(":CREATOR");
            this._creationTimestampSlot = (Slot)delegate.getFrame(":CREATION-TIMESTAMP");
            this._modificationAuthorSlot = (Slot)delegate.getFrame(":MODIFIER");
            this._modificationTimestampSlot = (Slot)delegate.getFrame(":MODIFICATION-TIMESTAMP");
        }
    }

    private void updateCreationRecord(Frame frame) {
        this.updateFrameRecord(frame, this._creationAuthorSlot, this._creationTimestampSlot);
    }

    private void updateModificationRecord(Frame frame) {
        this.updateFrameRecord(frame, this._modificationAuthorSlot, this._modificationTimestampSlot);
    }

    private void updateDeletionRecord(Frame frame) {
    }

    private void updateFrameRecord(Frame frame, Slot authorSlot, Slot timestampSlot) {
        if (frame.hasOwnSlot(authorSlot)) {
            this.getDelegate().setDirectOwnSlotValues(frame, authorSlot, this._authors);
        }
        if (frame.hasOwnSlot(timestampSlot)) {
            String timestamp = new StandardDateFormat().format(new Date());
            Set<String> timestamps = Collections.singleton(timestamp);
            this.getDelegate().setDirectOwnSlotValues(frame, timestampSlot, timestamps);
        }
    }

    public Cls createCls(FrameID id, Collection types, Collection superclasses, boolean loadDefaults) {
        Cls cls = this.getDelegate().createCls(id, types, superclasses, loadDefaults);
        this.updateCreationRecord(cls);
        return cls;
    }

    public Slot createSlot(FrameID id, Collection types, Collection superslots, boolean loadDefaults) {
        Slot slot = this.getDelegate().createSlot(id, types, superslots, loadDefaults);
        this.updateCreationRecord(slot);
        return slot;
    }

    public Facet createFacet(FrameID id, Collection directTypes, boolean loadDefaultValues) {
        Facet facet = this.getDelegate().createFacet(id, directTypes, loadDefaultValues);
        this.updateCreationRecord(facet);
        return facet;
    }

    public SimpleInstance createSimpleInstance(FrameID id, Collection types, boolean loadDefaultValues) {
        SimpleInstance simpleInstance = this.getDelegate().createSimpleInstance(id, types, loadDefaultValues);
        this.updateCreationRecord(simpleInstance);
        return simpleInstance;
    }

    public void deleteCls(Cls cls) {
        this.updateDeletionRecord(cls);
        this.getDelegate().deleteCls(cls);
    }

    public void deleteSlot(Slot slot) {
        this.updateDeletionRecord(slot);
        this.getDelegate().deleteSlot(slot);
    }

    public void deleteFacet(Facet facet) {
        this.updateDeletionRecord(facet);
        this.getDelegate().deleteFacet(facet);
    }

    public void deleteSimpleInstance(SimpleInstance simpleInstance) {
        this.updateDeletionRecord(simpleInstance);
        this.getDelegate().deleteSimpleInstance(simpleInstance);
    }

    public void moveDirectOwnSlotValue(Frame frame, Slot slot, int from, int to) {
        this.getDelegate().moveDirectOwnSlotValue(frame, slot, from, to);
        this.updateModificationRecord(frame);
    }

    public void setDirectOwnSlotValues(Frame frame, Slot slot, Collection values) {
        this.getDelegate().setDirectOwnSlotValues(frame, slot, values);
        this.updateModificationRecord(frame);
    }

    public void addDirectTemplateSlot(Cls cls, Slot slot) {
        this.getDelegate().addDirectTemplateSlot(cls, slot);
        this.updateModificationRecord(cls);
    }

    public void removeDirectTemplateSlot(Cls cls, Slot slot) {
        this.getDelegate().removeDirectTemplateSlot(cls, slot);
        this.updateModificationRecord(cls);
    }

    public void moveDirectTemplateSlot(Cls cls, Slot slot, int index) {
        this.getDelegate().moveDirectTemplateSlot(cls, slot, index);
        this.updateModificationRecord(cls);
    }

    public void setDirectTemplateSlotValues(Cls cls, Slot slot, Collection values) {
        this.getDelegate().setDirectTemplateSlotValues(cls, slot, values);
        this.updateModificationRecord(cls);
    }

    public void removeDirectTemplateFacetOverrides(Cls cls, Slot slot) {
        this.getDelegate().removeDirectTemplateFacetOverrides(cls, slot);
        this.updateModificationRecord(cls);
    }

    public void setDirectTemplateFacetValues(Cls cls, Slot slot, Facet facet, Collection values) {
        this.getDelegate().setDirectTemplateFacetValues(cls, slot, facet, values);
        this.updateModificationRecord(cls);
    }

    public void addDirectSuperclass(Cls cls, Cls superclass) {
        this.getDelegate().addDirectSuperclass(cls, superclass);
        this.updateModificationRecord(cls);
    }

    public void removeDirectSuperclass(Cls cls, Cls superclass) {
        this.getDelegate().removeDirectSuperclass(cls, superclass);
        this.updateModificationRecord(cls);
    }

    public void moveDirectSubclass(Cls cls, Cls subclass, int index) {
        this.getDelegate().moveDirectSubclass(cls, subclass, index);
        this.updateModificationRecord(cls);
    }

    public void moveDirectSubslot(Slot slot, Slot subslot, int index) {
        this.getDelegate().moveDirectSubslot(slot, subslot, index);
        this.updateModificationRecord(slot);
    }

    public void addDirectSuperslot(Slot slot, Slot superslot) {
        this.getDelegate().addDirectSuperslot(slot, superslot);
        this.updateModificationRecord(slot);
    }

    public void removeDirectSuperslot(Slot slot, Slot superslot) {
        this.getDelegate().removeDirectSuperslot(slot, superslot);
        this.updateModificationRecord(slot);
    }

    public void addDirectType(Instance instance, Cls type) {
        this.getDelegate().addDirectType(instance, type);
        this.updateModificationRecord(instance);
    }

    public void removeDirectType(Instance instance, Cls type) {
        this.getDelegate().removeDirectType(instance, type);
        this.updateModificationRecord(instance);
    }

    public void moveDirectType(Instance instance, Cls type, int index) {
        this.getDelegate().moveDirectType(instance, type, index);
        this.updateModificationRecord(instance);
    }

    public boolean beginTransaction(String name) {
        return this.getDelegate().beginTransaction(name);
    }

    public boolean commitTransaction() {
        return this.getDelegate().commitTransaction();
    }

    public boolean rollbackTransaction() {
        return this.getDelegate().rollbackTransaction();
    }

    public void replaceFrame(Frame original, Frame replacement) {
        this.getDelegate().replaceFrame(original, replacement);
        this.updateDeletionRecord(original);
        this.updateCreationRecord(replacement);
    }
}

