/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.model.framestore;

import edu.stanford.smi.protege.model.Facet;
import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.util.HashUtils;
import edu.stanford.smi.protege.util.SystemUtilities;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;

public class Record {
    private Frame frame;
    private Slot slot;
    private Facet facet;
    private boolean isTemplate;
    private List values;
    private int hashCode;

    public Record(Frame frame, Slot slot, Facet facet, boolean isTemplate, Collection values) {
        this.set(frame, slot, facet, isTemplate);
        this.setValues(values);
    }

    Record() {
    }

    void set(Frame frame, Slot slot, Facet facet, boolean isTemplate) {
        this.frame = frame;
        this.slot = slot;
        this.facet = facet;
        this.isTemplate = isTemplate;
        this.hashCode = HashUtils.getHash(frame, slot, facet, isTemplate);
    }

    public int hashCode() {
        return this.hashCode;
    }

    public Frame getFrame() {
        return this.frame;
    }

    public Slot getSlot() {
        return this.slot;
    }

    public Facet getFacet() {
        return this.facet;
    }

    public boolean isTemplate() {
        return this.isTemplate;
    }

    public List getInternalValues() {
        return this.values;
    }

    public int getValueCount() {
        return this.values.size();
    }

    public List getValues() {
        return this.values.isEmpty() ? Collections.EMPTY_LIST : new ArrayList(this.values);
    }

    public void setValues(Collection values) {
        this.values = new ArrayList(values);
    }

    public void addValue(Object o) {
        this.values.add(o);
    }

    public boolean removeValue(Object o) {
        return this.values.remove(o);
    }

    public void moveValue(int from, int to) {
        Object value = this.values.remove(from);
        this.values.add(to, value);
    }

    public void replaceFrameReference(Frame replacementFrame) {
        if (replacementFrame.equals(this.frame)) {
            this.frame = replacementFrame;
        }
        if (replacementFrame.equals(this.slot)) {
            this.slot = (Slot)replacementFrame;
        }
        if (replacementFrame.equals(this.facet)) {
            this.facet = (Facet)replacementFrame;
        }
    }

    public void replaceFrameValue(Frame replacementFrame) {
        ListIterator<Frame> i = this.values.listIterator();
        while (i.hasNext()) {
            Object o = i.next();
            if (!replacementFrame.equals(o)) continue;
            i.set(replacementFrame);
        }
    }

    public boolean isEmpty() {
        return this.values.isEmpty();
    }

    public String toString() {
        return "<Record " + this.frame.getFrameID().getName() + ":" + this.slot.getFrameID().getName() + ":" + (this.facet == null ? "null" : this.facet.getFrameID().getName()) + ":" + this.isTemplate + ">";
    }

    public boolean equals(Object o) {
        boolean areEqual = false;
        if (o instanceof Record) {
            Record otherRecord = (Record)o;
            areEqual = Record.equals(this.frame, otherRecord.frame) && Record.equals(this.slot, otherRecord.slot) && Record.equals(this.facet, otherRecord.facet) && this.isTemplate == otherRecord.isTemplate;
        }
        return areEqual;
    }

    private static boolean equals(Object o1, Object o2) {
        return SystemUtilities.equals(o1, o2);
    }
}

