/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.model.framestore;

import edu.stanford.smi.protege.model.Facet;
import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.Localizable;
import edu.stanford.smi.protege.model.Reference;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.util.HashUtils;
import edu.stanford.smi.protege.util.LocalizeUtils;
import edu.stanford.smi.protege.util.SystemUtilities;
import java.io.Serializable;

public class ReferenceImpl
implements Reference,
Serializable,
Localizable {
    private static final long serialVersionUID = 8659902573681918672L;
    private Frame _frame;
    private Slot _slot;
    private Facet _facet;
    private boolean _isTemplate;
    private int _hashCode;

    public ReferenceImpl(Frame frame, Slot slot, Facet facet, boolean isTemplate) {
        this.set(frame, slot, facet, isTemplate);
    }

    public ReferenceImpl() {
    }

    public void replace(Frame frame) {
        if (frame.equals(this._frame)) {
            this._frame = frame;
        } else if (frame.equals(this._slot)) {
            this._slot = (Slot)frame;
        } else if (frame.equals(this._facet)) {
            this._facet = (Facet)frame;
        }
    }

    public void set(Frame frame, Slot slot, Facet facet, boolean isTemplate) {
        if (frame == null) {
            throw new RuntimeException("null frame");
        }
        if (slot == null) {
            throw new RuntimeException("null slot");
        }
        this._frame = frame;
        this._slot = slot;
        this._facet = facet;
        this._isTemplate = isTemplate;
        this._hashCode = HashUtils.getHash(frame, slot, facet, isTemplate);
    }

    public Frame getFrame() {
        return this._frame;
    }

    public Slot getSlot() {
        return this._slot;
    }

    public Facet getFacet() {
        return this._facet;
    }

    public String toString() {
        return "Reference(" + this._frame + ", " + this._slot + ", " + this._facet + ")";
    }

    public boolean isTemplate() {
        return this._isTemplate;
    }

    public boolean equals(Object o) {
        ReferenceImpl rhs = (ReferenceImpl)o;
        return ReferenceImpl.equals(this._frame, rhs._frame) && ReferenceImpl.equals(this._slot, rhs._slot) && ReferenceImpl.equals(this._facet, rhs._facet) && this._isTemplate == rhs._isTemplate;
    }

    public static boolean equals(Object o1, Object o2) {
        return SystemUtilities.equals(o1, o2);
    }

    public int hashCode() {
        return this._hashCode;
    }

    public boolean usesFrame(Frame frame) {
        return frame.equals(this._frame) || frame.equals(this._slot) || frame.equals(this._facet);
    }

    public void localize(KnowledgeBase kb) {
        LocalizeUtils.localize(this._frame, kb);
        LocalizeUtils.localize(this._slot, kb);
        LocalizeUtils.localize(this._facet, kb);
    }
}

