/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.model.framestore;

import edu.stanford.smi.protege.model.Facet;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.Localizable;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.util.HashUtils;
import edu.stanford.smi.protege.util.LocalizeUtils;
import edu.stanford.smi.protege.util.SystemUtilities;
import java.io.Serializable;

public class Sft
implements Localizable,
Serializable {
    private static final long serialVersionUID = 1248658503922717736L;
    private Slot _slot;
    private Facet _facet;
    private boolean _isTemplate;

    public String toString() {
        return "Sft(" + this._slot.getFrameID() + ", " + (this._facet == null ? "null" : this._facet.getFrameID().getName()) + ", " + this._isTemplate + ")";
    }

    public Sft(Slot slot, Facet facet, boolean isTemplate) {
        this._slot = slot;
        this._facet = facet;
        this._isTemplate = isTemplate;
    }

    public Sft() {
    }

    public Slot getSlot() {
        return this._slot;
    }

    public Facet getFacet() {
        return this._facet;
    }

    public boolean isOwnSlot() {
        return this._facet == null && !this._isTemplate;
    }

    public boolean isTemplateSlot() {
        return this._facet == null && this._isTemplate;
    }

    public boolean isTemplateFacet() {
        return this._facet != null && this._isTemplate;
    }

    public int hashCode() {
        return HashUtils.getHash((Object)this._slot, (Object)this._facet, this._isTemplate);
    }

    public boolean equals(Object o) {
        if (o instanceof Sft) {
            Sft rhs = (Sft)o;
            return Sft.equals(this._slot, rhs._slot) && Sft.equals(this._facet, rhs._facet) && this._isTemplate == rhs._isTemplate;
        }
        return false;
    }

    public static boolean equals(Object o1, Object o2) {
        return SystemUtilities.equals(o1, o2);
    }

    public void localize(KnowledgeBase kb) {
        LocalizeUtils.localize(this._slot, kb);
        LocalizeUtils.localize(this._facet, kb);
    }
}

