/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.model.framestore;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Facet;
import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.model.FrameFactory;
import edu.stanford.smi.protege.model.FrameID;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.Reference;
import edu.stanford.smi.protege.model.SimpleInstance;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.model.SystemFrames;
import edu.stanford.smi.protege.model.framestore.FrameStore;
import edu.stanford.smi.protege.model.framestore.NarrowFrameStore;
import edu.stanford.smi.protege.model.query.Query;
import edu.stanford.smi.protege.model.query.QueryCallback;
import edu.stanford.smi.protege.util.AbstractEvent;
import edu.stanford.smi.protege.util.CacheMap;
import edu.stanford.smi.protege.util.CollectionUtilities;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protege.util.SimpleStringMatcher;
import edu.stanford.smi.protege.util.StringUtilities;
import edu.stanford.smi.protege.util.SystemUtilities;
import edu.stanford.smi.protege.util.transaction.TransactionMonitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleFrameStore
implements FrameStore {
    private KnowledgeBase _kb;
    private SystemFrames _systemFrames;
    private NarrowFrameStore _helper;
    private Set<Slot> _inheritedSuperslotSlots = new HashSet<Slot>();
    private CacheMap<String, Frame> nameToFrameMap = new CacheMap();

    @Override
    public String getName() {
        return this.getClass().getName();
    }

    public SimpleFrameStore(KnowledgeBase kb, NarrowFrameStore helper) {
        this.setHelper(helper);
        if (kb != null) {
            this._kb = kb;
            this._systemFrames = kb.getSystemFrames();
            this.loadInheritedSuperslotSlots();
        }
    }

    private void loadInheritedSuperslotSlots() {
        this._inheritedSuperslotSlots.add(this._systemFrames.getDirectDomainSlot());
        this._inheritedSuperslotSlots.add(this._systemFrames.getValueTypeSlot());
        this._inheritedSuperslotSlots.add(this._systemFrames.getMaximumCardinalitySlot());
        this._inheritedSuperslotSlots.add(this._systemFrames.getMinimumValueSlot());
        this._inheritedSuperslotSlots.add(this._systemFrames.getMaximumValueSlot());
    }

    @Override
    public void reinitialize() {
        this.nameToFrameMap.clear();
        this._helper.reinitialize();
    }

    public void setHelper(NarrowFrameStore helper) {
        this._helper = helper;
    }

    public NarrowFrameStore getHelper() {
        return this._helper;
    }

    @Override
    public void executeQuery(Query query, QueryCallback callback) {
        this._helper.executeQuery(query, callback);
    }

    @Override
    public void deleteCls(Cls cls) {
        this.deleteFrame(cls);
    }

    public static Collection<Cls> getClsesToBeDeleted(Cls cls, FrameStore fs) {
        Set<Cls> subclasses = fs.getSubclasses(cls);
        HashSet<Cls> clsesToBeDeleted = new HashSet<Cls>(subclasses);
        clsesToBeDeleted.add(cls);
        for (Cls subclass : subclasses) {
            if (subclass.equals(cls) || !SimpleFrameStore.reachableByAnotherRoute(subclass, clsesToBeDeleted, fs)) continue;
            clsesToBeDeleted.remove(subclass);
            HashSet<Cls> subsubclasses = new HashSet<Cls>(fs.getSubclasses(subclass));
            subsubclasses.remove(cls);
            clsesToBeDeleted.removeAll(subsubclasses);
        }
        return clsesToBeDeleted;
    }

    private static boolean reachableByAnotherRoute(Cls subclass, Collection classesToBeDeleted, FrameStore fs) {
        boolean reachable = false;
        List<Cls> superclasses = fs.getDirectSuperclasses(subclass);
        if (superclasses.size() > 1) {
            for (Cls superclass : superclasses) {
                if (classesToBeDeleted.contains(superclass)) continue;
                reachable = true;
                break;
            }
        }
        return reachable;
    }

    @Override
    public void deleteSlot(Slot slot) {
        this.deleteFrame(slot);
    }

    @Override
    public void deleteFacet(Facet facet) {
        this.deleteFrame(facet);
    }

    @Override
    public void deleteSimpleInstance(SimpleInstance simpleInstance) {
        this.deleteFrame(simpleInstance);
    }

    private void deleteFrame(Frame frame) {
        this.nameToFrameMap.remove(this.getFrameName(frame));
        this._helper.deleteFrame(frame);
    }

    @Override
    public Set<Reference> getReferences(Object value) {
        Set<Reference> references = this._helper.getReferences(value);
        return SimpleFrameStore.unmodifiableSet(references);
    }

    @Override
    public void close() {
        this._kb = null;
        this._systemFrames = null;
        this._helper.close();
        this._helper = null;
    }

    @Override
    public Set<Reference> getMatchingReferences(String value, int maxMatches) {
        return this._helper.getMatchingReferences(value, maxMatches);
    }

    @Override
    public Set<Cls> getClsesWithMatchingBrowserText(String value, Collection superclasses, int maxMatches) {
        SimpleStringMatcher matcher = new SimpleStringMatcher(value);
        HashSet<Cls> clses = new HashSet<Cls>();
        Set<Reference> references = this._helper.getMatchingReferences(value, -1);
        for (Reference ref : references) {
            Cls cls;
            Frame frame = ref.getFrame();
            if (!(frame instanceof Cls) || !matcher.isMatch((cls = (Cls)frame).getBrowserText()) || !SimpleFrameStore.isSubclassMatch(cls, superclasses)) continue;
            clses.add(cls);
            if (maxMatches == -1 || clses.size() != maxMatches) continue;
            break;
        }
        return clses;
    }

    private static boolean isSubclassMatch(Cls cls, Collection superclasses) {
        boolean isMatch = true;
        if (!superclasses.isEmpty()) {
            HashSet clsSuperclasses = new HashSet(cls.getSuperclasses());
            isMatch = clsSuperclasses.removeAll(superclasses);
        }
        return isMatch;
    }

    private FrameFactory getFrameFactory() {
        return this._kb.getFrameFactory();
    }

    @Override
    public int getClsCount() {
        return this._helper.getClsCount();
    }

    @Override
    public int getSlotCount() {
        return this._helper.getSlotCount();
    }

    @Override
    public int getFacetCount() {
        return this._helper.getFacetCount();
    }

    @Override
    public int getSimpleInstanceCount() {
        return this._helper.getSimpleInstanceCount();
    }

    @Override
    public int getFrameCount() {
        return this._helper.getFrameCount();
    }

    @Override
    public Set<Cls> getClses() {
        return this.getInstances(this._systemFrames.getRootClsMetaCls());
    }

    @Override
    public Set<Slot> getSlots() {
        return this.getInstances(this._systemFrames.getRootSlotMetaCls());
    }

    @Override
    public Set<Facet> getFacets() {
        return this.getInstances(this._systemFrames.getRootFacetMetaCls());
    }

    @Override
    public Set<Frame> getFrames() {
        return this._helper.getFrames();
    }

    @Override
    public List getDirectTemplateSlots(Cls cls) {
        return this.getDirectOwnSlotValues(cls, this._systemFrames.getDirectTemplateSlotsSlot());
    }

    @Override
    public List<Cls> getDirectSuperclasses(Cls cls) {
        return this.getDirectOwnSlotValues(cls, this._systemFrames.getDirectSuperclassesSlot());
    }

    @Override
    public List getDirectSuperslots(Slot slot) {
        return this.getDirectOwnSlotValues(slot, this._systemFrames.getDirectSuperslotsSlot());
    }

    @Override
    public List getDirectSubslots(Slot slot) {
        return this.getDirectOwnSlotValues(slot, this._systemFrames.getDirectSubslotsSlot());
    }

    @Override
    public Set getSuperslots(Slot slot) {
        return this.getDirectOwnSlotValuesClosure(slot, this._systemFrames.getDirectSuperslotsSlot());
    }

    @Override
    public Set getSubslots(Slot slot) {
        return this.getDirectOwnSlotValuesClosure(slot, this._systemFrames.getDirectSubslotsSlot());
    }

    @Override
    public Set getSuperclasses(Cls cls) {
        return this.getDirectOwnSlotValuesClosure(cls, this._systemFrames.getDirectSuperclassesSlot());
    }

    @Override
    public List<Cls> getDirectSubclasses(Cls cls) {
        return this.getDirectOwnSlotValues(cls, this._systemFrames.getDirectSubclassesSlot());
    }

    @Override
    public Set<Cls> getSubclasses(Cls cls) {
        return this.getDirectOwnSlotValuesClosure(cls, this._systemFrames.getDirectSubclassesSlot());
    }

    @Override
    public Set<Facet> getTemplateFacets(Cls cls, Slot slot) {
        Set<Slot> slots = this.getOwnSlots(slot);
        Set facets = this.collectOwnSlotValues(slots, this._systemFrames.getAssociatedFacetSlot());
        return SimpleFrameStore.unmodifiableSet(facets);
    }

    @Override
    public Collection getTemplateFacetValues(Cls localCls, Slot slot, Facet facet) {
        Collection values = new ArrayList(this.getDirectTemplateFacetValues(localCls, slot, facet));
        for (Cls cls : this.getSuperclasses(localCls)) {
            List superclassValues = this.getDirectTemplateFacetValues(cls, slot, facet);
            values = SimpleFrameStore.resolveValues(values, superclassValues, facet);
        }
        Slot associatedSlot = (Slot)this.getDirectOwnSlotValue(facet, this._systemFrames.getAssociatedSlotSlot());
        if (associatedSlot != null) {
            Collection topLevelValues = this.getOwnSlotValues(slot, associatedSlot);
            values = SimpleFrameStore.resolveValues(values, topLevelValues, facet);
        }
        return SimpleFrameStore.unmodifiableCollection(values);
    }

    private static Collection resolveValues(Collection values, Collection newValues, Facet facet) {
        if (!newValues.isEmpty()) {
            if (values.isEmpty()) {
                values.addAll(newValues);
            } else if ((values = facet.resolveValues(values, newValues)) == newValues) {
                values = new ArrayList(values);
            }
        }
        return values;
    }

    @Override
    public Collection getTemplateSlotValues(Cls cls, Slot slot) {
        return this.getTemplateFacetValues(cls, slot, this._systemFrames.getValuesFacet());
    }

    @Override
    public Set getDirectOwnSlotValuesClosure(Frame frame, Slot slot) {
        Set closure = this.getValuesClosure(frame, slot, null, false);
        return SimpleFrameStore.unmodifiableSet(closure);
    }

    private Set getValuesClosure(Frame frame, Slot slot, Facet facet, boolean isTemplate) {
        return this.getValuesClosure(frame, slot, facet, isTemplate, slot);
    }

    private Set getValuesClosure(Frame frame, Slot slot, Facet facet, boolean isTemplate, Slot traversalSlot) {
        HashSet values;
        HashSet closure = this._helper.getClosure(frame, traversalSlot, null, false);
        if (SimpleFrameStore.equals(slot, traversalSlot) && facet == null && !isTemplate) {
            values = closure;
        } else {
            values = new HashSet(this.getValues(frame, slot, facet, isTemplate));
            for (Frame traversedFrame : closure) {
                values.addAll(this.getValues(traversedFrame, slot, facet, isTemplate));
            }
        }
        return values;
    }

    public static boolean equals(Object o1, Object o2) {
        return SystemUtilities.equals(o1, o2);
    }

    @Override
    public List getDirectTypes(Instance instance) {
        return this.getDirectOwnSlotValues(instance, this._systemFrames.getDirectTypesSlot());
    }

    @Override
    public List<Instance> getDirectInstances(Cls cls) {
        return this.getDirectOwnSlotValues(cls, this._systemFrames.getDirectInstancesSlot());
    }

    @Override
    public Set<Instance> getInstances(Cls cls) {
        LinkedHashSet<Cls> clses = new LinkedHashSet<Cls>(this.getSubclasses(cls));
        clses.add(cls);
        return this.collectOwnSlotValues(clses, this._systemFrames.getDirectInstancesSlot());
    }

    @Override
    public Set getTypes(Instance instance) {
        List directTypes = this.getDirectTypes(instance);
        LinkedHashSet types = new LinkedHashSet(directTypes);
        int nTypes = directTypes.size();
        for (int i = 0; i < nTypes; ++i) {
            Cls type = (Cls)directTypes.get(i);
            types.addAll(this.getSuperclasses(type));
        }
        return SimpleFrameStore.unmodifiableSet(types);
    }

    private static <X> Set<X> unmodifiableSet(Set<X> set) {
        return set == null ? Collections.EMPTY_SET : Collections.unmodifiableSet(set);
    }

    private static List unmodifiableList(List list) {
        return list == null ? Collections.EMPTY_LIST : Collections.unmodifiableList(list);
    }

    private static Collection unmodifiableCollection(Collection collection) {
        return collection == null ? Collections.EMPTY_LIST : Collections.unmodifiableCollection(collection);
    }

    private Set collectOwnSlotValues(Collection frames, Slot slot) {
        LinkedHashSet values = new LinkedHashSet();
        Object[] frameArray = frames.toArray();
        for (int i = 0; i < frameArray.length; ++i) {
            Frame frame = (Frame)frameArray[i];
            values.addAll(this.getDirectOwnSlotValues(frame, slot));
        }
        return values;
    }

    @Override
    public Frame getFrame(String name) {
        Frame frame = (Frame)this.nameToFrameMap.get(name);
        if (frame == null && (frame = this.getFrame(new FrameID(name))) != null) {
            this.nameToFrameMap.put(name, frame);
        }
        return frame;
    }

    @Override
    public Frame getFrame(FrameID id) {
        return this._helper.getFrame(id);
    }

    @Override
    public Set<Slot> getOwnSlots(Frame frame) {
        Set types = this.getTypes((Instance)frame);
        Set ownSlots = this.collectOwnSlotValues(types, this._systemFrames.getDirectTemplateSlotsSlot());
        HashSet subSlots = new HashSet();
        for (Slot o : ownSlots) {
            Slot slot;
            Set addSlots;
            if (!(o instanceof Slot) || (addSlots = this.getSubslots(slot = o)) == null) continue;
            subSlots.addAll(addSlots);
        }
        ownSlots.addAll(subSlots);
        ownSlots.add(this._systemFrames.getNameSlot());
        ownSlots.add(this._systemFrames.getDirectTypesSlot());
        return ownSlots;
    }

    @Override
    public Set getTemplateSlots(Cls cls) {
        LinkedHashSet<Cls> clses = new LinkedHashSet<Cls>(this.getSuperclasses(cls));
        clses.add(cls);
        Set values = this.collectOwnSlotValues(clses, this._systemFrames.getDirectTemplateSlotsSlot());
        this.addSubslotsInDomain(values, cls);
        return SimpleFrameStore.unmodifiableSet(values);
    }

    private void addSubslotsInDomain(Collection slots, Cls domain) {
        for (Slot slot : new HashSet(slots)) {
            this.addSubslotsInDomain(slot, domain, slots);
        }
    }

    private void addSubslotsInDomain(Slot slot, Cls domain, Collection slots) {
        for (Slot subslot : this.getSubslots(slot)) {
            if (!this.isInDomain(subslot, domain)) continue;
            slots.add(subslot);
        }
    }

    private boolean isInDomain(Slot subslot, Cls cls) {
        List directDomain = this.getDirectDomain(subslot);
        boolean isInDomain = directDomain.isEmpty();
        for (Cls directDomainCls : directDomain) {
            if (!this.getSuperclasses(cls).contains(directDomainCls)) continue;
            isInDomain = true;
            break;
        }
        return isInDomain;
    }

    @Override
    public Set getDomain(Slot slot) {
        Set domain = this.getClosure(this.getDirectDomain(slot), this._systemFrames.getDirectSubclassesSlot());
        if (domain.isEmpty()) {
            this.addSuperslotsDomain(slot, domain);
        }
        return domain;
    }

    private void addSuperslotsDomain(Slot slot, Set domain) {
        for (Slot superslot : this.getDirectSuperslots(slot)) {
            domain.addAll(this.getDomain(superslot));
        }
    }

    private Set getClosure(Collection startValues, Slot propagationSlot) {
        HashSet closure = new HashSet(startValues);
        for (Object o : startValues) {
            if (!(o instanceof Instance)) continue;
            Instance instance = (Instance)o;
            closure.addAll(this.getDirectOwnSlotValuesClosure(instance, propagationSlot));
        }
        return closure;
    }

    @Override
    public List getDirectDomain(Slot slot) {
        return this.getDirectOwnSlotValues(slot, this._systemFrames.getDirectDomainSlot());
    }

    @Override
    public void addDirectSuperclass(Cls cls, Cls superclass) {
        this.addDirectOwnSlotValuePair(cls, this._systemFrames.getDirectSuperclassesSlot(), this._systemFrames.getDirectSubclassesSlot(), superclass);
    }

    @Override
    public void removeDirectSuperclass(Cls cls, Cls superclass) {
        this.removeDirectOwnSlotValuePair(cls, this._systemFrames.getDirectSuperclassesSlot(), this._systemFrames.getDirectSubclassesSlot(), superclass);
    }

    @Override
    public void addDirectSuperslot(Slot slot, Slot superslot) {
        this.addDirectOwnSlotValuePair(slot, this._systemFrames.getDirectSuperslotsSlot(), this._systemFrames.getDirectSubslotsSlot(), superslot);
    }

    @Override
    public void removeDirectSuperslot(Slot slot, Slot superslot) {
        this.removeDirectOwnSlotValuePair(slot, this._systemFrames.getDirectSuperslotsSlot(), this._systemFrames.getDirectSubslotsSlot(), superslot);
    }

    @Override
    public void addDirectType(Instance instance, Cls type) {
        this.addDirectOwnSlotValuePair(instance, this._systemFrames.getDirectTypesSlot(), this._systemFrames.getDirectInstancesSlot(), type);
        this.swizzleInstance(instance);
    }

    public void swizzleInstance(Instance instance) {
        boolean isCorrectClass;
        FrameFactory factory = this.getFrameFactory();
        List types = this.getDirectTypes(instance);
        FrameID id = instance.getFrameID();
        Class interfac = this.getFrameInterface(types);
        boolean bl = isCorrectClass = interfac == null || interfac.isInstance(instance);
        if (!(isCorrectClass &= factory.isCorrectJavaImplementationClass(id, types, instance.getClass()))) {
            Instance newInstance = interfac.equals(Cls.class) ? factory.createCls(id, types) : (interfac.equals(Slot.class) ? factory.createSlot(id, types) : (interfac.equals(Facet.class) ? factory.createFacet(id, types) : factory.createSimpleInstance(id, types)));
            SimpleFrameStore.updateNewInstance(newInstance, instance);
            this._helper.replaceFrame(newInstance);
            this.nameToFrameMap.put(this.getFrameName(newInstance), newInstance);
        }
    }

    private Class getFrameInterface(Collection directTypes) {
        Set types = this.getTypes(directTypes);
        Class interfac = types.isEmpty() ? null : (types.contains(this._systemFrames.getRootClsMetaCls()) ? Cls.class : (types.contains(this._systemFrames.getRootSlotMetaCls()) ? Slot.class : (types.contains(this._systemFrames.getRootFacetMetaCls()) ? Facet.class : SimpleInstance.class)));
        return interfac;
    }

    private Set getTypes(Collection directTypes) {
        HashSet types = new HashSet(directTypes);
        for (Cls directType : directTypes) {
            types.addAll(this.getSuperclasses(directType));
        }
        return types;
    }

    private static void updateNewInstance(Instance newInstance, Instance oldInstance) {
        newInstance.setEditable(oldInstance.isEditable());
        newInstance.setIncluded(oldInstance.isIncluded());
    }

    private void addDirectOwnSlotValuePair(Frame source, Slot sourceSlot, Slot targetSlot, Frame target) {
        this.addDirectOwnSlotValue(source, sourceSlot, target);
        this.addDirectOwnSlotValue(target, targetSlot, source);
    }

    private void removeDirectOwnSlotValuePair(Frame source, Slot sourceSlot, Slot targetSlot, Frame target) {
        this.removeDirectOwnSlotValue(source, sourceSlot, target);
        this.removeDirectOwnSlotValue(target, targetSlot, source);
    }

    @Override
    public void removeDirectType(Instance instance, Cls type) {
        this.removeDirectOwnSlotValuePair(instance, this._systemFrames.getDirectTypesSlot(), this._systemFrames.getDirectInstancesSlot(), type);
        this.swizzleInstance(instance);
    }

    @Override
    public void moveDirectType(Instance instance, Cls type, int index) {
        int from = this.getDirectTypes(instance).indexOf(type);
        this.moveDirectOwnSlotValue(instance, this._systemFrames.getDirectTypesSlot(), from, index);
    }

    @Override
    public void moveDirectSubclass(Cls cls, Cls subclass, int index) {
        int from = this.getDirectSubclasses(cls).indexOf(subclass);
        this.moveDirectOwnSlotValue(cls, this._systemFrames.getDirectSubclassesSlot(), from, index);
    }

    @Override
    public void moveDirectSubslot(Slot slot, Slot subslot, int index) {
        int from = this.getDirectSubslots(slot).indexOf(subslot);
        this.moveDirectOwnSlotValue(slot, this._systemFrames.getDirectSubslotsSlot(), from, index);
    }

    @Override
    public void addDirectTemplateSlot(Cls cls, Slot slot) {
        this.addDirectOwnSlotValuePair(cls, this._systemFrames.getDirectTemplateSlotsSlot(), this._systemFrames.getDirectDomainSlot(), slot);
    }

    @Override
    public void moveDirectTemplateSlot(Cls cls, Slot slot, int index) {
        int from = this.getDirectTemplateSlots(cls).indexOf(slot);
        this.moveDirectOwnSlotValue(cls, this._systemFrames.getDirectTemplateSlotsSlot(), from, index);
    }

    @Override
    public void removeDirectTemplateSlot(Cls cls, Slot slot) {
        this.removeDirectOwnSlotValuePair(cls, this._systemFrames.getDirectTemplateSlotsSlot(), this._systemFrames.getDirectDomainSlot(), slot);
    }

    public void addDirectOwnSlotValue(Frame frame, Slot slot, Object value) {
        this.addDirectOwnSlotValues(frame, slot, Collections.singleton(value));
    }

    public void removeDirectOwnSlotValue(Frame frame, Slot slot, Object value) {
        this._helper.removeValue(frame, slot, null, false, value);
    }

    @Override
    public void moveDirectOwnSlotValue(Frame frame, Slot slot, int from, int to) {
        this._helper.moveValue(frame, slot, null, false, from, to);
    }

    public void addDirectOwnSlotValues(Frame frame, Slot slot, Collection values) {
        this.addValues(frame, slot, null, false, values);
    }

    private void addValues(Frame frame, Slot slot, Facet facet, boolean isTemplate, Collection values) {
        this._helper.addValues(frame, slot, facet, isTemplate, values);
    }

    @Override
    public Cls createCls(FrameID id, Collection directTypes, Collection directSuperclasses, boolean loadDefaults) {
        Cls cls = this.createCls(id, directTypes);
        this.addCls(cls, directTypes, directSuperclasses, loadDefaults);
        this.assertFrameName(cls);
        return cls;
    }

    @Override
    public Slot createSlot(FrameID id, Collection directTypes, Collection directSuperslots, boolean loadDefaults) {
        Slot slot = this.createSlot(id, directTypes);
        this.addSlot(slot, directTypes, directSuperslots, loadDefaults);
        this.assertFrameName(slot);
        return slot;
    }

    @Override
    public SimpleInstance createSimpleInstance(FrameID id, Collection directTypes, boolean loadDefaults) {
        SimpleInstance simpleInstance = this.createSimpleInstance(id, directTypes);
        this.addSimpleInstance(simpleInstance, directTypes, loadDefaults);
        this.assertFrameName(simpleInstance);
        return simpleInstance;
    }

    @Override
    public Facet createFacet(FrameID id, Collection directTypes, boolean loadDefaults) {
        Facet facet = this.createFacet(id, directTypes);
        this.addFacet(facet, directTypes, loadDefaults);
        this.assertFrameName(facet);
        return facet;
    }

    private void assertFrameName(Frame frame) {
        this._helper.setValues(frame, this._systemFrames.getNameSlot(), null, false, Collections.singleton(frame.getName()));
    }

    private void addSimpleInstance(SimpleInstance simpleInstance, Collection directTypes, boolean loadDefaults) {
        this.addInstance(simpleInstance, directTypes, loadDefaults);
    }

    protected void addCls(Cls cls, Collection directTypes, Collection directSuperclasses, boolean loadDefaults) {
        this.addInstance(cls, directTypes, loadDefaults);
        this.addDirectOwnSlotValuePairs(cls, this._systemFrames.getDirectSuperclassesSlot(), this._systemFrames.getDirectSubclassesSlot(), directSuperclasses);
    }

    protected void addSlot(Slot slot, Collection directTypes, Collection directSuperslots, boolean loadDefaults) {
        if (!directSuperslots.isEmpty()) {
            loadDefaults = false;
        }
        this.addInstance(slot, directTypes, loadDefaults);
        if (!directSuperslots.isEmpty()) {
            this.addDirectOwnSlotValuePairs(slot, this._systemFrames.getDirectSuperslotsSlot(), this._systemFrames.getDirectSubslotsSlot(), directSuperslots);
        }
    }

    private void addDirectOwnSlotValuePairs(Frame source, Slot sourceSlot, Slot targetSlot, Collection targets) {
        this.addDirectOwnSlotValues(source, sourceSlot, targets);
        for (Frame target : targets) {
            this.addDirectOwnSlotValue(target, targetSlot, source);
        }
    }

    private void addFacet(Facet facet, Collection directTypes, boolean loadDefaults) {
        this.addInstance(facet, directTypes, loadDefaults);
    }

    private void addInstance(Instance instance, Collection directTypes, boolean loadDefaults) {
        this.addDirectOwnSlotValuePairs(instance, this._systemFrames.getDirectTypesSlot(), this._systemFrames.getDirectInstancesSlot(), directTypes);
        if (loadDefaults) {
            this.addDefaults(instance, directTypes);
        }
    }

    private Slot getInverseSlot(Slot slot) {
        return (Slot)this.getDirectOwnSlotValue(slot, this._systemFrames.getInverseSlotSlot());
    }

    @Override
    public Collection getOwnSlotValues(Frame frame, Slot slot) {
        ArrayList values = new ArrayList();
        this.addOwnSlotValues(frame, slot, values);
        return SimpleFrameStore.unmodifiableCollection(values);
    }

    private void addOwnSlotValues(Frame frame, Slot slot, Collection values) {
        values.addAll(this.getDirectOwnSlotValues(frame, slot));
        this.addInheritedTemplateSlotValues(frame, slot, values);
        this.addSubslotValues(frame, slot, values);
        this.addInferredInverseSlotValues(frame, slot, values);
        if (frame instanceof Slot && values.isEmpty() && this.isInheritedSuperslotSlot(slot)) {
            this.addInheritedSuperslotValues((Slot)frame, slot, values);
        }
    }

    private void addInferredInverseSlotValues(Frame frame, Slot slot, Collection values) {
        Slot inverseSlot = this.getInverseSlot(slot);
        if (inverseSlot != null) {
            Collection referencingClasses = this.getTemplateSlotValuesReferences(frame, inverseSlot);
            for (Cls cls : referencingClasses) {
                values.addAll(this.getInstances(cls));
            }
        }
    }

    private Collection getTemplateSlotValuesReferences(Frame frame, Slot slot) {
        HashSet<Frame> references = new HashSet<Frame>();
        references.addAll(this._helper.getFrames(slot, this._systemFrames.getValuesFacet(), true, frame));
        return references;
    }

    private boolean isInheritedSuperslotSlot(Slot slot) {
        return this._inheritedSuperslotSlots.contains(slot);
    }

    private void addInheritedSuperslotValues(Slot slotFrame, Slot slot, Collection values) {
        Facet facet = (Facet)this.getDirectOwnSlotValue(slot, this._systemFrames.getAssociatedFacetSlot());
        for (Slot superslot : this.getSuperslots(slotFrame)) {
            List superslotValues = this.getDirectOwnSlotValues(superslot, slot);
            if (facet == null) {
                values.addAll(superslotValues);
                continue;
            }
            Collection resolvedValues = facet.resolveValues(values, superslotValues);
            if (((Object)resolvedValues).equals(values)) continue;
            values.clear();
            values.addAll(resolvedValues);
        }
    }

    private void addInheritedTemplateSlotValues(Frame frame, Slot slot, Collection values) {
        if (frame instanceof Instance) {
            LinkedHashSet templateSlotValues = new LinkedHashSet();
            Instance instance = (Instance)frame;
            for (Cls type : this.getTypes(instance)) {
                templateSlotValues.addAll(this.getDirectTemplateSlotValues(type, slot));
            }
            templateSlotValues.addAll(this.getDirectOwnSlotValues(slot, this._systemFrames.getValuesSlot()));
            values.addAll(templateSlotValues);
        }
    }

    private void addSubslotValues(Frame frame, Slot slot, Collection values) {
        for (Slot subslot : this.getSubslots(slot)) {
            values.addAll(this.getDirectOwnSlotValues(frame, subslot));
        }
    }

    @Override
    public List getDirectOwnSlotValues(Frame frame, Slot slot) {
        List values = this.getValues(frame, slot, null, false);
        return SimpleFrameStore.unmodifiableList(values);
    }

    @Override
    public int getDirectOwnSlotValuesCount(Frame frame, Slot slot) {
        return this._helper.getValuesCount(frame, slot, null, false);
    }

    private List getValues(Frame frame, Slot slot, Facet facet, boolean isTemplate) {
        return this._helper.getValues(frame, slot, facet, isTemplate);
    }

    private Object getValue(Frame frame, Slot slot, Facet facet, boolean isTemplate) {
        List values = this._helper.getValues(frame, slot, facet, isTemplate);
        return values.isEmpty() ? null : values.get(0);
    }

    private void setValues(Frame frame, Slot slot, Facet facet, boolean isTemplate, Collection values) {
        this._helper.setValues(frame, slot, facet, isTemplate, values);
    }

    @Override
    public void setDirectOwnSlotValues(Frame frame, Slot slot, Collection newValues) {
        Slot inverseSlot = this.getInverseSlot(slot);
        if (inverseSlot != null) {
            this.removeInverseLinksFromCurrentValues(frame, slot, inverseSlot);
            if (newValues != null && !newValues.isEmpty()) {
                this.addLinksFromNewValues(frame, slot, newValues, inverseSlot);
            }
        }
        this._helper.setValues(frame, slot, null, false, newValues);
    }

    private boolean hasOwnSlot(Frame frame, Slot slot) {
        return this.getOwnSlots(frame).contains(slot);
    }

    private void addLinksFromNewValues(Frame frame, Slot slot, Collection newValues, Slot inverseSlot) {
        boolean isInverseSlotSingleCardinality = this.isCardinalitySingle(inverseSlot);
        for (Object o : newValues) {
            Frame targetTarget;
            Object o2;
            Frame target;
            if (!(o instanceof Frame) || !this.hasOwnSlot(target = (Frame)o, inverseSlot)) continue;
            if (isInverseSlotSingleCardinality && (o2 = this.getDirectOwnSlotValue(target, inverseSlot)) instanceof Frame && (targetTarget = (Frame)o2) != null && !targetTarget.equals(frame)) {
                this.removeDirectOwnSlotValue(targetTarget, slot, target);
                this.removeDirectOwnSlotValue(target, inverseSlot, targetTarget);
            }
            if (this.getDirectOwnSlotValues(target, inverseSlot).contains(frame)) continue;
            this.addDirectOwnSlotValue(target, inverseSlot, frame);
        }
    }

    private boolean isCardinalitySingle(Slot slot) {
        Number n = (Number)this.getDirectOwnSlotValue(slot, this._systemFrames.getMaximumCardinalitySlot());
        return n != null && n.intValue() == 1;
    }

    private void removeInverseLinksFromCurrentValues(Frame frame, Slot slot, Slot inverseSlot) {
        List currentValues = this.getDirectOwnSlotValues(frame, slot);
        if (!currentValues.isEmpty()) {
            for (Object o : new ArrayList(currentValues)) {
                if (!(o instanceof Frame)) continue;
                Frame target = (Frame)o;
                this.removeDirectOwnSlotValue(target, inverseSlot, frame);
            }
        }
    }

    @Override
    public List getDirectTemplateSlotValues(Cls cls, Slot slot) {
        return this.getValues(cls, slot, this._systemFrames.getValuesFacet(), true);
    }

    @Override
    public void setDirectTemplateSlotValues(Cls cls, Slot slot, Collection values) {
        this.setValues(cls, slot, this._systemFrames.getValuesFacet(), true, values);
    }

    @Override
    public List getDirectTemplateFacetValues(Cls cls, Slot slot, Facet facet) {
        return this.getValues(cls, slot, facet, true);
    }

    private Slot getAssociatedSlot(Facet facet) {
        List slots = this.getDirectOwnSlotValues(facet, this._systemFrames.getAssociatedSlotSlot());
        return (Slot)CollectionUtilities.getFirstItem(slots);
    }

    @Override
    public void setDirectTemplateFacetValues(Cls cls, Slot slot, Facet facet, Collection values) {
        List topLevelValues;
        Slot associatedSlot = this.getAssociatedSlot(facet);
        if (associatedSlot != null && CollectionUtilities.equalsList(topLevelValues = this.getDirectOwnSlotValues(slot, associatedSlot), values)) {
            values = Collections.EMPTY_LIST;
        }
        this.setValues(cls, slot, facet, true, values);
    }

    @Override
    public Set<Frame> getFramesWithDirectOwnSlotValue(Slot slot, Object value) {
        return this._helper.getFrames(slot, null, false, value);
    }

    @Override
    public Set<Frame> getFramesWithAnyDirectOwnSlotValue(Slot slot) {
        return this._helper.getFramesWithAnyValue(slot, null, false);
    }

    @Override
    public Set getClsesWithDirectTemplateSlotValue(Slot slot, Object value) {
        return this._helper.getFrames(slot, this._systemFrames.getValuesFacet(), true, value);
    }

    @Override
    public Set<Cls> getClsesWithAnyDirectTemplateSlotValue(Slot slot) {
        return this._helper.getFramesWithAnyValue(slot, this._systemFrames.getValuesFacet(), true);
    }

    @Override
    public Set getClsesWithDirectTemplateFacetValue(Slot slot, Facet facet, Object value) {
        return this._helper.getFrames(slot, facet, true, value);
    }

    @Override
    public Set<Frame> getFramesWithMatchingDirectOwnSlotValue(Slot slot, String value, int maxMatches) {
        return this._helper.getMatchingFrames(slot, null, false, value, maxMatches);
    }

    @Override
    public Set getClsesWithMatchingDirectTemplateSlotValue(Slot slot, String value, int maxMatches) {
        return this._helper.getMatchingFrames(slot, null, true, value, maxMatches);
    }

    @Override
    public Set getClsesWithMatchingDirectTemplateFacetValue(Slot slot, Facet facet, String value, int maxMatches) {
        return this._helper.getMatchingFrames(slot, facet, true, value, maxMatches);
    }

    private Object getDirectOwnSlotValue(Frame frame, Slot slot) {
        return this.getValue(frame, slot, null, false);
    }

    @Override
    public String getFrameName(Frame frame) {
        String name = (String)this.getDirectOwnSlotValue(frame, this._systemFrames.getNameSlot());
        if (name == null) {
            name = "<<missing frame name for " + frame.getFrameID() + ">>";
        }
        return name;
    }

    protected void addSystemFrames() {
        this._systemFrames.addSystemFrames(this);
    }

    protected Cls createCls(FrameID id, Collection directTypes) {
        return this.getFrameFactory().createCls(id, directTypes);
    }

    protected Slot createSlot(FrameID id, Collection directTypes) {
        return this.getFrameFactory().createSlot(id, directTypes);
    }

    protected Facet createFacet(FrameID id, Collection directTypes) {
        return this.getFrameFactory().createFacet(id, directTypes);
    }

    protected SimpleInstance createSimpleInstance(FrameID id, Collection directTypes) {
        return this.getFrameFactory().createSimpleInstance(id, directTypes);
    }

    private void addDefaults(Instance instance, Collection directTypes) {
        for (Cls type : directTypes) {
            this.addDefaults(instance, type);
        }
    }

    private void addDefaults(Instance instance, Cls type) {
        for (Slot slot : this.getTemplateSlots(type)) {
            this.addDefault(instance, type, slot);
        }
    }

    private void addDefault(Instance instance, Cls type, Slot slot) {
        Collection values = this.getTemplateFacetValues(type, slot, this._systemFrames.getDefaultValuesFacet());
        if (!values.isEmpty()) {
            Slot inverseSlot = slot.getInverseSlot();
            if (inverseSlot == null) {
                this.addDirectOwnSlotValues(instance, slot, values);
            } else {
                for (Frame value : values) {
                    this.addDirectOwnSlotValuePair(instance, slot, inverseSlot, value);
                }
            }
        }
    }

    @Override
    public Set getOwnFacets(Frame frame, Slot slot) {
        HashSet<Facet> facets = new HashSet<Facet>();
        for (Slot ownSlot : this.getOwnSlots(slot)) {
            Facet facet = (Facet)this.getDirectOwnSlotValue(ownSlot, this._systemFrames.getAssociatedFacetSlot());
            if (facet == null) continue;
            facets.add(facet);
        }
        return facets;
    }

    @Override
    public Collection getOwnFacetValues(Frame frame, Slot slot, Facet facet) {
        Collection values = new ArrayList();
        for (Cls cls : this.getDirectTypes((Instance)frame)) {
            Collection typeValues = this.getTemplateFacetValues(cls, slot, facet);
            values = SimpleFrameStore.resolveValues(values, typeValues, facet);
        }
        return values;
    }

    @Override
    public Set getOverriddenTemplateSlots(Cls cls) {
        LinkedHashSet overriddenSlots = new LinkedHashSet(this.getTemplateSlots(cls));
        Iterator i = overriddenSlots.iterator();
        while (i.hasNext()) {
            Slot slot = (Slot)i.next();
            if (this.isOverridden(cls, slot)) continue;
            i.remove();
        }
        return overriddenSlots;
    }

    @Override
    public Set getDirectlyOverriddenTemplateSlots(Cls cls) {
        LinkedHashSet overriddenSlots = new LinkedHashSet(this.getTemplateSlots(cls));
        Iterator i = overriddenSlots.iterator();
        while (i.hasNext()) {
            Slot slot = (Slot)i.next();
            if (this.isDirectlyOverridden(cls, slot)) continue;
            i.remove();
        }
        return overriddenSlots;
    }

    @Override
    public Set getOverriddenTemplateFacets(Cls cls, Slot slot) {
        LinkedHashSet<Facet> overriddenFacets = new LinkedHashSet<Facet>(this.getTemplateFacets(cls, slot));
        Iterator i = overriddenFacets.iterator();
        while (i.hasNext()) {
            Facet facet = (Facet)i.next();
            if (this.isOverridden(cls, slot, facet)) continue;
            i.remove();
        }
        return overriddenFacets;
    }

    @Override
    public Set getDirectlyOverriddenTemplateFacets(Cls cls, Slot slot) {
        LinkedHashSet<Facet> overriddenFacets = new LinkedHashSet<Facet>(this.getTemplateFacets(cls, slot));
        Iterator i = overriddenFacets.iterator();
        while (i.hasNext()) {
            Facet facet = (Facet)i.next();
            if (this.isDirectlyOverridden(cls, slot, facet)) continue;
            i.remove();
        }
        return overriddenFacets;
    }

    private boolean isDirectlyOverridden(Cls cls, Slot slot) {
        return !this.getDirectlyOverriddenTemplateFacets(cls, slot).isEmpty();
    }

    private boolean isOverridden(Cls cls, Slot slot) {
        return !this.getOverriddenTemplateFacets(cls, slot).isEmpty();
    }

    private boolean isDirectlyOverridden(Cls cls, Slot slot, Facet facet) {
        return !this.getDirectTemplateFacetValues(cls, slot, facet).isEmpty();
    }

    private boolean isOverridden(Cls cls, Slot slot, Facet facet) {
        List topLevelValues;
        HashSet facetValues = new HashSet(this.getTemplateFacetValues(cls, slot, facet));
        return !CollectionUtilities.equalsSet(facetValues, topLevelValues = this.getDirectOwnSlotValues(slot, facet.getAssociatedSlot()));
    }

    @Override
    public void removeDirectTemplateFacetOverrides(Cls cls, Slot slot) {
        Set<Facet> facets = this.getTemplateFacets(cls, slot);
        for (Facet facet : facets) {
            this.setDirectTemplateFacetValues(cls, slot, facet, Collections.EMPTY_LIST);
        }
    }

    @Override
    public boolean beginTransaction(String name) {
        return this._helper.beginTransaction(name);
    }

    @Override
    public boolean commitTransaction() {
        return this._helper.commitTransaction();
    }

    @Override
    public boolean rollbackTransaction() {
        return this._helper.rollbackTransaction();
    }

    @Override
    public TransactionMonitor getTransactionStatusMonitor() {
        return this._helper.getTransactionStatusMonitor();
    }

    @Override
    public List<AbstractEvent> getEvents() {
        return Collections.EMPTY_LIST;
    }

    @Override
    public void setDelegate(FrameStore fs) {
        Log.getLogger().severe("Unable to set delegate: " + fs.getName());
    }

    @Override
    public FrameStore getDelegate() {
        return null;
    }

    public String toString() {
        return StringUtilities.getClassName(this);
    }

    @Override
    public void replaceFrame(Frame original, Frame replacement) {
        this.nameToFrameMap.remove(original.getFrameID().getName());
        this._helper.replaceFrame(original, replacement);
    }
}

