/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.model.framestore;

import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.model.framestore.AbstractFrameStoreInvocationHandler;
import edu.stanford.smi.protege.model.framestore.FrameStore;
import edu.stanford.smi.protege.model.query.Query;
import edu.stanford.smi.protege.model.query.QueryCallback;
import edu.stanford.smi.protege.util.Log;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

public class TraceFrameStoreHandler
extends AbstractFrameStoreInvocationHandler {
    private Map<Method, Integer> methodCounts = new HashMap<Method, Integer>();
    private static Method executeQueryMethod;

    public Object handleInvoke(Method m, Object[] args) {
        Object o = this.invoke(m, args);
        this.trace(m, args);
        return o;
    }

    protected void executeQuery(Query q, QueryCallback qc) {
        this.getDelegate().executeQuery(q, qc);
        Integer next = this.updateMethodCount(executeQueryMethod);
        TraceFrameStoreHandler.print(next, executeQueryMethod, new Object[]{q, qc});
    }

    private void trace(Method method, Object[] args) {
        Integer next = this.updateMethodCount(method);
        TraceFrameStoreHandler.print(next, method, args);
    }

    private Integer updateMethodCount(Method method) {
        Integer current = this.methodCounts.get(method);
        Integer next = current == null ? new Integer(1) : new Integer(current + 1);
        this.methodCounts.put(method, next);
        return next;
    }

    public static void print(int next, Method method, Object[] args) {
        Log.getLogger().info(next + " " + method.getName() + " " + TraceFrameStoreHandler.argString(args));
    }

    private static String argString(Object[] args) {
        StringBuffer buffer = new StringBuffer();
        if (args != null) {
            for (int i = 0; i < args.length; ++i) {
                Object o = args[i];
                if (o instanceof Frame) {
                    o = ((Frame)o).getFrameID();
                }
                buffer.append(o);
                buffer.append(" ");
            }
        }
        return buffer.toString();
    }

    static {
        try {
            executeQueryMethod = FrameStore.class.getMethod("executeQuery", Query.class, QueryCallback.class);
        }
        catch (Exception e) {
            Log.getLogger().warning("Non-fatal Problem encountered finding executeQuery method - contact developers");
        }
    }
}

