/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.model.framestore.cleandispatch;

import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.model.framestore.FrameStore;
import edu.stanford.smi.protege.model.framestore.cleandispatch.Dispatch;
import edu.stanford.smi.protege.util.Log;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;

abstract class AbstractRedirectingDispatch
implements Dispatch {
    AbstractRedirectingDispatch() {
    }

    public List getDirectOwnSlotValues(FrameStore delegate, Frame frame, Slot slot) {
        List values;
        if (this.isCorrectFrameType(frame)) {
            values = this.getCurrentValues(delegate, frame);
        } else {
            Log.getLogger().warning("Invalid frame type: " + frame);
            values = delegate.getDirectOwnSlotValues(frame, slot);
        }
        return values;
    }

    public void setDirectOwnSlotValues(FrameStore delegate, Frame frame, Slot slot, Collection newValues) {
        if (this.isCorrectFrameType(frame)) {
            LinkedHashSet currentValues = new LinkedHashSet(this.getCurrentValues(delegate, frame));
            this.addValues(delegate, frame, currentValues, newValues);
            this.removeValues(delegate, frame, currentValues, newValues);
        } else {
            Log.getLogger().warning("Invalid frame type: " + frame);
            delegate.setDirectOwnSlotValues(frame, slot, newValues);
        }
    }

    private void addValues(FrameStore delegate, Frame frame, Collection currentValues, Collection newValues) {
        LinkedHashSet valuesToAdd = new LinkedHashSet(newValues);
        valuesToAdd.removeAll(currentValues);
        for (Object value : valuesToAdd) {
            if (this.isCorrectValueType(value)) {
                this.addValue(delegate, frame, value);
                continue;
            }
            Log.getLogger().warning("Ignoring invalid value: " + value);
        }
    }

    private void removeValues(FrameStore delegate, Frame frame, Collection currentValues, Collection newValues) {
        LinkedHashSet valuesToRemove = new LinkedHashSet(currentValues);
        valuesToRemove.removeAll(newValues);
        for (Object value : valuesToRemove) {
            if (this.isCorrectValueType(value)) {
                this.removeValue(delegate, frame, value);
                continue;
            }
            Log.getLogger().warning("Ignoring invalid value: " + value);
        }
    }

    abstract List getCurrentValues(FrameStore var1, Frame var2);

    abstract void addValue(FrameStore var1, Frame var2, Object var3);

    abstract void removeValue(FrameStore var1, Frame var2, Object var3);

    abstract boolean isCorrectFrameType(Frame var1);

    abstract boolean isCorrectValueType(Object var1);
}

