/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.model.framestore.cleandispatch;

import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.model.framestore.FrameStore;
import edu.stanford.smi.protege.model.framestore.FrameStoreAdapter;
import edu.stanford.smi.protege.model.framestore.cleandispatch.DefaultDispatch;
import edu.stanford.smi.protege.model.framestore.cleandispatch.DirectDomainDispatch;
import edu.stanford.smi.protege.model.framestore.cleandispatch.DirectInstancesDispatch;
import edu.stanford.smi.protege.model.framestore.cleandispatch.DirectSubclassesDispatch;
import edu.stanford.smi.protege.model.framestore.cleandispatch.DirectSubslotsDispatch;
import edu.stanford.smi.protege.model.framestore.cleandispatch.DirectSuperclassesDispatch;
import edu.stanford.smi.protege.model.framestore.cleandispatch.DirectSuperslotsDispatch;
import edu.stanford.smi.protege.model.framestore.cleandispatch.DirectTemplateSlotsDispatch;
import edu.stanford.smi.protege.model.framestore.cleandispatch.DirectTypesDispatch;
import edu.stanford.smi.protege.model.framestore.cleandispatch.Dispatch;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CleanDispatchFrameStore
extends FrameStoreAdapter {
    private Map _slotToDispatchMap = new HashMap();
    private Dispatch _defaultDispatch;

    public void setDelegate(FrameStore frameStore) {
        super.setDelegate(frameStore);
        this._slotToDispatchMap.clear();
        if (frameStore != null) {
            this.loadDispatches();
        }
    }

    public void close() {
        this._slotToDispatchMap = null;
        this._defaultDispatch = null;
    }

    public List getDirectOwnSlotValues(Frame frame, Slot slot) {
        return this.getDispatch(slot).getDirectOwnSlotValues(this.getDelegate(), frame, slot);
    }

    public void setDirectOwnSlotValues(Frame frame, Slot slot, Collection values) {
        this.getDispatch(slot).setDirectOwnSlotValues(this.getDelegate(), frame, slot, values);
    }

    private void addDispatch(String slotName, Dispatch dispatch) {
        Slot slot = (Slot)this.getDelegate().getFrame(slotName);
        this._slotToDispatchMap.put(slot, dispatch);
    }

    private void loadDispatches() {
        this._defaultDispatch = new DefaultDispatch();
        this.addDispatch(":DIRECT-INSTANCES", new DirectInstancesDispatch());
        this.addDispatch(":DIRECT-TYPE", new DirectTypesDispatch());
        this.addDispatch(":DIRECT-SUBCLASSES", new DirectSubclassesDispatch());
        this.addDispatch(":DIRECT-SUPERCLASSES", new DirectSuperclassesDispatch());
        this.addDispatch(":DIRECT-SUBSLOTS", new DirectSubslotsDispatch());
        this.addDispatch(":DIRECT-SUPERSLOTS", new DirectSuperslotsDispatch());
        this.addDispatch(":DIRECT-TEMPLATE-SLOTS", new DirectTemplateSlotsDispatch());
        this.addDispatch(":DIRECT-DOMAIN", new DirectDomainDispatch());
    }

    private Dispatch getDispatch(Slot slot) {
        Dispatch dispatch = (Dispatch)this._slotToDispatchMap.get(slot);
        if (dispatch == null) {
            dispatch = this._defaultDispatch;
        }
        return dispatch;
    }
}

