/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.model.framestore.undo;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.FrameID;
import edu.stanford.smi.protege.model.framestore.FrameStore;
import edu.stanford.smi.protege.model.framestore.undo.AbstractCommand;
import java.util.ArrayList;
import java.util.Collection;

class CreateClsCommand
extends AbstractCommand {
    private Cls createdCls;
    private FrameID id;
    private Collection types;
    private Collection superclasses;
    private boolean loadDefaults;

    CreateClsCommand(FrameStore delegate, FrameID id, Collection types, Collection superclasses, boolean loadDefaults) {
        super(delegate);
        this.id = id;
        this.types = new ArrayList(types);
        this.superclasses = new ArrayList(superclasses);
        this.loadDefaults = loadDefaults;
    }

    public Object doIt() {
        this.createdCls = this.getDelegate().createCls(this.id, this.types, this.superclasses, this.loadDefaults);
        this.id = this.createdCls.getFrameID();
        this.setDescription("Create class " + CreateClsCommand.getText(this.createdCls));
        return this.createdCls;
    }

    public void undoIt() {
        this.getDelegate().deleteCls(this.createdCls);
        this.createdCls.markDeleted(true);
    }

    public void redoIt() {
        this.getDelegate().createCls(this.id, this.types, this.superclasses, this.loadDefaults);
        this.createdCls.markDeleted(false);
    }
}

