/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.model.framestore.undo;

import edu.stanford.smi.protege.model.Facet;
import edu.stanford.smi.protege.model.FrameID;
import edu.stanford.smi.protege.model.framestore.FrameStore;
import edu.stanford.smi.protege.model.framestore.undo.AbstractCommand;
import java.util.ArrayList;
import java.util.Collection;

class CreateFacetCommand
extends AbstractCommand {
    private boolean loadDefaults;
    private FrameID id;
    private Collection types;
    private Facet createdFacet;

    CreateFacetCommand(FrameStore delegate, FrameID id, Collection types, boolean loadDefaults) {
        super(delegate);
        this.id = id;
        this.types = new ArrayList(types);
        this.loadDefaults = loadDefaults;
    }

    public Object doIt() {
        this.createdFacet = this.getDelegate().createFacet(this.id, this.types, this.loadDefaults);
        this.id = this.createdFacet.getFrameID();
        this.setDescription("Create facet " + CreateFacetCommand.getText(this.createdFacet));
        return this.createdFacet;
    }

    public void undoIt() {
        this.getDelegate().deleteFacet(this.createdFacet);
        this.createdFacet.markDeleted(true);
    }

    public void redoIt() {
        this.getDelegate().createFacet(this.id, this.types, this.loadDefaults);
        this.createdFacet.markDeleted(false);
    }
}

