/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.model.framestore.undo;

import edu.stanford.smi.protege.model.FrameID;
import edu.stanford.smi.protege.model.SimpleInstance;
import edu.stanford.smi.protege.model.framestore.FrameStore;
import edu.stanford.smi.protege.model.framestore.undo.AbstractCommand;
import java.util.ArrayList;
import java.util.Collection;

class CreateSimpleInstanceCommand
extends AbstractCommand {
    private FrameID id;
    private Collection types;
    private boolean loadDefaults;
    private SimpleInstance createdInstance;

    CreateSimpleInstanceCommand(FrameStore delegate, FrameID id, Collection types, boolean loadDefaults) {
        super(delegate);
        this.id = id;
        this.types = new ArrayList(types);
        this.loadDefaults = loadDefaults;
    }

    public Object doIt() {
        this.createdInstance = this.getDelegate().createSimpleInstance(this.id, this.types, this.loadDefaults);
        this.id = this.createdInstance.getFrameID();
        this.setDescription("Create instance " + CreateSimpleInstanceCommand.getText(this.createdInstance) + " of type " + CreateSimpleInstanceCommand.getText(this.types));
        return this.createdInstance;
    }

    public void undoIt() {
        this.getDelegate().deleteSimpleInstance(this.createdInstance);
        this.createdInstance.markDeleted(true);
    }

    public void redoIt() {
        this.getDelegate().createSimpleInstance(this.id, this.types, this.loadDefaults);
        this.createdInstance.markDeleted(false);
    }
}

