/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.model.framestore.undo;

import edu.stanford.smi.protege.model.FrameID;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.model.framestore.FrameStore;
import edu.stanford.smi.protege.model.framestore.undo.AbstractCommand;
import java.util.ArrayList;
import java.util.Collection;

class CreateSlotCommand
extends AbstractCommand {
    private FrameID id;
    private Collection types;
    private Collection superslots;
    private boolean loadDefaults;
    private Slot createdSlot;

    CreateSlotCommand(FrameStore delegate, FrameID id, Collection types, Collection superslots, boolean loadDefaults) {
        super(delegate);
        this.id = id;
        this.loadDefaults = loadDefaults;
        this.types = new ArrayList(types);
        this.superslots = new ArrayList(superslots);
    }

    public Object doIt() {
        this.createdSlot = this.getDelegate().createSlot(this.id, this.types, this.superslots, this.loadDefaults);
        this.id = this.createdSlot.getFrameID();
        this.setDescription("Create slot " + CreateSlotCommand.getText(this.createdSlot));
        return this.createdSlot;
    }

    public void undoIt() {
        this.getDelegate().deleteSlot(this.createdSlot);
        this.createdSlot.markDeleted(true);
    }

    public void redoIt() {
        this.getDelegate().createSlot(this.id, this.types, this.superslots, this.loadDefaults);
        this.createdSlot.markDeleted(false);
    }
}

