/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.model.framestore.undo;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Facet;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.model.framestore.FrameStore;
import edu.stanford.smi.protege.model.framestore.undo.DeleteFrameCommand;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DeleteClsCommand
extends DeleteFrameCommand {
    private Map<Slot, Collection> directTemplateSlotValues = new HashMap<Slot, Collection>();
    private Map<Slot, Map<Facet, Collection>> directTemplateSlotFacetValues = new HashMap<Slot, Map<Facet, Collection>>();

    public DeleteClsCommand(FrameStore delegate, Cls cls) {
        super(delegate, cls);
    }

    public Cls getCls() {
        return (Cls)this.getFrame();
    }

    protected void saveFrame() {
        super.saveFrame();
        this.saveCls();
    }

    protected void restoreFrame() {
        super.restoreFrame();
        this.restoreCls();
    }

    private void saveCls() {
        Cls cls = this.getCls();
        Set templateSlots = this.getDelegate().getTemplateSlots(cls);
        for (Slot slot : templateSlots) {
            List values = this.getDelegate().getDirectTemplateSlotValues(cls, slot);
            if (values != null && !values.isEmpty()) {
                this.directTemplateSlotValues.put(slot, values);
            }
            HashMap<Facet, List> facetMap = new HashMap<Facet, List>();
            this.directTemplateSlotFacetValues.put(slot, facetMap);
            Set<Facet> facets = this.getDelegate().getTemplateFacets(cls, slot);
            for (Facet facet : facets) {
                List facetValues = this.getDelegate().getDirectTemplateFacetValues(cls, slot, facet);
                if (facetValues == null || facetValues.isEmpty()) continue;
                facetMap.put(facet, facetValues);
            }
        }
    }

    private void restoreCls() {
        Cls cls = this.getCls();
        for (Map.Entry<Slot, Collection> entry : this.directTemplateSlotValues.entrySet()) {
            this.getDelegate().setDirectTemplateSlotValues(cls, entry.getKey(), entry.getValue());
        }
        for (Map.Entry<Slot, Object> entry : this.directTemplateSlotFacetValues.entrySet()) {
            Slot slot = entry.getKey();
            for (Map.Entry facetEntry : ((Map)entry.getValue()).entrySet()) {
                this.getDelegate().setDirectTemplateFacetValues(cls, slot, (Facet)facetEntry.getKey(), (Collection)facetEntry.getValue());
            }
        }
    }
}

