/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.model.framestore.undo;

import edu.stanford.smi.protege.model.Facet;
import edu.stanford.smi.protege.model.FrameID;
import edu.stanford.smi.protege.model.framestore.FrameStore;
import edu.stanford.smi.protege.model.framestore.undo.SimpleCommand;
import java.util.ArrayList;
import java.util.Collection;

class DeleteFacetCommand
extends SimpleCommand {
    private Facet facet;
    private FrameID id;
    private Collection directTypes;

    DeleteFacetCommand(FrameStore delegate, Facet facet) {
        super(delegate);
        this.facet = facet;
        this.id = facet.getFrameID();
        this.directTypes = new ArrayList(facet.getDirectTypes());
        this.setDescription("Delete facet " + DeleteFacetCommand.getText(facet));
    }

    public Object doIt() {
        this.getDelegate().deleteFacet(this.facet);
        this.facet.markDeleted(true);
        return null;
    }

    public void undoIt() {
        this.getDelegate().createFacet(this.id, this.directTypes, false);
        this.facet.markDeleted(false);
    }
}

