/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.model.framestore.undo;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Facet;
import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.model.SimpleInstance;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.model.framestore.FrameStore;
import edu.stanford.smi.protege.model.framestore.undo.SimpleCommand;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DeleteFrameCommand
extends SimpleCommand {
    private Frame frame;
    private Map<Slot, Collection> directSlotValues = new HashMap<Slot, Collection>();

    public DeleteFrameCommand(FrameStore delegate, Frame frame) {
        super(delegate);
        this.frame = frame;
    }

    public Frame getFrame() {
        return this.frame;
    }

    public Object doIt() {
        this.saveFrame();
        this.deleteFrame();
        this.frame.markDeleted(true);
        return null;
    }

    public void undoIt() {
        this.restoreFrame();
        this.frame.markDeleted(false);
    }

    protected void saveFrame() {
        Set<Slot> slots = this.getDelegate().getOwnSlots(this.frame);
        for (Slot slot : slots) {
            List values = this.getDelegate().getDirectOwnSlotValues(this.frame, slot);
            if (values == null || values.isEmpty()) continue;
            this.directSlotValues.put(slot, values);
        }
    }

    protected void restoreFrame() {
        for (Map.Entry<Slot, Collection> entry : this.directSlotValues.entrySet()) {
            this.getDelegate().setDirectOwnSlotValues(this.frame, entry.getKey(), entry.getValue());
        }
    }

    private void deleteFrame() {
        if (this.frame instanceof Cls) {
            this.getDelegate().deleteCls((Cls)this.frame);
        } else if (this.frame instanceof Slot) {
            this.getDelegate().deleteSlot((Slot)this.frame);
        } else if (this.frame instanceof Facet) {
            this.getDelegate().deleteFacet((Facet)this.frame);
        } else {
            this.getDelegate().deleteSimpleInstance((SimpleInstance)this.frame);
        }
    }
}

