/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.model.framestore.undo;

import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.model.framestore.FrameStore;
import edu.stanford.smi.protege.model.framestore.undo.AbstractCommand;

class MoveDirectOwnSlotValueCommand
extends AbstractCommand {
    private Frame frame;
    private Slot slot;
    private int from;
    private int to;

    MoveDirectOwnSlotValueCommand(FrameStore delegate, Frame frame, Slot slot, int from, int to) {
        super(delegate);
        this.frame = frame;
        this.slot = slot;
        this.from = from;
        this.to = to;
        this.setDescription("Move own slot value of instance " + MoveDirectOwnSlotValueCommand.getText(frame) + " and slot " + MoveDirectOwnSlotValueCommand.getText(slot) + " from index " + from + " to index " + to);
    }

    public Object doIt() {
        this.getDelegate().moveDirectOwnSlotValue(this.frame, this.slot, this.from, this.to);
        return null;
    }

    public void undoIt() {
        this.getDelegate().moveDirectOwnSlotValue(this.frame, this.slot, this.to, this.from);
    }

    public void redoIt() {
        this.getDelegate().moveDirectOwnSlotValue(this.frame, this.slot, this.from, this.to);
    }
}

