/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.model.framestore.undo;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.framestore.FrameStore;
import edu.stanford.smi.protege.model.framestore.undo.AbstractCommand;

class MoveDirectSubclassCommand
extends AbstractCommand {
    private Cls cls;
    private int index;
    private Cls subclass;
    private int oldIndex;

    MoveDirectSubclassCommand(FrameStore delegate, Cls cls, int index, Cls subclass) {
        super(delegate);
        this.cls = cls;
        this.index = index;
        this.subclass = subclass;
        this.oldIndex = this.getDelegate().getDirectSubclasses(cls).indexOf(subclass);
        this.setDescription("Move subclass " + MoveDirectSubclassCommand.getText(subclass) + " of class " + MoveDirectSubclassCommand.getText(cls) + " to index " + index);
    }

    public Object doIt() {
        this.getDelegate().moveDirectSubclass(this.cls, this.subclass, this.index);
        return null;
    }

    public void undoIt() {
        this.getDelegate().moveDirectSubclass(this.cls, this.subclass, this.oldIndex);
    }

    public void redoIt() {
        this.getDelegate().moveDirectSubclass(this.cls, this.subclass, this.index);
    }
}

