/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.model.framestore.undo;

import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.model.framestore.FrameStore;
import edu.stanford.smi.protege.model.framestore.undo.AbstractCommand;

class MoveDirectSubslotCommand
extends AbstractCommand {
    private Slot slot;
    private int index;
    private Slot subslot;
    private int oldIndex;

    MoveDirectSubslotCommand(FrameStore delegate, Slot slot, int index, Slot subslot) {
        super(delegate);
        this.slot = slot;
        this.index = index;
        this.subslot = subslot;
        this.oldIndex = this.getDelegate().getDirectSubslots(slot).indexOf(subslot);
        this.setDescription("Move subslot " + MoveDirectSubslotCommand.getText(subslot) + " of slot " + MoveDirectSubslotCommand.getText(slot) + " to index " + index);
    }

    public Object doIt() {
        this.getDelegate().moveDirectSubslot(this.slot, this.subslot, this.index);
        return null;
    }

    public void undoIt() {
        this.getDelegate().moveDirectSubslot(this.slot, this.subslot, this.oldIndex);
    }

    public void redoIt() {
        this.getDelegate().moveDirectSubslot(this.slot, this.subslot, this.index);
    }
}

