/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.model.framestore.undo;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.model.framestore.FrameStore;
import edu.stanford.smi.protege.model.framestore.undo.AbstractCommand;

class MoveDirectTypeCommand
extends AbstractCommand {
    private Instance instance;
    private int index;
    private Cls type;
    private int oldIndex;

    MoveDirectTypeCommand(FrameStore delegate, Instance instance, Cls type, int index) {
        super(delegate);
        this.instance = instance;
        this.index = index;
        this.type = type;
        this.oldIndex = this.getDelegate().getDirectTypes(instance).indexOf(type);
        this.setDescription("Move type " + MoveDirectTypeCommand.getText(type) + " of instance " + MoveDirectTypeCommand.getText(instance) + " to index " + index);
    }

    public Object doIt() {
        this.getDelegate().moveDirectType(this.instance, this.type, this.index);
        return null;
    }

    public void undoIt() {
        this.getDelegate().moveDirectType(this.instance, this.type, this.oldIndex);
    }

    public void redoIt() {
        this.getDelegate().moveDirectType(this.instance, this.type, this.index);
    }
}

