/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.model.framestore.undo;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.model.framestore.FrameStore;
import edu.stanford.smi.protege.model.framestore.undo.AbstractCommand;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

class SetDirectTemplateSlotCommand
extends AbstractCommand {
    private Cls cls;
    private Slot slot;
    private Collection values;
    private List oldValues;

    SetDirectTemplateSlotCommand(FrameStore delegate, Cls cls, Collection values, Slot slot) {
        super(delegate);
        this.cls = cls;
        this.values = new ArrayList(values);
        this.slot = slot;
        String description = "Set template slot " + SetDirectTemplateSlotCommand.getText(slot) + " at class " + SetDirectTemplateSlotCommand.getText(cls) + " to values " + SetDirectTemplateSlotCommand.getText(values);
        this.setDescription(description);
    }

    public Object doIt() {
        this.oldValues = this.getDelegate().getDirectTemplateSlotValues(this.cls, this.slot);
        this.getDelegate().setDirectTemplateSlotValues(this.cls, this.slot, this.values);
        return null;
    }

    public void undoIt() {
        this.getDelegate().setDirectTemplateSlotValues(this.cls, this.slot, this.oldValues);
    }

    public void redoIt() {
        this.getDelegate().setDirectTemplateSlotValues(this.cls, this.slot, this.values);
    }
}

