/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.model.framestore.undo;

import edu.stanford.smi.protege.exception.TransactionException;
import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.CommandManager;
import edu.stanford.smi.protege.model.Facet;
import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.model.FrameID;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.model.SimpleInstance;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.model.framestore.ModificationFrameStore;
import edu.stanford.smi.protege.model.framestore.undo.AddDirectSuperclassCommand;
import edu.stanford.smi.protege.model.framestore.undo.AddDirectSuperslotCommand;
import edu.stanford.smi.protege.model.framestore.undo.AddDirectTemplateSlotCommand;
import edu.stanford.smi.protege.model.framestore.undo.AddDirectTypeCommand;
import edu.stanford.smi.protege.model.framestore.undo.Command;
import edu.stanford.smi.protege.model.framestore.undo.CreateClsCommand;
import edu.stanford.smi.protege.model.framestore.undo.CreateFacetCommand;
import edu.stanford.smi.protege.model.framestore.undo.CreateSimpleInstanceCommand;
import edu.stanford.smi.protege.model.framestore.undo.CreateSlotCommand;
import edu.stanford.smi.protege.model.framestore.undo.DeleteClsCommand;
import edu.stanford.smi.protege.model.framestore.undo.DeleteFrameCommand;
import edu.stanford.smi.protege.model.framestore.undo.DeleteSlotCommand;
import edu.stanford.smi.protege.model.framestore.undo.MacroCommand;
import edu.stanford.smi.protege.model.framestore.undo.MoveDirectOwnSlotValueCommand;
import edu.stanford.smi.protege.model.framestore.undo.MoveDirectSubclassCommand;
import edu.stanford.smi.protege.model.framestore.undo.MoveDirectSubslotCommand;
import edu.stanford.smi.protege.model.framestore.undo.MoveDirectTemplateSlotCommand;
import edu.stanford.smi.protege.model.framestore.undo.MoveDirectTypeCommand;
import edu.stanford.smi.protege.model.framestore.undo.RemoveDirectSuperclassCommand;
import edu.stanford.smi.protege.model.framestore.undo.RemoveDirectSuperslotCommand;
import edu.stanford.smi.protege.model.framestore.undo.RemoveDirectTemplateFacetOverridesCommand;
import edu.stanford.smi.protege.model.framestore.undo.RemoveDirectTemplateSlotCommand;
import edu.stanford.smi.protege.model.framestore.undo.RemoveDirectTypeCommand;
import edu.stanford.smi.protege.model.framestore.undo.ReplaceFrameCommand;
import edu.stanford.smi.protege.model.framestore.undo.SetDirectOwnSlotValuesCommand;
import edu.stanford.smi.protege.model.framestore.undo.SetDirectTemplateFacetValuesCommand;
import edu.stanford.smi.protege.model.framestore.undo.SetDirectTemplateSlotCommand;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protege.util.transaction.TransactionIsolationLevel;
import edu.stanford.smi.protege.util.transaction.TransactionMonitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class UndoFrameStore
extends ModificationFrameStore
implements CommandManager {
    Logger log = Log.getLogger(UndoFrameStore.class);
    private static final int NO_COMMAND = -1;
    private Collection _listeners = new ArrayList();
    private List _commands = new ArrayList();
    private int _lastExecutedCommand = -1;
    private LinkedList _macroCommandList = new LinkedList();
    private TransactionMonitor transactionMonitor = new TransactionMonitor(){

        public TransactionIsolationLevel getTransationIsolationLevel() throws TransactionException {
            return TransactionIsolationLevel.READ_UNCOMMITTED;
        }

        public void setTransactionIsolationLevel(TransactionIsolationLevel level) throws TransactionException {
            throw new TransactionException("Cannot set transaction isolation level using undo");
        }
    };

    public void close() {
        super.close();
        this._listeners = null;
        this._commands = null;
        this._macroCommandList = null;
    }

    private void addExecutedCommand(Command command) {
        if (this._lastExecutedCommand != this._commands.size() - 1) {
            this._commands = new ArrayList(this._commands.subList(0, this._lastExecutedCommand + 1));
        }
        this._commands.add(command);
        ++this._lastExecutedCommand;
    }

    public void reinitialize() {
        this._commands.clear();
        this._macroCommandList.clear();
        this._lastExecutedCommand = -1;
    }

    private Object execute(Command c) {
        Object o = this.isInTransaction() ? this.transactionCommandExecute(c) : this.simpleCommandExecute(c);
        return o;
    }

    private Object simpleCommandExecute(Command c) {
        Object o = c.doIt();
        this.addExecutedCommand(c);
        this.notifyListeners();
        return o;
    }

    private Object transactionCommandExecute(Command c) {
        Object o = c.doIt();
        this.getCurrentMacro().add(c);
        return o;
    }

    private MacroCommand getCurrentMacro() {
        return this._macroCommandList.isEmpty() ? null : this._macroCommandList.getLast();
    }

    private boolean isInTransaction() {
        return !this._macroCommandList.isEmpty();
    }

    public boolean canUndo() {
        return this._lastExecutedCommand >= 0;
    }

    public boolean canRedo() {
        return this._lastExecutedCommand < this._commands.size() - 1;
    }

    public void undo() {
        if (this.canUndo()) {
            Command command = (Command)this._commands.get(this._lastExecutedCommand);
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine("undoing " + command.getDescription());
            }
            command.undoIt();
            --this._lastExecutedCommand;
            this.notifyListeners();
        } else {
            Log.getLogger().warning("Not able to undo");
        }
    }

    public Command getUndoCommand() {
        return this.canUndo() ? (Command)this._commands.get(this._lastExecutedCommand) : null;
    }

    public Command getRedoCommand() {
        return this.canRedo() ? (Command)this._commands.get(this._lastExecutedCommand + 1) : null;
    }

    public void redo() {
        if (this.canRedo()) {
            ++this._lastExecutedCommand;
            Command command = (Command)this._commands.get(this._lastExecutedCommand);
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine("redoing " + command.getDescription());
            }
            command.redoIt();
            this.notifyListeners();
        } else {
            Log.getLogger().warning("Not able to redo");
        }
    }

    public Cls createCls(FrameID id, Collection types, Collection superclasses, boolean loadDefaults) {
        CreateClsCommand cmd = new CreateClsCommand(this.getDelegate(), id, types, superclasses, loadDefaults);
        return (Cls)this.execute(cmd);
    }

    public Slot createSlot(FrameID id, Collection types, Collection superslots, boolean loadDefaults) {
        CreateSlotCommand cmd = new CreateSlotCommand(this.getDelegate(), id, types, superslots, loadDefaults);
        return (Slot)this.execute(cmd);
    }

    public Facet createFacet(FrameID id, Collection types, boolean loadDefaults) {
        CreateFacetCommand cmd = new CreateFacetCommand(this.getDelegate(), id, types, loadDefaults);
        return (Facet)this.execute(cmd);
    }

    public SimpleInstance createSimpleInstance(FrameID id, Collection types, boolean loadDefaults) {
        CreateSimpleInstanceCommand cmd = new CreateSimpleInstanceCommand(this.getDelegate(), id, types, loadDefaults);
        return (SimpleInstance)this.execute(cmd);
    }

    public void deleteCls(Cls cls) {
        this.execute(new DeleteClsCommand(this.getDelegate(), cls));
    }

    public void deleteSlot(Slot slot) {
        this.execute(new DeleteSlotCommand(this.getDelegate(), slot));
    }

    public void deleteFacet(Facet facet) {
        this.execute(new DeleteFrameCommand(this.getDelegate(), facet));
    }

    public void deleteSimpleInstance(SimpleInstance simpleInstance) {
        this.execute(new DeleteFrameCommand(this.getDelegate(), simpleInstance));
    }

    public void addDirectTemplateSlot(Cls cls, Slot slot) {
        this.execute(new AddDirectTemplateSlotCommand(this.getDelegate(), cls, slot));
    }

    public void removeDirectTemplateSlot(Cls cls, Slot slot) {
        this.execute(new RemoveDirectTemplateSlotCommand(this.getDelegate(), slot, cls));
    }

    public void moveDirectTemplateSlot(Cls cls, Slot slot, int index) {
        this.execute(new MoveDirectTemplateSlotCommand(this.getDelegate(), slot, cls, index));
    }

    public void setDirectTemplateSlotValues(Cls cls, Slot slot, Collection values) {
        this.execute(new SetDirectTemplateSlotCommand(this.getDelegate(), cls, values, slot));
    }

    public void setDirectTemplateFacetValues(Cls cls, Slot slot, Facet facet, Collection values) {
        this.execute(new SetDirectTemplateFacetValuesCommand(this.getDelegate(), slot, cls, facet, values));
    }

    public void setDirectOwnSlotValues(Frame frame, Slot slot, Collection values) {
        this.execute(new SetDirectOwnSlotValuesCommand(this.getDelegate(), values, slot, frame));
    }

    public void moveDirectOwnSlotValue(Frame frame, Slot slot, int from, int to) {
        this.execute(new MoveDirectOwnSlotValueCommand(this.getDelegate(), frame, slot, from, to));
    }

    public void addDirectSuperclass(Cls cls, Cls superclass) {
        this.execute(new AddDirectSuperclassCommand(this.getDelegate(), superclass, cls));
    }

    public void removeDirectSuperclass(Cls cls, Cls superclass) {
        this.execute(new RemoveDirectSuperclassCommand(this.getDelegate(), superclass, cls));
    }

    public void moveDirectSubclass(Cls cls, Cls subclass, int index) {
        this.execute(new MoveDirectSubclassCommand(this.getDelegate(), cls, index, subclass));
    }

    public void addDirectSuperslot(Slot slot, Slot superslot) {
        this.execute(new AddDirectSuperslotCommand(this.getDelegate(), superslot, slot));
    }

    public void removeDirectSuperslot(Slot slot, Slot superslot) {
        this.execute(new RemoveDirectSuperslotCommand(this.getDelegate(), superslot, slot));
    }

    public void moveDirectSubslot(Slot slot, Slot subslot, int index) {
        this.execute(new MoveDirectSubslotCommand(this.getDelegate(), slot, index, subslot));
    }

    public void addDirectType(Instance instance, Cls type) {
        this.execute(new AddDirectTypeCommand(this.getDelegate(), type, instance));
    }

    public void removeDirectType(Instance instance, Cls type) {
        this.execute(new RemoveDirectTypeCommand(this.getDelegate(), type, instance));
    }

    public void moveDirectType(Instance instance, Cls type, int index) {
        this.execute(new MoveDirectTypeCommand(this.getDelegate(), instance, type, index));
    }

    public void removeDirectTemplateFacetOverrides(Cls cls, Slot slot) {
        this.execute(new RemoveDirectTemplateFacetOverridesCommand(this.getDelegate(), cls, slot));
    }

    public void replaceFrame(Frame original, Frame replacement) {
        this.execute(new ReplaceFrameCommand(this.getDelegate(), original, replacement));
    }

    public boolean beginTransaction(String name) {
        boolean ok = this.getDelegate().beginTransaction(name);
        this.transactionMonitor.beginTransaction();
        this.pushTransaction(new MacroCommand(name, this.getDelegate()));
        return ok;
    }

    private void pushTransaction(MacroCommand newMacro) {
        MacroCommand currentMacro = this.getCurrentMacro();
        if (currentMacro == null) {
            this.addExecutedCommand(newMacro);
        } else {
            currentMacro.add(newMacro);
        }
        this._macroCommandList.add(newMacro);
    }

    private MacroCommand popTransaction() {
        return (MacroCommand)this._macroCommandList.removeLast();
    }

    public boolean commitTransaction() {
        this.popTransaction();
        boolean committed = this.getDelegate().commitTransaction();
        this.transactionMonitor.commitTransaction();
        this.notifyListeners();
        return committed;
    }

    public boolean rollbackTransaction() {
        this.popTransaction();
        boolean succeeded = this.getDelegate().rollbackTransaction();
        this.transactionMonitor.rollbackTransaction();
        if (!succeeded) {
            this.undo();
            this._commands.remove(this._lastExecutedCommand + 1);
        }
        return succeeded;
    }

    public TransactionMonitor getTransactionStatusMonitor() {
        TransactionMonitor delegateMonitor = this.getDelegate().getTransactionStatusMonitor();
        if (delegateMonitor == null || delegateMonitor.getTransationIsolationLevel() == TransactionIsolationLevel.NONE) {
            return this.transactionMonitor;
        }
        return this.getDelegate().getTransactionStatusMonitor();
    }

    private void notifyListeners() {
        ChangeEvent event = new ChangeEvent(this);
        for (ChangeListener listener : this._listeners) {
            listener.stateChanged(event);
        }
    }

    public void addChangeListener(ChangeListener listener) {
        this._listeners.add(listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this._listeners.remove(listener);
    }

    public Collection getDoneCommands() {
        List commands = this._lastExecutedCommand >= 0 ? this._commands.subList(0, this._lastExecutedCommand + 1) : Collections.EMPTY_LIST;
        return commands;
    }

    public Collection getUndoneCommands() {
        List commands = this._lastExecutedCommand + 1 < this._commands.size() ? this._commands.subList(this._lastExecutedCommand + 1, this._commands.size()) : Collections.EMPTY_LIST;
        return commands;
    }
}

