/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.model.query;

import edu.stanford.smi.protege.exception.OntologyException;
import edu.stanford.smi.protege.exception.ProtegeError;
import edu.stanford.smi.protege.exception.ProtegeIOException;
import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.Localizable;
import edu.stanford.smi.protege.model.query.QueryCallback;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SynchronizeQueryCallback
implements QueryCallback,
Localizable {
    private Object kbLock;
    private Object result;
    private boolean ready = false;

    public SynchronizeQueryCallback(Object kbLock) {
        this.kbLock = kbLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void provideQueryResults(Collection<Frame> frames) {
        Object object = this.kbLock;
        synchronized (object) {
            this.result = frames;
            this.ready = true;
            this.kbLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void passException(Exception pe) {
        Object object = this.kbLock;
        synchronized (object) {
            this.result = pe;
            this.ready = true;
            this.kbLock.notifyAll();
        }
    }

    @Override
    public void handleError(OntologyException oe) {
        this.passException(oe);
    }

    @Override
    public void handleError(ProtegeIOException ioe) {
        this.passException(ioe);
    }

    @Override
    public void handleError(ProtegeError pe) {
        this.passException(pe);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<Frame> waitForResults() throws OntologyException, ProtegeIOException {
        Object o = null;
        try {
            Object object = this.kbLock;
            synchronized (object) {
                while (!this.ready) {
                    this.kbLock.wait();
                }
                o = this.result;
            }
        }
        catch (InterruptedException e) {
            throw new ProtegeIOException(e);
        }
        finally {
            Object object = this.kbLock;
            synchronized (object) {
                this.ready = false;
                this.result = null;
            }
        }
        if (o == null) {
            return null;
        }
        if (o instanceof Collection) {
            return (Collection)o;
        }
        if (o instanceof OntologyException) {
            throw (OntologyException)o;
        }
        if (o instanceof ProtegeIOException) {
            throw (ProtegeIOException)o;
        }
        throw (ProtegeError)o;
    }

    @Override
    public void localize(KnowledgeBase kb) {
        this.kbLock = kb;
    }
}

