/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.plugin;

import edu.stanford.smi.protege.model.Project;
import edu.stanford.smi.protege.plugin.AbstractExportPlugin;
import edu.stanford.smi.protege.plugin.BackendExportPlugin;
import java.util.ArrayList;
import java.util.Collection;

public abstract class AbstractBackendExportPlugin
extends AbstractExportPlugin
implements BackendExportPlugin {
    private String newProjectPath;

    protected AbstractBackendExportPlugin(String name) {
        super(name);
    }

    public boolean canExportToNewFormat(Project project) {
        return true;
    }

    public void setNewProjectPath(String newProjectPath) {
        this.newProjectPath = newProjectPath;
    }

    protected abstract void initializeSources(Project var1, Collection var2);

    protected abstract void overwriteDomainInformation(Project var1, Collection var2);

    public Project exportProjectToNewFormat(Project project) {
        ArrayList errors = new ArrayList();
        if (this.isCompatibleProject(project)) {
            this.saveAndPreserveCustomizations(project, errors);
        } else {
            this.saveAndDiscardCustomizations(project, errors);
        }
        Project newProject = Project.loadProjectFromFile(this.newProjectPath, errors);
        this.handleErrors(errors);
        return newProject;
    }

    protected boolean isCompatibleProject(Project project) {
        String factoryName = project.getKnowledgeBaseFactory().getClass().getName();
        return factoryName.indexOf("OWL") == -1;
    }

    private void saveAndPreserveCustomizations(Project project, Collection errors) {
        project.setProjectFilePath(this.newProjectPath);
        this.initializeSources(project, errors);
        project.save(errors);
    }

    protected void saveAndDiscardCustomizations(Project project, Collection errors) {
        Project newProject = Project.createNewProject(null, errors);
        newProject.setProjectFilePath(this.newProjectPath);
        newProject.save(errors);
        this.overwriteDomainInformation(project, errors);
    }
}

