/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.plugin;

import edu.stanford.smi.protege.model.KnowledgeBaseFactory;
import edu.stanford.smi.protege.model.Project;
import edu.stanford.smi.protege.plugin.CreateProjectPlugin;
import edu.stanford.smi.protege.ui.ProjectManager;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protege.util.PropertyList;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class AbstractCreateProjectPlugin
implements CreateProjectPlugin {
    private static final transient Logger log = Log.getLogger(AbstractCreateProjectPlugin.class);
    private String name;
    private KnowledgeBaseFactory knowledgeBaseFactory;
    private boolean useExistingSources;

    protected AbstractCreateProjectPlugin(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void dispose() {
    }

    protected void handleErrors(Collection errors) {
        if (!errors.isEmpty()) {
            ProjectManager.getProjectManager().displayErrors("Create Project Errors", errors);
            Log.handleErrors(log, Level.SEVERE, errors);
        }
    }

    public void setKnowledgeBaseFactory(KnowledgeBaseFactory factory) {
        this.knowledgeBaseFactory = factory;
    }

    public void setUseExistingSources(boolean b) {
        this.useExistingSources = b;
    }

    public Project createProject() {
        Project project = null;
        project = this.useExistingSources ? this.buildNewProject(this.knowledgeBaseFactory) : this.createNewProject(this.knowledgeBaseFactory);
        return project;
    }

    protected Project createNewProject(KnowledgeBaseFactory factory) {
        ArrayList errors = new ArrayList();
        Project project = Project.createNewProject(factory, errors);
        this.handleErrors(errors);
        return project;
    }

    protected void initialize(Project project) {
        this.initializeSources(project.getSources());
    }

    protected Project buildNewProject(KnowledgeBaseFactory factory) {
        ArrayList errors = new ArrayList();
        Project project = Project.createBuildProject(factory, errors);
        this.initialize(project);
        URI uri = this.getBuildProjectURI();
        if (uri != null) {
            project.setProjectURI(uri);
        }
        project.createDomainKnowledgeBase(factory, errors, true);
        this.handleErrors(errors);
        return project;
    }

    protected URI getBuildProjectURI() {
        return null;
    }

    protected void initializeSources(PropertyList sources) {
        throw new UnsupportedOperationException();
    }
}

