/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.plugin;

import edu.stanford.smi.protege.model.Project;
import edu.stanford.smi.protege.plugin.BackendExportPlugin;
import edu.stanford.smi.protege.plugin.ExportWizard;
import edu.stanford.smi.protege.plugin.ExportWizardPage;
import edu.stanford.smi.protege.util.ComponentFactory;
import edu.stanford.smi.protege.util.WizardPage;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JRadioButton;

public class ChangeProjectFormatWizardPage
extends ExportWizardPage {
    private static final long serialVersionUID = -3969285986800636849L;
    private Project project;
    private AbstractButton convertProjectButton;
    private BackendExportPlugin plugin;

    public ChangeProjectFormatWizardPage(ExportWizard wizard, BackendExportPlugin plugin, Project project) {
        super("change project format", wizard);
        this.plugin = plugin;
        this.project = project;
        AbstractButton button = this.createButton("Export Files and Leave Project Unchanged");
        button.setSelected(true);
        this.convertProjectButton = this.createButton("Convert Project to this Format");
        ButtonGroup group = new ButtonGroup();
        group.add(button);
        group.add(this.convertProjectButton);
        this.setLayout(new BoxLayout(this, 1));
        this.add(button);
        this.add(this.convertProjectButton);
        this.setPageComplete(true);
    }

    private AbstractButton createButton(String text) {
        AbstractAction action = new AbstractAction(text){
            private static final long serialVersionUID = -3419514018833124894L;

            public void actionPerformed(ActionEvent event) {
                ChangeProjectFormatWizardPage.this.updateNextPage();
            }
        };
        JRadioButton button = ComponentFactory.createRadioButton(action);
        return button;
    }

    public WizardPage getNextPage() {
        WizardPage page = this.convertProject() ? this.plugin.createExportToNewFormatWizardPage(this.getExportProjectWizard(), this.project) : this.plugin.createExportWizardPage(this.getExportProjectWizard(), this.project);
        return page;
    }

    public void onFinish() {
        ExportWizard wizard = (ExportWizard)this.getWizard();
        wizard.setExportToNewFormat(this.convertProject());
    }

    private boolean convertProject() {
        return this.convertProjectButton.isSelected();
    }
}

