/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.plugin;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.model.ValueType;
import edu.stanford.smi.protege.util.HashUtils;
import edu.stanford.smi.protege.util.SystemUtilities;

class DefaultEntry {
    private boolean cardinalityMultiple;
    private String typeName;
    private String allowedClsName;
    private String slotname;

    DefaultEntry(String cardinality, String typeName, String allowedClsName, String slotname) {
        this.cardinalityMultiple = "multiple".equalsIgnoreCase(cardinality);
        this.typeName = typeName;
        this.allowedClsName = allowedClsName;
        this.slotname = slotname;
    }

    DefaultEntry(boolean cardinality, ValueType type, Cls allowedCls) {
        this.cardinalityMultiple = cardinality;
        this.typeName = type.toString();
        this.allowedClsName = allowedCls == null ? null : allowedCls.getName();
    }

    DefaultEntry(Slot slot) {
        this.slotname = slot.getName();
    }

    public boolean equals(Object o) {
        DefaultEntry rhs = (DefaultEntry)o;
        boolean isEquals = this.cardinalityMultiple == rhs.cardinalityMultiple && SystemUtilities.equals(this.typeName, rhs.typeName) && SystemUtilities.equals(this.allowedClsName, rhs.allowedClsName) && SystemUtilities.equals(this.slotname, rhs.slotname);
        return isEquals;
    }

    public int hashCode() {
        return HashUtils.getHash(this.typeName, this.allowedClsName, this.slotname, this.cardinalityMultiple);
    }

    public String toString() {
        return "DefaultEntry(" + this.cardinalityMultiple + ", " + this.typeName + ", " + this.allowedClsName + ")";
    }
}

