/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.plugin;

import edu.stanford.smi.protege.model.KnowledgeBaseFactory;
import edu.stanford.smi.protege.plugin.CreateProjectPlugin;
import edu.stanford.smi.protege.plugin.CreateProjectPluginRenderer;
import edu.stanford.smi.protege.plugin.CreateProjectWizard;
import edu.stanford.smi.protege.util.ComponentFactory;
import edu.stanford.smi.protege.util.ComponentUtilities;
import edu.stanford.smi.protege.util.LabeledComponent;
import edu.stanford.smi.protege.util.SelectableList;
import edu.stanford.smi.protege.util.SelectionEvent;
import edu.stanford.smi.protege.util.SelectionListener;
import edu.stanford.smi.protege.util.Wizard;
import edu.stanford.smi.protege.util.WizardPage;
import java.util.Collection;
import javax.swing.JList;

class PickCreateProjectPluginPage
extends WizardPage {
    private static final long serialVersionUID = 7411364041871092526L;
    private SelectableList list;
    private KnowledgeBaseFactory factory;

    PickCreateProjectPluginPage(Collection plugins, KnowledgeBaseFactory factory, Wizard wizard) {
        super("pick plugin", wizard);
        this.factory = factory;
        this.createList(plugins);
        this.add(new LabeledComponent("Existing Source Type", ComponentFactory.createScrollPane(this.list)));
        this.list.setCellRenderer(new CreateProjectPluginRenderer());
    }

    private JList createList(Collection plugins) {
        this.list = ComponentFactory.createSelectableList(null);
        ComponentUtilities.setListValues(this.list, plugins);
        this.list.setSelectedIndex(0);
        this.list.addSelectionListener(new SelectionListener(){

            public void selectionChanged(SelectionEvent event) {
                PickCreateProjectPluginPage.this.updateNextPage();
            }
        });
        return this.list;
    }

    public void onFinish() {
        CreateProjectPlugin plugin = (CreateProjectPlugin)this.list.getSelectedValue();
        plugin.setKnowledgeBaseFactory(this.factory);
        plugin.setUseExistingSources(true);
        CreateProjectWizard wizard = (CreateProjectWizard)this.getWizard();
        wizard.setPlugin(plugin);
    }

    public WizardPage getNextPage() {
        CreateProjectPlugin plugin = (CreateProjectPlugin)this.list.getSelectedValue();
        return plugin.createCreateProjectWizardPage((CreateProjectWizard)this.getWizard(), true);
    }
}

