/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.plugin;

import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.plugin.PluginUtilities;
import edu.stanford.smi.protege.plugin.ProjectFixupPlugin;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protege.util.SystemUtilities;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectFixupsPluginManager {
    private static final String PROJECT_FIXUP_PLUGIN = "ProjectFixupPlugin";
    private static final String IS_SUITABLE_METHOD_NAME = "isSuitable";
    private static final Class<?>[] IS_SUITABLE_METHOD_ARGS = new Class[]{KnowledgeBase.class, Collection.class};

    public static Collection<Class> getAvailableProjectFixupPluginClasses() {
        return PluginUtilities.getClassesWithAttribute(PROJECT_FIXUP_PLUGIN, "True");
    }

    public static Collection<ProjectFixupPlugin> getAvailableProjectFixupPlugins() {
        ArrayList<ProjectFixupPlugin> plugins = new ArrayList<ProjectFixupPlugin>();
        for (Class pluginclass : ProjectFixupsPluginManager.getAvailableProjectFixupPluginClasses()) {
            ProjectFixupPlugin plugin = (ProjectFixupPlugin)SystemUtilities.newInstance(pluginclass);
            if (plugin == null) continue;
            plugins.add(plugin);
        }
        return plugins;
    }

    private static boolean isSuitable(KnowledgeBase internalKB, Class projectFixupPluginClass) {
        boolean isSuitable;
        try {
            ArrayList errors = new ArrayList();
            Method method = projectFixupPluginClass.getMethod(IS_SUITABLE_METHOD_NAME, IS_SUITABLE_METHOD_ARGS);
            Boolean returnValue = (Boolean)method.invoke((Object)projectFixupPluginClass, internalKB, errors);
            isSuitable = returnValue;
        }
        catch (NoSuchMethodException e) {
            isSuitable = true;
        }
        catch (Exception e) {
            isSuitable = false;
            Log.getLogger().warning(e.getMessage());
        }
        return isSuitable;
    }

    public static void fixProject(KnowledgeBase internalKB) {
        for (ProjectFixupPlugin plugin : ProjectFixupsPluginManager.getAvailableProjectFixupPlugins()) {
            if (plugin == null) continue;
            try {
                if (!ProjectFixupsPluginManager.isSuitable(internalKB, plugin.getClass())) continue;
                plugin.fixProject(internalKB);
            }
            catch (Throwable t) {
                Log.getLogger().log(Level.WARNING, "Error at applying project fix up " + plugin.getName(), t);
            }
        }
    }
}

