/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.plugin;

import edu.stanford.smi.protege.model.Project;
import edu.stanford.smi.protege.plugin.PluginUtilities;
import edu.stanford.smi.protege.plugin.ProjectPlugin;
import edu.stanford.smi.protege.ui.ProjectMenuBar;
import edu.stanford.smi.protege.ui.ProjectToolBar;
import edu.stanford.smi.protege.ui.ProjectView;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protege.util.SystemUtilities;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.logging.Level;

public class ProjectPluginManager {
    private static final String IS_SUITABLE_METHOD_NAME = "isSuitable";
    private static final Class[] IS_SUITABLE_METHOD_ARGS = new Class[]{Project.class, Collection.class};
    private Collection projectPlugins = new ArrayList();

    public ProjectPluginManager() {
        for (String name : PluginUtilities.getAvailableProjectPluginClassNames()) {
            ProjectPlugin plugin = (ProjectPlugin)SystemUtilities.newInstance(name);
            if (plugin == null) continue;
            this.projectPlugins.add(plugin);
        }
    }

    public void dispose() {
        for (ProjectPlugin plugin : this.projectPlugins) {
            plugin.dispose();
        }
        this.projectPlugins.clear();
        this.projectPlugins = null;
    }

    public void afterCreate(Project project) {
        for (ProjectPlugin plugin : this.projectPlugins) {
            if (!ProjectPluginManager.isSuitable(project, plugin)) continue;
            plugin.afterCreate(project);
        }
    }

    public void afterLoad(Project project) {
        for (ProjectPlugin plugin : this.projectPlugins) {
            if (!ProjectPluginManager.isSuitable(project, plugin)) continue;
            try {
                plugin.afterLoad(project);
            }
            catch (Exception e) {
                Log.getLogger().log(Level.WARNING, "There were errors at loading project plugin " + plugin, e);
            }
        }
    }

    private static boolean isSuitable(Project project, ProjectPlugin projectPlugin) {
        boolean isSuitable;
        try {
            ArrayList errors = new ArrayList();
            Method method = projectPlugin.getClass().getMethod(IS_SUITABLE_METHOD_NAME, IS_SUITABLE_METHOD_ARGS);
            Boolean returnValue = (Boolean)method.invoke((Object)projectPlugin, project, errors);
            isSuitable = returnValue;
        }
        catch (NoSuchMethodException e) {
            isSuitable = true;
        }
        catch (Exception e) {
            isSuitable = false;
            Log.getLogger().warning(e.getMessage());
        }
        return isSuitable;
    }

    private static boolean isSuitable(ProjectView projectView, ProjectPlugin projectPlugin) {
        return ProjectPluginManager.isSuitable(projectView.getProject(), projectPlugin);
    }

    public void afterSave(Project project) {
        for (ProjectPlugin plugin : this.projectPlugins) {
            if (!ProjectPluginManager.isSuitable(project, plugin)) continue;
            try {
                plugin.afterSave(project);
            }
            catch (AbstractMethodError ame) {
                Log.getLogger().warning("Plugin " + plugin + " does not implement the afterSave method");
            }
        }
    }

    public void afterShow(ProjectView projectView, ProjectToolBar toolBar, ProjectMenuBar menuBar) {
        for (ProjectPlugin plugin : this.projectPlugins) {
            if (!ProjectPluginManager.isSuitable(projectView, plugin)) continue;
            try {
                plugin.afterShow(projectView, toolBar, menuBar);
            }
            catch (Exception e) {
                Log.getLogger().warning(e.toString());
                Log.getLogger().log(Level.FINE, "Exception caught", e);
            }
        }
    }

    public void beforeSave(Project project) {
        for (ProjectPlugin plugin : this.projectPlugins) {
            if (!ProjectPluginManager.isSuitable(project, plugin)) continue;
            plugin.beforeSave(project);
        }
    }

    public void beforeClose(Project project) {
        for (ProjectPlugin plugin : this.projectPlugins) {
            if (!ProjectPluginManager.isSuitable(project, plugin)) continue;
            plugin.beforeClose(project);
        }
    }

    public void beforeHide(ProjectView projectView, ProjectToolBar toolBar, ProjectMenuBar menuBar) {
        for (ProjectPlugin plugin : this.projectPlugins) {
            if (!ProjectPluginManager.isSuitable(projectView, plugin)) continue;
            plugin.beforeHide(projectView, toolBar, menuBar);
        }
    }
}

