/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.plugin;

import edu.stanford.smi.protege.model.Project;
import edu.stanford.smi.protege.plugin.BackendExportPlugin;
import edu.stanford.smi.protege.plugin.ChangeProjectFormatWizardPage;
import edu.stanford.smi.protege.plugin.ExportPluginRenderer;
import edu.stanford.smi.protege.plugin.ExportProjectPlugin;
import edu.stanford.smi.protege.plugin.ExportWizard;
import edu.stanford.smi.protege.plugin.ExportWizardPage;
import edu.stanford.smi.protege.plugin.PluginUtilities;
import edu.stanford.smi.protege.util.ApplicationProperties;
import edu.stanford.smi.protege.util.ComponentFactory;
import edu.stanford.smi.protege.util.SelectableList;
import edu.stanford.smi.protege.util.SelectionEvent;
import edu.stanford.smi.protege.util.SelectionListener;
import edu.stanford.smi.protege.util.SimpleListModel;
import edu.stanford.smi.protege.util.SystemUtilities;
import edu.stanford.smi.protege.util.WizardPage;
import java.awt.Component;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JLabel;

public class SelectOutputFormatWizardPage
extends ExportWizardPage {
    private static final long serialVersionUID = -5850115778441040873L;
    private static final String SELECTED_PLUGIN = "export_project.last_selected_plugin";
    private SelectableList list;
    private Project project;

    SelectOutputFormatWizardPage(ExportWizard wizard, Project project) {
        super("select output format", wizard);
        this.project = project;
        JLabel label = ComponentFactory.createSmallFontLabel("Select an Output Format:");
        label.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        this.add((Component)label, "North");
        this.list = this.createList();
        this.add((Component)ComponentFactory.createScrollPane(this.list), "Center");
    }

    private SelectableList createList() {
        ArrayList<ExportProjectPlugin> plugins = new ArrayList<ExportProjectPlugin>();
        ExportProjectPlugin selection = null;
        String selectedFactoryName = ApplicationProperties.getString(SELECTED_PLUGIN);
        for (String className : PluginUtilities.getAvailableExportProjectPluginClassNames()) {
            ExportProjectPlugin plugin = (ExportProjectPlugin)SystemUtilities.newInstance(className);
            if (!plugin.canExport(this.project)) continue;
            plugins.add(plugin);
            if (!plugin.getClass().getName().equals(selectedFactoryName)) continue;
            selection = plugin;
        }
        this.list = ComponentFactory.createSelectableList(null);
        this.list.setModel(new SimpleListModel(plugins));
        this.list.setCellRenderer(new ExportPluginRenderer());
        if (selection == null) {
            this.list.setSelectedIndex(0);
        } else {
            this.list.setSelectedValue(selection);
        }
        this.list.addSelectionListener(new SelectionListener(){

            public void selectionChanged(SelectionEvent event) {
                SelectOutputFormatWizardPage.this.updateNextPage();
            }
        });
        return this.list;
    }

    public ExportProjectPlugin getSelectedPlugin() {
        ExportProjectPlugin plugin = (ExportProjectPlugin)this.list.getSelectedValue();
        ApplicationProperties.setString(SELECTED_PLUGIN, plugin.getClass().getName());
        return plugin;
    }

    public WizardPage getNextPage() {
        ExportProjectPlugin plugin = this.getSelectedPlugin();
        WizardPage nextPage = null;
        nextPage = this.canChangeFormat(plugin) ? new ChangeProjectFormatWizardPage(this.getExportProjectWizard(), (BackendExportPlugin)plugin, this.project) : plugin.createExportWizardPage(this.getExportProjectWizard(), this.project);
        return nextPage;
    }

    private boolean canChangeFormat(ExportProjectPlugin plugin2) {
        boolean canChangeFormat = false;
        if (plugin2 instanceof BackendExportPlugin) {
            BackendExportPlugin backendPlugin = (BackendExportPlugin)plugin2;
            canChangeFormat = backendPlugin.canExportToNewFormat(this.project);
        }
        return canChangeFormat;
    }

    public void onFinish() {
        ExportWizard wizard = (ExportWizard)this.getWizard();
        wizard.setExportPlugin(this.getSelectedPlugin());
    }
}

