/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.plugin;

import edu.stanford.smi.protege.model.KnowledgeBaseFactory;
import edu.stanford.smi.protege.plugin.CreateProjectPlugin;
import edu.stanford.smi.protege.plugin.CreateProjectWizard;
import edu.stanford.smi.protege.plugin.DefaultCreateProjectPlugin;
import edu.stanford.smi.protege.plugin.PickCreateProjectPluginPage;
import edu.stanford.smi.protege.plugin.PluginUtilities;
import edu.stanford.smi.protege.ui.FactoryRenderer;
import edu.stanford.smi.protege.util.ApplicationProperties;
import edu.stanford.smi.protege.util.ComponentFactory;
import edu.stanford.smi.protege.util.SelectableList;
import edu.stanford.smi.protege.util.SelectionEvent;
import edu.stanford.smi.protege.util.SelectionListener;
import edu.stanford.smi.protege.util.SimpleListModel;
import edu.stanford.smi.protege.util.StandardAction;
import edu.stanford.smi.protege.util.SystemUtilities;
import edu.stanford.smi.protege.util.WizardPage;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class SelectProjectTypeWizardPage
extends WizardPage {
    private static final long serialVersionUID = -8843058597898410690L;
    private static final String SELECTED_FACTORY = "select_project_type.last_factory";
    private JCheckBox doBuildBox;
    private SelectableList list;
    private CreateProjectPlugin plugin;

    SelectProjectTypeWizardPage(CreateProjectWizard wizard) {
        super("select project type", wizard);
        JLabel label = ComponentFactory.createSmallFontLabel("Select a Project Type:");
        label.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        JPanel listPanel = new JPanel(new BorderLayout());
        listPanel.add((Component)label, "North");
        this.list = this.createList();
        listPanel.add((Component)new JScrollPane(this.list), "Center");
        listPanel.setBorder(BorderFactory.createEmptyBorder(10, 0, 0, 0));
        this.configureCheckBox();
        this.add((Component)listPanel, "Center");
        this.add((Component)this.doBuildBox, "North");
    }

    private SelectableList createList() {
        KnowledgeBaseFactory selection = null;
        String selectedFactoryName = ApplicationProperties.getString(SELECTED_FACTORY);
        Collection<KnowledgeBaseFactory> factories = PluginUtilities.getAvailableFactories();
        for (KnowledgeBaseFactory factory : factories) {
            if (!factory.getClass().getName().equals(selectedFactoryName)) continue;
            selection = factory;
        }
        this.list = ComponentFactory.createSelectableList(null);
        this.list.setModel(new SimpleListModel(factories));
        this.list.setCellRenderer(new FactoryRenderer());
        if (selection == null) {
            this.list.setSelectedIndex(0);
        } else {
            this.list.setSelectedValue(selection);
        }
        this.list.addSelectionListener(new SelectionListener(){

            public void selectionChanged(SelectionEvent event) {
                SelectProjectTypeWizardPage.this.updateNextPage();
                SelectProjectTypeWizardPage.this.updateDoBuildBox();
            }
        });
        return this.list;
    }

    private void configureCheckBox() {
        StandardAction action = new StandardAction("Create from Existing Sources"){
            private static final long serialVersionUID = 3873947894902634872L;

            public void actionPerformed(ActionEvent event) {
                SelectProjectTypeWizardPage.this.updateNextPage();
            }
        };
        action.setMnemonic(67);
        this.doBuildBox = new JCheckBox(action);
    }

    public KnowledgeBaseFactory getSelectedFactory() {
        KnowledgeBaseFactory factory = (KnowledgeBaseFactory)this.list.getSelectedValue();
        if (factory != null) {
            ApplicationProperties.setString(SELECTED_FACTORY, factory.getClass().getName());
        }
        return factory;
    }

    private CreateProjectWizard getCreateProjectWizard() {
        return (CreateProjectWizard)this.getWizard();
    }

    private void updateDoBuildBox() {
        Collection plugins = SelectProjectTypeWizardPage.getAppropriateCreateProjectPlugins(this.getSelectedFactory(), this.getUseExistingSources());
        if (plugins.size() == 0) {
            this.doBuildBox.setSelected(false);
            this.doBuildBox.setEnabled(false);
        } else {
            this.doBuildBox.setEnabled(true);
        }
    }

    private boolean getUseExistingSources() {
        return this.doBuildBox.isSelected();
    }

    public void onFinish() {
        if (this.plugin != null) {
            this.plugin.setKnowledgeBaseFactory(this.getSelectedFactory());
            this.plugin.setUseExistingSources(this.getUseExistingSources());
            this.getCreateProjectWizard().setPlugin(this.plugin);
        }
    }

    public WizardPage getNextPage() {
        WizardPage page = null;
        Collection plugins = SelectProjectTypeWizardPage.getAppropriateCreateProjectPlugins(this.getSelectedFactory(), this.getUseExistingSources());
        if (plugins.size() == 0) {
            this.plugin = new DefaultCreateProjectPlugin();
        } else if (plugins.size() == 1) {
            this.plugin = (CreateProjectPlugin)plugins.iterator().next();
            page = this.plugin.createCreateProjectWizardPage(this.getCreateProjectWizard(), this.getUseExistingSources());
        } else {
            this.plugin = null;
            page = new PickCreateProjectPluginPage(plugins, this.getSelectedFactory(), this.getWizard());
        }
        return page;
    }

    private static Collection getAppropriateCreateProjectPlugins(KnowledgeBaseFactory factory, boolean useExistingSources) {
        ArrayList<CreateProjectPlugin> appropriatePlugins = new ArrayList<CreateProjectPlugin>();
        for (String className : PluginUtilities.getAvailableCreateProjectPluginClassNames()) {
            CreateProjectPlugin availablePlugin = (CreateProjectPlugin)SystemUtilities.newInstance(className);
            if (!availablePlugin.canCreateProject(factory, useExistingSources)) continue;
            appropriatePlugins.add(availablePlugin);
        }
        return appropriatePlugins;
    }
}

