/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.resource;

import edu.stanford.smi.protege.resource.ResourceKey;
import edu.stanford.smi.protege.util.ApplicationProperties;
import edu.stanford.smi.protege.util.DirectoryClassLoader;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protege.util.StringUtilities;
import java.io.File;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class BundleHelper {
    private ResourceBundle resourceBundle;
    private static boolean colorLookup;

    public BundleHelper(String bundleName, Class clas) {
        try {
            ClassLoader loader = clas.getClassLoader();
            loader = BundleHelper.fixLoader(loader);
            Locale locale = Locale.getDefault();
            this.resourceBundle = ResourceBundle.getBundle(bundleName, locale, loader);
        }
        catch (MissingResourceException e) {
            Log.getLogger().warning("missing bundle: " + bundleName);
        }
    }

    private static ClassLoader fixLoader(ClassLoader loader) {
        File applicationDirectory;
        if (loader == BundleHelper.class.getClassLoader() && (applicationDirectory = ApplicationProperties.getApplicationDirectory()) != null) {
            loader = new DirectoryClassLoader(applicationDirectory, loader);
        }
        return loader;
    }

    public boolean hasText(ResourceKey key) {
        return this.internalGetText(key) != null;
    }

    public String getText(ResourceKey key) {
        String text = this.internalGetText(key);
        if (colorLookup) {
            text = text == null ? "<html><font color=ff0000>" + key + "</font></html>" : "<html><font color=0000ff>" + text + "</font></html>";
        }
        return text == null ? key.toString() : text;
    }

    private String internalGetText(ResourceKey key) {
        String text;
        if (this.resourceBundle == null) {
            Log.getLogger().warning("no resource bundle: " + key);
            text = "Missing resource bundle for " + key;
        } else {
            try {
                text = this.resourceBundle.getString(key.toString());
            }
            catch (MissingResourceException e) {
                text = null;
            }
        }
        return text;
    }

    public String getText(ResourceKey text, String macroReplacement) {
        String s = this.getText(text);
        s = StringUtilities.replace(s, "{0}", macroReplacement);
        return s;
    }

    public String getText(ResourceKey text, String macroReplacement1, String macroReplacement2) {
        String s = this.getText(text, macroReplacement1);
        s = StringUtilities.replace(s, "{1}", macroReplacement2);
        return s;
    }

    public int getChar(ResourceKey key) {
        String s = this.internalGetText(key);
        return s == null || s.length() == 0 ? 0 : (int)s.charAt(0);
    }

    public boolean isValid() {
        return this.resourceBundle != null;
    }

    public String toString() {
        return StringUtilities.getClassName(this);
    }

    static {
        try {
            colorLookup = Boolean.getBoolean("protege.text.colorlookup");
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }
}

