/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.server;

import edu.stanford.smi.protege.model.Project;
import edu.stanford.smi.protege.server.RemoteProjectManager;
import edu.stanford.smi.protege.ui.ProjectManager;
import edu.stanford.smi.protege.util.ApplicationProperties;
import edu.stanford.smi.protege.util.ComponentFactory;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protege.util.SystemUtilities;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JFrame;

public class ClientConnectMain {
    private static Logger log = Log.getLogger(ClientConnectMain.class);
    private String host;
    private String user;
    private String password;
    private String projectName;
    private JFrame mainFrame;

    public ClientConnectMain(String[] args) {
        this.host = args[0];
        this.user = args[1];
        this.password = args[2];
        this.projectName = args[3];
    }

    public void connect() {
        RemoteProjectManager rpm = RemoteProjectManager.getInstance();
        Project p = rpm.getProject(this.host, this.user, this.password, this.projectName, true);
        this.initializeProtegeGui();
        ProjectManager.getProjectManager().setCurrentProject(p, true, false);
    }

    private void initializeProtegeGui() {
        ThreadGroup group = new ThreadGroup(Thread.currentThread().getThreadGroup(), "Safe Thread Group"){

            public void uncaughtException(Thread thread, Throwable throwable) {
                Log.getLogger().log(Level.SEVERE, "Uncaught Exception", throwable);
            }
        };
        SystemUtilities.initGraphics();
        this.mainFrame = ComponentFactory.createMainFrame();
        this.mainFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent event) {
                ProjectManager.getProjectManager().exitApplicationRequest();
            }
        });
        ProjectManager.getProjectManager().setRootPane(this.mainFrame.getRootPane());
        ApplicationProperties.restoreMainFrameProperties(this.mainFrame);
        this.mainFrame.setVisible(true);
    }

    public static void main(String[] args) {
        if (args.length < 4) {
            log.info("Usage: ClientConnect host/port user password project-name");
            System.exit(-1);
        }
        ClientConnectMain connectJob = new ClientConnectMain(args);
        connectJob.connect();
        SystemUtilities.sleepMsec(5000);
    }
}

