/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.server;

import edu.stanford.smi.protege.server.RemoteServer;
import edu.stanford.smi.protege.server.Server;
import edu.stanford.smi.protege.util.ComponentFactory;
import edu.stanford.smi.protege.util.LabeledComponent;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protege.util.ModalDialog;
import edu.stanford.smi.protege.util.Validatable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.rmi.Naming;
import java.util.logging.Level;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class RegisterUserServerPanel
extends JPanel
implements Validatable {
    private static final long serialVersionUID = -325336435948601667L;
    private JTextField _usernameField;
    private JTextField _password1Field;
    private JTextField _password2Field;
    private String _serverName;

    public RegisterUserServerPanel(String serverName) {
        this._serverName = serverName;
        this._usernameField = ComponentFactory.createTextField();
        this._password1Field = ComponentFactory.createPasswordField();
        this._password2Field = ComponentFactory.createPasswordField();
        this.setLayout(new BorderLayout());
        JPanel panel = new JPanel(new GridLayout(4, 0));
        panel.add(new LabeledComponent("User Name", this._usernameField));
        panel.add(new LabeledComponent("Password", this._password1Field));
        panel.add(new LabeledComponent("Retype password", this._password2Field));
        this.add((Component)panel, "North");
    }

    private static RemoteServer connectToHost(String serverName) {
        RemoteServer server = null;
        try {
            server = (RemoteServer)Naming.lookup("//" + serverName + "/" + Server.getBoundName());
        }
        catch (Exception e) {
            Log.getLogger().severe(Log.toString(e));
        }
        return server;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean validateContents() {
        String username = this._usernameField.getText();
        String password1 = this._password1Field.getText();
        String password2 = this._password2Field.getText();
        if (username == null || username.length() == 0) {
            ModalDialog.showMessageDialog((Component)this, "Username field cannot be empty.\nPlease provide a user name.", "Error: Empty user name");
            return false;
        }
        if (!password1.equals(password2)) {
            ModalDialog.showMessageDialog((Component)this, "Passwords in the two password fields do not match. Please retype passwords.", "Error: Passwords do not match");
            this._password1Field.setText("");
            this._password2Field.setText("");
            return false;
        }
        boolean success = false;
        RemoteServer _server = null;
        try {
            _server = RegisterUserServerPanel.connectToHost(this._serverName);
        }
        catch (Exception ex) {
            Log.getLogger().log(Level.WARNING, "Error at connecting to host " + this._serverName, ex);
            ModalDialog.showMessageDialog((Component)this, "Cannot connect to server: " + this._serverName + "\nPlease check that the server name is correct." + "\nThis error may also indicate firewall problems.", "Error: Connect to server");
            return false;
        }
        try {
            success = _server.createUser(username, password1);
        }
        catch (Exception e) {
            success = false;
            Log.getLogger().warning("Error at creating user with username: " + username);
        }
        finally {
            if (success) {
                ModalDialog.showMessageDialog((Component)this, "New user " + username + " created successfully.\n You can now login to the server " + this._serverName + " using the created account.", "Created new user");
            } else {
                ModalDialog.showMessageDialog((Component)this, "Username already exist. Please choose another user name and try again.", "Error: User already exists");
                this._usernameField.setText("");
                this._password1Field.setText("");
                this._password2Field.setText("");
            }
        }
        return success;
    }

    public void saveContents() {
    }

    public String getUsername() {
        return this._usernameField.getText();
    }

    public String getPassword() {
        return this._password1Field.getText();
    }
}

