/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.server;

import edu.stanford.smi.protege.model.DefaultKnowledgeBase;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.KnowledgeBaseFactory;
import edu.stanford.smi.protege.model.Project;
import edu.stanford.smi.protege.server.RemoteServer;
import edu.stanford.smi.protege.server.RemoteServerProject;
import edu.stanford.smi.protege.server.RemoteSession;
import edu.stanford.smi.protege.server.RemoteSimpleStream;
import edu.stanford.smi.protege.server.Session;
import edu.stanford.smi.protege.server.framestore.RemoteClientFrameStore;
import edu.stanford.smi.protege.server.framestore.RemoteServerFrameStore;
import edu.stanford.smi.protege.server.framestore.ServerSessionLost;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protege.util.SystemUtilities;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RemoteClientProject
extends Project {
    private static Logger log = Log.getLogger(RemoteClientProject.class);
    private RemoteServer _server;
    private RemoteServerProject _serverProject;
    private RemoteSession _session;
    private Thread shutdownHook;

    public static Project createProject(RemoteServer server, RemoteServerProject serverProject, RemoteSession session, boolean pollForEvents) throws RemoteException {
        return new RemoteClientProject(server, serverProject, session, pollForEvents);
    }

    public RemoteClientProject(RemoteServer server, RemoteServerProject serverProject, RemoteSession session, boolean pollForEvents) throws RemoteException {
        super(null, null, new ArrayList(), false);
        this._server = server;
        this._serverProject = serverProject;
        this._session = session;
        serverProject.getDomainKbFrameStore(session);
        KnowledgeBase domainKb = RemoteClientProject.createKnowledgeBase(server, serverProject.getDomainKbFrameStore(session), serverProject.getDomainKbFactoryClassName(), session, false);
        KnowledgeBase projectKb = RemoteClientProject.copyKb(serverProject);
        this.setKnowledgeBases(domainKb, projectKb);
        if (pollForEvents) {
            domainKb.setPollForEvents(true);
        }
        this.installShutdownHook();
    }

    private static KnowledgeBase copyKb(RemoteServerProject serverProject) throws RemoteException {
        RemoteSimpleStream rss = null;
        FileOutputStream tempFileStream = null;
        try {
            byte[] input;
            long startTime = System.currentTimeMillis();
            File tmpFile = File.createTempFile("RemoteProject", ".pprj");
            tempFileStream = new FileOutputStream(tmpFile);
            rss = serverProject.uploadProjectKb();
            while ((input = rss.read()) != null) {
                tempFileStream.write(input);
            }
            tempFileStream.flush();
            tempFileStream.close();
            tempFileStream = null;
            log.info("Uploaded pprj file in " + (System.currentTimeMillis() - startTime) + " milliseconds.");
            startTime = System.currentTimeMillis();
            ArrayList errors = new ArrayList();
            KnowledgeBase localKb = RemoteClientProject.loadProjectKB(tmpFile.toURI(), null, errors);
            log.info("Loaded pprj file into knowledge base in " + (System.currentTimeMillis() - startTime) + " milliseconds.");
            Log.handleErrors(log, Level.WARNING, errors);
            KnowledgeBase knowledgeBase = localKb;
            return knowledgeBase;
        }
        catch (IOException ioe) {
            if (ioe instanceof RemoteException) {
                throw (RemoteException)ioe;
            }
            throw new RemoteException("Exception caught uploading project knowledge base from the server", ioe);
        }
        finally {
            if (rss != null) {
                rss.close();
            }
            if (tempFileStream != null) {
                try {
                    tempFileStream.close();
                }
                catch (IOException ioe) {
                    throw new RemoteException("Exception caught closing temp file", ioe);
                }
            }
        }
    }

    private static KnowledgeBase createKnowledgeBase(RemoteServer server, RemoteServerFrameStore serverFrameStore, String factoryClassName, RemoteSession session, boolean preloadAll) {
        Class factoryClass = SystemUtilities.forName(factoryClassName, true);
        KnowledgeBaseFactory factory = (KnowledgeBaseFactory)SystemUtilities.newInstance(factoryClass);
        ArrayList errors = new ArrayList();
        DefaultKnowledgeBase kb = (DefaultKnowledgeBase)factory.createKnowledgeBase(errors);
        Log.handleErrors(log, Level.WARNING, errors);
        if (log.isLoggable(Level.FINE)) {
            log.fine("created kb=" + kb);
        }
        kb.setGenerateEventsEnabled(false);
        kb.setCallCachingEnabled(false);
        RemoteClientFrameStore clientFrameStore = new RemoteClientFrameStore(server, serverFrameStore, session, kb, preloadAll);
        kb.setTerminalFrameStore(clientFrameStore);
        return kb;
    }

    public RemoteSession getSession() {
        return this._session;
    }

    public RemoteServer getServer() {
        return this._server;
    }

    public URI getProjectURI() {
        URI uri = null;
        try {
            uri = this._serverProject.getURI(this._session);
        }
        catch (Exception e) {
            Log.getLogger().severe(Log.toString(e));
        }
        return uri;
    }

    public URL getProjectURL() {
        URL url = null;
        try {
            url = new URL(this.getProjectURI().toString());
        }
        catch (MalformedURLException e) {
            Log.getLogger().severe(Log.toString(e));
        }
        return url;
    }

    public Collection getCurrentUsers() {
        ArrayList<String> users = new ArrayList<String>();
        try {
            Collection sessions = this._serverProject.getCurrentSessions(this._session);
            for (Session session : sessions) {
                users.add(session.getUserName());
            }
        }
        catch (RemoteException e) {
            Log.getLogger().severe(Log.toString(e));
        }
        return users;
    }

    public String getLocalUser() {
        return this._session.getUserName();
    }

    public void dispose() {
        if (log.isLoggable(Level.FINE)) {
            Log.getLogger().fine("Remote project dispose " + this);
        }
        super.dispose();
        this.attemptClose();
        this.uninstallShutdownHook();
    }

    private void attemptClose() {
        try {
            this._serverProject.close(this._session);
        }
        catch (ServerSessionLost ssl) {
            Log.getLogger().info("Session disconnected");
        }
        catch (RemoteException e) {
            Log.getLogger().warning(e.toString());
        }
    }

    public KnowledgeBaseFactory getKnowledgeBaseFactory() {
        return null;
    }

    public boolean isMultiUserClient() {
        return true;
    }

    private void installShutdownHook() {
        this.shutdownHook = new Thread("Remote Project ShutdownHook"){

            public void run() {
                try {
                    RemoteClientProject.this.attemptClose();
                }
                catch (Throwable t) {
                    Log.getLogger().log(Level.INFO, "Exception caught", t);
                }
            }
        };
        try {
            Runtime.getRuntime().addShutdownHook(this.shutdownHook);
        }
        catch (Exception e) {
            Log.getLogger().log(Level.WARNING, "Unable to install shutdown hook", e);
        }
    }

    private void uninstallShutdownHook() {
        try {
            Runtime.getRuntime().removeShutdownHook(this.shutdownHook);
        }
        catch (Exception e) {
            Log.getLogger().log(Level.WARNING, "Unable to remove shutdown hook", e);
        }
    }

    public boolean isDirty() {
        return false;
    }
}

