/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.server;

import edu.stanford.smi.protege.event.FrameAdapter;
import edu.stanford.smi.protege.event.FrameEvent;
import edu.stanford.smi.protege.event.FrameListener;
import edu.stanford.smi.protege.event.ServerProjectNotificationEvent;
import edu.stanford.smi.protege.event.ServerProjectSessionClosedEvent;
import edu.stanford.smi.protege.event.ServerProjectStatusChangeEvent;
import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.KnowledgeBaseFactory;
import edu.stanford.smi.protege.model.Project;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.model.framestore.EventGeneratorFrameStore;
import edu.stanford.smi.protege.model.framestore.FrameStore;
import edu.stanford.smi.protege.plugin.ProjectPluginManager;
import edu.stanford.smi.protege.resource.Text;
import edu.stanford.smi.protege.server.ProtegeRmiClassLoaderSpi;
import edu.stanford.smi.protege.server.RemoteServer;
import edu.stanford.smi.protege.server.RemoteServerProject;
import edu.stanford.smi.protege.server.RemoteSession;
import edu.stanford.smi.protege.server.ServerProject;
import edu.stanford.smi.protege.server.ServerProperties;
import edu.stanford.smi.protege.server.Session;
import edu.stanford.smi.protege.server.framestore.LocalizeFrameStoreHandler;
import edu.stanford.smi.protege.server.framestore.ServerFrameStore;
import edu.stanford.smi.protege.server.framestore.ServerSessionLost;
import edu.stanford.smi.protege.server.metaproject.MetaProject;
import edu.stanford.smi.protege.server.metaproject.MetaProjectConstants;
import edu.stanford.smi.protege.server.metaproject.Operation;
import edu.stanford.smi.protege.server.metaproject.Policy;
import edu.stanford.smi.protege.server.metaproject.PolicyControlledObject;
import edu.stanford.smi.protege.server.metaproject.ProjectInstance;
import edu.stanford.smi.protege.server.metaproject.ServerInstance;
import edu.stanford.smi.protege.server.metaproject.User;
import edu.stanford.smi.protege.server.metaproject.impl.MetaProjectImpl;
import edu.stanford.smi.protege.server.socket.RmiSocketFactory;
import edu.stanford.smi.protege.server.socket.SSLFactory;
import edu.stanford.smi.protege.server.util.ProjectInfo;
import edu.stanford.smi.protege.server.util.ServerUtil;
import edu.stanford.smi.protege.storage.clips.ClipsKnowledgeBaseFactory;
import edu.stanford.smi.protege.util.CollectionUtilities;
import edu.stanford.smi.protege.util.FileUtilities;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protege.util.ServerJob;
import edu.stanford.smi.protege.util.SystemUtilities;
import edu.stanford.smi.protege.util.URIUtilities;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.URI;
import java.net.UnknownHostException;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.UnicastRemoteObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import java.util.concurrent.ThreadFactory;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Server
extends UnicastRemoteObject
implements RemoteServer {
    private static final long serialVersionUID = 1675054259604532947L;
    private static final transient Logger log = Log.getLogger(Server.class);
    public static final int NO_SAVE = -1;
    private static final String SAVE_INTERVAL_OPTION = "-saveIntervalSec=";
    private static final String NOPRELOAD_OPTION = "-nopreload";
    private static final String OPTION_CHAR = "-";
    private ThreadFactory daemonizingThreadFactory = new ThreadFactory(){

        public Thread newThread(Runnable r) {
            Thread th = new Thread(r);
            th.setDaemon(true);
            return th;
        }
    };
    private final ExecutorService serverExecutor = Executors.newCachedThreadPool(this.daemonizingThreadFactory);
    private final ExecutorService singleJobAtATimeExecutor = Executors.newSingleThreadExecutor(this.daemonizingThreadFactory);
    private URI metaprojectURI;
    private URI _baseURI;
    private boolean preload = true;
    private volatile int _saveIntervalMsec = -1;
    private static volatile Server serverInstance;
    private ServerProject serverMetaProject;
    private volatile Thread _updateThread;
    private MetaProject metaproject;
    private FrameListener metaprojectFrameListener;
    private FrameListener metaprojectProjectClsListener;
    private Cls projectCls;
    private Slot nameSlot;
    private final ProjectPluginManager _projectPluginManager = new ProjectPluginManager();
    private final Map<String, Project> _nameToOpenProjectMap = new HashMap<String, Project>();
    private final Map<String, ServerProject.ProjectStatus> _nameToProjectStatusMap = new TreeMap<String, ServerProject.ProjectStatus>();
    private final Map<Project, ServerProject> _projectToServerProjectMap = new HashMap<Project, ServerProject>();
    private final Map<RemoteSession, Collection<ServerProject>> _sessionToProjectsMap = new HashMap<RemoteSession, Collection<ServerProject>>();
    private List<RemoteSession> _sessions = Collections.synchronizedList(new ArrayList());
    private final Map<String, FutureTask<Object>> projectToShutdownTaskNotificationMap = new HashMap<String, FutureTask<Object>>();

    public static void main(String[] args) {
        try {
            Server.startServer(args);
        }
        catch (Exception e) {
            Log.getLogger().log(Level.SEVERE, "server startup failed", e);
        }
    }

    public static void startServer(String[] args) throws IOException {
        Log.getLogger().info("Protege server is starting...");
        SystemUtilities.logSystemInfo();
        System.setProperty("java.rmi.server.RMIClassLoaderSpi", ProtegeRmiClassLoaderSpi.class.getName());
        Server.checkRegistry();
        SystemUtilities.initialize();
        serverInstance = new Server(args);
        Server.afterLoad();
        serverInstance.bindName();
        Log.getLogger().info("Protege server ready to accept connections...");
    }

    private static void checkRegistry() throws IOException {
        try {
            Server.getRegistry().list();
        }
        catch (RemoteException re) {
            log.log(Level.WARNING, "Is the registry running?", re);
            throw new IOException("Could not connect to the rmi registry task");
        }
    }

    private static void afterLoad() {
        for (Map.Entry<String, Project> entry : Server.serverInstance._nameToOpenProjectMap.entrySet()) {
            String name = entry.getKey();
            Project p = entry.getValue();
            Log.getLogger().info("Loading project plugins for project " + name);
            Server.serverInstance._projectPluginManager.afterLoad(p);
        }
    }

    public static Server getInstance() {
        return serverInstance;
    }

    public static Policy getPolicy() {
        return Server.serverInstance.metaproject.getPolicy();
    }

    public static String getBoundName() {
        return Text.getProgramTextName();
    }

    protected static String getLocalBoundName() {
        return Server.getBoundName();
    }

    public int getSaveIntervalMsec() {
        return this._saveIntervalMsec;
    }

    public void setSaveIntervalMsec(int saveIntervalMsec) {
        this._saveIntervalMsec = saveIntervalMsec;
    }

    public static Registry getRegistry() throws RemoteException {
        int port = Integer.getInteger("protege.rmi.registry.port", 1099);
        return LocateRegistry.getRegistry(null, port);
    }

    private void parseArgs(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            this.parseArg(args[i]);
        }
    }

    protected void parseArg(String arg) {
        if (arg.startsWith(SAVE_INTERVAL_OPTION)) {
            this.extractSaveInterval(arg);
        } else if (arg.startsWith(NOPRELOAD_OPTION)) {
            this.preload = false;
        } else if (arg.startsWith(OPTION_CHAR)) {
            this.printUsage();
        } else {
            this.extractMetaProjectLocation(arg);
        }
    }

    private void extractSaveInterval(String s) {
        if (s.startsWith(SAVE_INTERVAL_OPTION)) {
            String min = s.substring(SAVE_INTERVAL_OPTION.length());
            int seconds = Integer.parseInt(min);
            Log.getLogger().config("Save interval sec=" + seconds);
            if (seconds > 0) {
                this._saveIntervalMsec = seconds * 1000;
            }
        } else {
            this.printUsage();
        }
    }

    protected void extractMetaProjectLocation(String s) {
        this.metaprojectURI = URIUtilities.createURI(s);
    }

    protected void printUsage() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("usage: java -cp protege.jar edu.stanford.smi.protege.server.Server [options] <metaproject>");
        buffer.append("\n\tOptions:");
        buffer.append("\n\t\t-saveIntervalSec=<nseconds>");
        buffer.append("\n\t\t\tSave any dirty projects every n minutes (only needed for file based projects)");
        buffer.append("\n\t\t-nopreload");
        buffer.append("\n\t\t\tDon't preload projects.");
        System.err.println(buffer.toString());
        System.exit(-1);
    }

    private Server(String[] args) throws RemoteException, IOException {
        super(SSLFactory.getServerPort(SSLFactory.Context.LOGIN), new RmiSocketFactory(SSLFactory.Context.LOGIN), new RmiSocketFactory(SSLFactory.Context.LOGIN));
        this.parseArgs(args);
        this.initialize();
    }

    private void clear() {
        this._nameToOpenProjectMap.clear();
        this._nameToProjectStatusMap.clear();
        this._projectToServerProjectMap.clear();
        this._sessions.clear();
        this._sessionToProjectsMap.clear();
        this.removeMetaProjectListeners();
        this.stopProjectUpdateThread();
    }

    private void initialize() throws RemoteException {
        Log.getLogger().info("Using metaproject from: " + this.metaprojectURI);
        this.metaproject = new MetaProjectImpl(this.metaprojectURI, true);
        this.serverMetaProject = null;
        ServerUtil.fixMetaProject(this.metaproject);
        this.initializeProjects();
        this.addMetaProjectListeners();
        this.startProjectUpdateThread();
    }

    private void initializeProjects() {
        for (String name : this.getAvailableProjectNames(null)) {
            this._nameToProjectStatusMap.put(name, ServerProject.ProjectStatus.READY);
            if (this.preload) {
                try {
                    this.createProject(name);
                }
                catch (Exception e) {
                    Log.getLogger().warning("Error at loading project: " + name + "Error message: " + e.getMessage());
                }
                continue;
            }
            Log.getLogger().info("Found project " + name);
        }
    }

    protected void bindName() throws RemoteException {
        try {
            String boundName = Server.getLocalBoundName();
            Server.getRegistry().rebind(boundName, this);
            this._baseURI = new URI("rmi://" + Server.getMachineName() + "/" + boundName);
        }
        catch (Exception e) {
            Log.getLogger().severe(Log.toString(e));
            if (e instanceof RemoteException) {
                throw (RemoteException)e;
            }
            throw new RemoteException(e.getMessage());
        }
    }

    protected void unBindName() throws RemoteException {
        try {
            String boundName = Server.getLocalBoundName();
            Server.getRegistry().unbind(boundName);
        }
        catch (Exception e) {
            Log.getLogger().severe(Log.toString(e));
            if (e instanceof RemoteException) {
                throw (RemoteException)e;
            }
            throw new RemoteException(e.getMessage());
        }
    }

    private static String getMachineName() {
        String name;
        try {
            name = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            Log.getLogger().severe(Log.toString(e));
            name = "localhost";
        }
        return name;
    }

    private boolean readAllowed(String projectName, RemoteSession session) {
        Policy policy = this.metaproject.getPolicy();
        User user = policy.getUserByName(session.getUserName());
        ProjectInstance projectInstance = this.metaproject.getProject(projectName);
        if (projectInstance == null) {
            return true;
        }
        return policy.isOperationAuthorized(user, MetaProjectConstants.OPERATION_READ, projectInstance);
    }

    private void recordConnection(RemoteSession session, ServerProject project) throws ServerSessionLost {
        Collection<ServerProject> projects = this._sessionToProjectsMap.get(session);
        if (projects == null) {
            projects = new ArrayList<ServerProject>();
            this._sessionToProjectsMap.put(session, projects);
        }
        projects.add(project);
        project.register(session);
        Log.getLogger().info("Server: Adding " + session + " on " + new Date());
    }

    private void recordDisconnection(RemoteSession session, RemoteServerProject project) throws ServerSessionLost {
        Collection<ServerProject> projects = this._sessionToProjectsMap.get(session);
        if (projects != null) {
            projects.remove(project);
        }
        if (projects == null || projects.isEmpty()) {
            this._sessionToProjectsMap.remove(session);
            this._sessions.remove(session);
        }
        if (project instanceof ServerProject) {
            ((ServerProject)project).deregister(session);
        }
        Log.getLogger().info("Server: Removing " + session + " on " + new Date());
    }

    public synchronized ServerProject getServerProject(String projectName) {
        Project p = this.getProject(projectName);
        return p == null ? null : this.getServerProject(p);
    }

    private ServerProject createServerProject(String name, Project p) {
        ServerProject impl = null;
        try {
            impl = new ServerProject(this, this.getURI(name), this.metaproject.getProject(name), p);
        }
        catch (RemoteException e) {
            Log.getLogger().severe(Log.toString(e));
        }
        return impl;
    }

    private URI getURI(String projectName) {
        String name = FileUtilities.urlEncode(projectName);
        return this._baseURI.resolve(name);
    }

    private void addServerProject(Project p, ServerProject sp) {
        this._projectToServerProjectMap.put(p, sp);
    }

    public synchronized Project getOrCreateProject(String name) {
        Project project = this.getProject(name);
        if (project == null) {
            project = this.createProject(name);
        }
        return project;
    }

    private Project createProject(String name) {
        if (this._nameToProjectStatusMap.get(name) != ServerProject.ProjectStatus.READY) {
            return null;
        }
        Project project = null;
        for (ProjectInstance instance : this.metaproject.getProjects()) {
            String projectName = instance.getName();
            if (!projectName.equals(name)) continue;
            String projectLocation = instance.getLocation();
            URI uri = URIUtilities.createURI(projectLocation);
            Log.getLogger().info("Loading project " + name + " from " + uri);
            ArrayList errors = new ArrayList();
            project = Project.loadProjectFromURI(uri, errors, true);
            Log.handleErrors(log, Level.WARNING, errors);
            if (serverInstance != null) {
                this._projectPluginManager.afterLoad(project);
            }
            Server.localizeProject(project);
            this._nameToOpenProjectMap.put(name, project);
            break;
        }
        return project;
    }

    private static void localizeProject(Project project) {
        Server.localizeKB(project.getKnowledgeBase());
        Server.localizeKB(project.getInternalProjectKnowledgeBase());
    }

    private static void localizeKB(KnowledgeBase kb) {
        FrameStore fs = new LocalizeFrameStoreHandler(kb).newFrameStore();
        kb.insertFrameStore(fs);
    }

    private static boolean isCurrent(Session session) {
        return true;
    }

    private boolean isValid(String name, String password) {
        User user = this.metaproject.getUser(name);
        if (user == null) {
            return false;
        }
        return user.verifyPassword(password);
    }

    @Override
    public String toString() {
        return "Server";
    }

    private synchronized void startProjectUpdateThread() {
        if (this._saveIntervalMsec != -1) {
            this._updateThread = new Thread("Save Projects"){

                public void run() {
                    try {
                        while (Server.this._updateThread == this) {
                            2.sleep(Server.this._saveIntervalMsec);
                            Server.this.saveAllProjects();
                        }
                    }
                    catch (Throwable e) {
                        Log.getLogger().log(Level.INFO, "Exception caught", e);
                    }
                }
            };
            this._updateThread.setDaemon(true);
            this._updateThread.start();
        }
    }

    private synchronized void stopProjectUpdateThread() {
        this._updateThread = null;
    }

    @Override
    public synchronized boolean saveMetaProject(RemoteSession session) throws RemoteException {
        ArrayList errors = new ArrayList();
        log.info("Saving metaproject...");
        this.metaproject.save(errors);
        if (!errors.isEmpty()) {
            log.warning("Errors found saving metaproject");
            Server.dumpErrors(((MetaProjectImpl)this.metaproject).getKnowledgeBase().getProject(), errors);
        }
        return errors.size() == 0;
    }

    public synchronized void saveAllProjects() {
        for (Map.Entry<Project, ServerProject> entry : this._projectToServerProjectMap.entrySet()) {
            Project project = entry.getKey();
            ServerProject serverProject = entry.getValue();
            if (!serverProject.isDirty()) continue;
            Server.save(serverProject, project);
        }
        ArrayList errors = new ArrayList();
        this.metaproject.save(errors);
        if (!errors.isEmpty()) {
            log.warning("Errors found saving metaproject");
            Server.dumpErrors(((MetaProjectImpl)this.metaproject).getKnowledgeBase().getProject(), errors);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void save(ServerProject serverProject, Project project) {
        Log.getLogger().info("Saving " + project);
        ArrayList errors = new ArrayList();
        KnowledgeBase knowledgeBase = project.getKnowledgeBase();
        synchronized (knowledgeBase) {
            KnowledgeBase knowledgeBase2 = project.getInternalProjectKnowledgeBase();
            synchronized (knowledgeBase2) {
                KnowledgeBase kb = project.getKnowledgeBase();
                KnowledgeBaseFactory factory = kb.getKnowledgeBaseFactory();
                factory.saveKnowledgeBase(kb, project.getSources(), errors);
                Server.serverInstance._projectPluginManager.afterSave(project);
            }
        }
        if (serverProject != null) {
            serverProject.setClean();
        }
        Server.dumpErrors(project, errors);
    }

    private static void dumpErrors(Project p, Collection errors) {
        if (!errors.isEmpty()) {
            Log.getLogger().warning("Unable to save project " + p);
            Log.handleErrors(log, Level.WARNING, errors);
        }
    }

    private void closeProject(String name) {
        Project p = this._nameToOpenProjectMap.get(name);
        ServerProject sp = this._projectToServerProjectMap.get(p);
        HashSet<Session> sessionsToRemove = new HashSet<Session>();
        for (Map.Entry<RemoteSession, Collection<ServerProject>> entry : this._sessionToProjectsMap.entrySet()) {
            RemoteSession session = entry.getKey();
            Collection<ServerProject> serverProjects = entry.getValue();
            if (serverProjects.remove(sp)) {
                try {
                    sp.deregister(session);
                }
                catch (ServerSessionLost ssl) {
                    log.log(Level.WARNING, "Unexpected exception deregistering client", ssl);
                }
            }
            if (!serverProjects.isEmpty() || !(session instanceof Session)) continue;
            sessionsToRemove.add((Session)session);
        }
        for (Session session : sessionsToRemove) {
            this._sessions.remove(session);
            this._sessionToProjectsMap.remove(session);
        }
        Server.save(sp, p);
        p.dispose();
        this._projectToServerProjectMap.remove(p);
        this._nameToOpenProjectMap.remove(name);
    }

    public boolean isActive(RemoteSession session) {
        return this._sessions.contains(session);
    }

    public synchronized void disconnectFromProject(RemoteServerProject serverProject, RemoteSession session) throws ServerSessionLost {
        this.recordDisconnection(session, serverProject);
    }

    public synchronized Project getProject(String name) {
        return this._nameToOpenProjectMap.get(name);
    }

    public synchronized ServerProject getServerProject(Project p) {
        return this._projectToServerProjectMap.get(p);
    }

    @Override
    public synchronized ServerProject.ProjectStatus getProjectStatus(String name) {
        return this._nameToProjectStatusMap.get(name);
    }

    public synchronized void setProjectStatus(String name, ServerProject.ProjectStatus status) {
        ServerProject.ProjectStatus oldStatus = this._nameToProjectStatusMap.put(name, status);
        Project p = this._nameToOpenProjectMap.get(name);
        if (p != null) {
            KnowledgeBase kb = p.getKnowledgeBase();
            EventGeneratorFrameStore fs = kb.getFrameStoreManager().getFrameStoreFromClass(EventGeneratorFrameStore.class);
            fs.addCustomEvent(new ServerProjectStatusChangeEvent(name, oldStatus, status));
        }
    }

    public synchronized Collection<ServerProject> getCurrentProjects(RemoteSession session) {
        return this._sessionToProjectsMap.get(session);
    }

    public synchronized Collection<RemoteSession> getCurrentSessions() {
        return new ArrayList<RemoteSession>(this._sessions);
    }

    public synchronized Collection<RemoteSession> getCurrentSessions(RemoteServerProject project) {
        ArrayList<RemoteSession> sessions = new ArrayList<RemoteSession>();
        for (Map.Entry<RemoteSession, Collection<ServerProject>> entry : this._sessionToProjectsMap.entrySet()) {
            Session session;
            Collection<ServerProject> projects = entry.getValue();
            if (!projects.contains(project) || !Server.isCurrent(session = (Session)entry.getKey())) continue;
            sessions.add(session);
        }
        return sessions;
    }

    public synchronized void setFrameCalculatorDisabled(boolean disabled) {
        for (ServerProject sp : this._projectToServerProjectMap.values()) {
            sp.setFrameCalculatorDisabled(disabled);
        }
    }

    public synchronized MetaProject getMetaProjectNew() {
        return this.metaproject;
    }

    @Deprecated
    public synchronized KnowledgeBase getMetaProject() {
        return ((MetaProjectImpl)this.metaproject).getKnowledgeBase();
    }

    @Deprecated
    public synchronized Cls getProjectCls() {
        if (this.projectCls == null) {
            this.projectCls = ((MetaProjectImpl)this.metaproject).getCls(MetaProjectImpl.ClsEnum.Project);
        }
        return this.projectCls;
    }

    @Deprecated
    public synchronized Slot getNameSlot() {
        if (this.nameSlot == null) {
            this.nameSlot = ((MetaProjectImpl)this.metaproject).getSlot(MetaProjectImpl.SlotEnum.name);
        }
        return this.nameSlot;
    }

    private FrameListener getMetaProjectFrameListener() {
        if (this.metaprojectFrameListener == null) {
            this.metaprojectFrameListener = new FrameAdapter(){
                private Cls projectClass;
                {
                    this.projectClass = Server.this.getProjectCls();
                }

                public void ownSlotValueChanged(FrameEvent event) {
                    Instance frame = (Instance)event.getFrame();
                    if (frame.hasType(this.projectClass) && event.getSlot().equals(Server.this.nameSlot)) {
                        List oldValues = event.getOldValues();
                        final String oldName = oldValues != null && oldValues.size() > 0 ? CollectionUtilities.getFirstItem(oldValues).toString() : new String();
                        final String name = (String)frame.getOwnSlotValue(Server.this.nameSlot);
                        Server.this.singleJobAtATimeExecutor.submit(new Runnable(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            public void run() {
                                Server server = Server.this;
                                synchronized (server) {
                                    if (name != null && name.length() > 0) {
                                        if (oldName.length() == 0) {
                                            Server.this._nameToProjectStatusMap.put(name, ServerProject.ProjectStatus.CLOSED_FOR_MAINTENANCE);
                                            log.info("Project instance " + name + " was added to the metaproject.");
                                        } else {
                                            Server.this._nameToOpenProjectMap.put(name, Server.this._nameToOpenProjectMap.get(oldName));
                                            Server.this._nameToProjectStatusMap.put(name, Server.this._nameToProjectStatusMap.get(oldName));
                                            Server.this._nameToOpenProjectMap.remove(oldName);
                                            Server.this._nameToProjectStatusMap.remove(oldName);
                                            log.info("Project instance name was changed. Old name: " + oldName + "; New name: " + name);
                                        }
                                    }
                                }
                            }
                        });
                    }
                }
            };
        }
        return this.metaprojectFrameListener;
    }

    private FrameListener getMetaProjectProjectClsListener() {
        if (this.metaprojectProjectClsListener == null) {
            this.metaprojectProjectClsListener = new FrameAdapter(){

                public void ownSlotValueChanged(FrameEvent event) {
                    Server.this.singleJobAtATimeExecutor.submit(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void run() {
                            Server server = Server.this;
                            synchronized (server) {
                                HashSet keySet = new HashSet(Server.this._nameToProjectStatusMap.keySet());
                                for (String name : keySet) {
                                    ProjectInstance prj = Server.this.metaproject.getProject(name);
                                    if (prj != null) continue;
                                    Project p = (Project)Server.this._nameToOpenProjectMap.remove(name);
                                    Server.this._nameToProjectStatusMap.remove(name);
                                    if (p != null) {
                                        Server.this._projectToServerProjectMap.remove(p);
                                        p.dispose();
                                    }
                                    log.info("Project instance " + name + " was removed from the metaproject");
                                }
                            }
                        }
                    });
                }
            };
        }
        return this.metaprojectProjectClsListener;
    }

    private void addMetaProjectListeners() {
        if (this.metaproject != null) {
            this.getProjectCls();
            this.getNameSlot();
            KnowledgeBase kb = ((MetaProjectImpl)this.metaproject).getKnowledgeBase();
            ServerFrameStore.requestEventDispatch(kb);
            this.getMetaProjectFrameListener();
            kb.addFrameListener(this.metaprojectFrameListener);
            this.getMetaProjectProjectClsListener();
            this.projectCls.addFrameListener(this.metaprojectProjectClsListener);
        }
    }

    private void removeMetaProjectListeners() {
        if (this.metaprojectFrameListener != null) {
            try {
                ((MetaProjectImpl)this.metaproject).getKnowledgeBase().removeFrameListener(this.metaprojectFrameListener);
            }
            catch (Exception e) {
                log.log(Level.WARNING, "Could not remove metaproject frame listener", e);
            }
        }
        if (this.metaprojectProjectClsListener != null) {
            try {
                this.projectCls.removeFrameListener(this.metaprojectProjectClsListener);
            }
            catch (Exception e) {
                log.log(Level.WARNING, "Could not remove metaproject cls listener for cls Project", e);
            }
        }
    }

    @Override
    public synchronized void reinitialize() throws RemoteException {
        Log.getLogger().info("Server reinitializing");
        this.unBindName();
        this.clear();
        serverInstance = null;
        this.initialize();
        serverInstance = this;
        Server.afterLoad();
        this.bindName();
    }

    @Override
    public synchronized RemoteSession openSession(String username, String userIpAddress, String password) {
        Session session = null;
        if (this.isValid(username, password)) {
            boolean allowsDelegation = this.isServerOperationAllowed(new Session(username, userIpAddress, false), MetaProjectConstants.OPERATION_DELEGATE);
            session = new Session(username, userIpAddress, allowsDelegation);
            this._sessions.add(session);
            this.metaproject.getUser(username).setLastLogin(new Date());
        } else {
            Log.getLogger().warning("Failed login for user " + username + " IP: " + userIpAddress);
        }
        return session;
    }

    @Override
    public synchronized RemoteSession cloneSession(RemoteSession session) {
        if (!this._sessions.contains(session)) {
            return null;
        }
        session = new Session(session.getUserName(), session.getUserIpAddress(), session.allowDelegation());
        this._sessions.add(session);
        return session;
    }

    @Override
    public synchronized void closeSession(RemoteSession session) {
        this._sessions.remove(session);
    }

    @Override
    public synchronized Collection<RemoteSession> getCurrentSessions(String projectName, RemoteSession session) {
        ServerProject project = this.getServerProject(projectName);
        Collection<Object> currentSessions = project == null ? Collections.EMPTY_LIST : this.getCurrentSessions(project);
        return currentSessions;
    }

    @Override
    public synchronized Collection<String> getAvailableProjectNames(RemoteSession session) {
        Policy policy = this.metaproject.getPolicy();
        User user = session != null ? policy.getUserByName(session.getUserName()) : null;
        ArrayList<String> names = new ArrayList<String>();
        for (ProjectInstance instance : this.metaproject.getProjects()) {
            String name;
            ServerProject.ProjectStatus status;
            if (user != null && (!policy.isOperationAuthorized(user, MetaProjectConstants.OPERATION_DISPLAY_IN_PROJECT_LIST, instance) || !policy.isOperationAuthorized(user, MetaProjectConstants.OPERATION_READ, instance)) || (status = this._nameToProjectStatusMap.get(name = instance.getName())) != null && status != ServerProject.ProjectStatus.READY) continue;
            String fileName = instance.getLocation();
            if (fileName == null || fileName.length() == 0) {
                log.warning("Project with empty location will be ignored: " + name);
                continue;
            }
            URI uri = URIUtilities.createURI(fileName);
            String scheme = uri.getScheme();
            if (scheme != null && scheme.contains("http")) {
                BufferedReader reader = URIUtilities.createBufferedReader(uri);
                if (reader != null) {
                    names.add(instance.getName());
                    FileUtilities.close(reader);
                    continue;
                }
                Log.getLogger().warning("Missing project at " + fileName);
                continue;
            }
            File file = new File(fileName);
            if (file.exists() && file.isFile()) {
                names.add(instance.getName());
                continue;
            }
            Log.getLogger().warning("Missing project at " + fileName);
        }
        Collections.sort(names);
        return names;
    }

    @Override
    public synchronized Collection<ProjectInfo> getAvailableProjectInfo(RemoteSession session) {
        ArrayList<ProjectInfo> projectInfos = new ArrayList<ProjectInfo>();
        Collection<String> projectNames = this.getAvailableProjectNames(session);
        for (String projectName : projectNames) {
            try {
                ProjectInstance prj = this.metaproject.getProject(projectName);
                User owner = prj.getOwner();
                projectInfos.add(new ProjectInfo(prj.getName(), prj.getDescription(), owner == null ? null : owner.getName()));
            }
            catch (Exception e) {
                Log.getLogger().log(Level.WARNING, "Errors at retrieving project instance from metaproject. Project name" + projectName, e);
            }
        }
        return projectInfos;
    }

    public synchronized Collection<String> getAllProjectNames() {
        ArrayList<String> prjs = new ArrayList<String>(this._nameToProjectStatusMap.keySet());
        Collections.sort(prjs);
        return prjs;
    }

    public synchronized Map<String, ServerProject.ProjectStatus> getProjectsStatusMap() {
        return this._nameToProjectStatusMap;
    }

    @Override
    public synchronized RemoteServerProject openProject(String projectName, RemoteSession session) throws ServerSessionLost {
        if (!this._sessions.contains(session)) {
            Log.getLogger().warning("Failed to open project: Invalid " + session + " tried to open project " + projectName + ". Most likely user is not logged in.");
            return null;
        }
        if (this._nameToProjectStatusMap.get(projectName) == ServerProject.ProjectStatus.CLOSED_FOR_MAINTENANCE) {
            Log.getLogger().warning("Failed to open project: " + session + " tried to open project " + projectName + ", but project is closed for maintenance");
            return null;
        }
        if (!this.readAllowed(projectName, session)) {
            Log.getLogger().warning("Failed to open project: " + session + " tried to open project " + projectName + ", but user does not have read permission on this project.");
            return null;
        }
        ServerProject serverProject = null;
        Project p = this.getOrCreateProject(projectName);
        if (p != null) {
            serverProject = this.getServerProject(p);
            if (serverProject == null) {
                serverProject = this.createServerProject(projectName, p);
                this.addServerProject(p, serverProject);
            }
            if (this._sessionToProjectsMap.get(session) != null && this._sessionToProjectsMap.get(session).contains(serverProject)) {
                return null;
            }
            this.recordConnection(session, serverProject);
            Log.getLogger().info("Server: Opened project " + projectName + " for " + session + " on " + new Date());
        } else {
            Log.getLogger().warning("Failed to open project:  " + session + " tried to open project " + projectName + ", but operation failed." + "Possible causes: project with this name is not defined in the metaproject;" + "project is not in the ready status, or project could not be opened by the server" + "(check previous server logs)");
        }
        return serverProject;
    }

    @Override
    public synchronized RemoteServerProject openMetaProject(RemoteSession session) throws RemoteException {
        if (!this.isServerOperationAllowed(session, MetaProjectConstants.OPERATION_ADMINISTER_SERVER)) {
            log.warning("Failed attempt to open metaproject by " + session + ". Not enough privileges.");
            throw new SecurityException("Not enough privileges to open metaproject.");
        }
        String metaProjectName = "Meta-Project";
        if (this.serverMetaProject == null) {
            KnowledgeBase metaProjectKb = ((MetaProjectImpl)this.metaproject).getKnowledgeBase();
            Server.localizeKB(metaProjectKb);
            this.serverMetaProject = new ServerProject(this, this.getURI(metaProjectName), this.metaproject.getProject(metaProjectName), metaProjectKb.getProject());
        }
        this.serverMetaProject.register(session);
        return this.serverMetaProject;
    }

    @Override
    public synchronized RemoteServerProject createProject(String newProjectName, RemoteSession session, KnowledgeBaseFactory kbfactory, boolean saveToMetaProject) throws RemoteException {
        Project project = null;
        for (ProjectInstance instance : this.metaproject.getProjects()) {
            String projectName = instance.getName();
            if (!projectName.equals(newProjectName)) continue;
            Log.getLogger().warning("Server: Attempting to create server project with existing project name. No server project created.");
            return null;
        }
        String newProjectsDir = ServerProperties.getDefaultNewProjectSaveDirectory();
        URI uri = URIUtilities.createURI(newProjectsDir + File.separator + newProjectName + ".pprj");
        if (uri == null) {
            Log.getLogger().warning("Could not create new server project at location " + newProjectsDir + File.separator + newProjectName + ".pprj");
            return null;
        }
        ArrayList errors = new ArrayList();
        project = Project.createNewProject(kbfactory, errors);
        Log.getLogger().info("Server: Created server project at: " + uri);
        if (errors.size() > 0) {
            Log.handleErrors(log, Level.SEVERE, errors);
            return null;
        }
        project.setProjectURI(uri);
        if (kbfactory instanceof ClipsKnowledgeBaseFactory) {
            ClipsKnowledgeBaseFactory.setSourceFiles(project.getSources(), newProjectName + ".pont", newProjectName + ".pins");
        }
        project.save(errors);
        if (errors.size() > 0) {
            Log.handleErrors(log, Level.SEVERE, errors);
            return null;
        }
        project = Project.loadProjectFromURI(uri, new ArrayList(), true);
        if (serverInstance != null) {
            this._projectPluginManager.afterLoad(project);
        }
        Server.localizeProject(project);
        this._nameToOpenProjectMap.put(newProjectName, project);
        if (saveToMetaProject) {
            ProjectInstance newProjectInstance = this.metaproject.createProject(newProjectName);
            newProjectInstance.setLocation(newProjectsDir + File.separator + newProjectName + ".pprj");
            this.metaproject.save(errors);
            Log.handleErrors(log, Level.SEVERE, errors);
        }
        return this.getServerProject(project);
    }

    @Override
    public synchronized void setProjectStatus(String projectName, ServerProject.ProjectStatus status, RemoteSession session) {
        ServerProject.ProjectStatus oldStatus = this._nameToProjectStatusMap.put(projectName, status);
        Project p = this._nameToOpenProjectMap.get(projectName);
        if (p != null) {
            KnowledgeBase kb = p.getKnowledgeBase();
            EventGeneratorFrameStore fs = kb.getFrameStoreManager().getFrameStoreFromClass(EventGeneratorFrameStore.class);
            fs.addCustomEvent(new ServerProjectStatusChangeEvent(projectName, oldStatus, status));
        }
    }

    @Override
    public synchronized void notifyProject(String projectName, String message, RemoteSession session) {
        Project p = this._nameToOpenProjectMap.get(projectName);
        if (p != null) {
            KnowledgeBase kb = p.getKnowledgeBase();
            EventGeneratorFrameStore fs = kb.getFrameStoreManager().getFrameStoreFromClass(EventGeneratorFrameStore.class);
            fs.addCustomEvent(new ServerProjectNotificationEvent(projectName, message));
        }
    }

    @Override
    public synchronized boolean createUser(String userName, String password) {
        ArrayList names = new ArrayList();
        for (User instance : this.metaproject.getUsers()) {
            String existingUserName = instance.getName();
            if (!existingUserName.equals(userName)) continue;
            Log.getLogger().warning("Server: Could not create user with name " + userName + ". User name already exists.");
            return false;
        }
        User newUserInstance = this.metaproject.createUser(userName, password);
        ArrayList errors = new ArrayList();
        boolean success = this.metaproject.save(errors);
        Log.handleErrors(log, Level.SEVERE, errors);
        return success && errors.size() == 0;
    }

    @Override
    public synchronized boolean hasValidCredentials(String userName, String password) {
        return this.isValid(userName, password);
    }

    @Override
    public synchronized void shutdown() {
        log.info("Received shutdown request.");
        try {
            this.unBindName();
        }
        catch (RemoteException re) {
            log.log(Level.WARNING, "Exception caught unbinding server name", re);
        }
        this.removeMetaProjectListeners();
        this.saveAllProjects();
        Thread thread = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    SystemUtilities.sleepMsec(100);
                    Log.getLogger().info("Server exiting.");
                    Server server = Server.this;
                    synchronized (server) {
                        for (Project p : Server.this._projectToServerProjectMap.keySet()) {
                            KnowledgeBase knowledgeBase = p.getKnowledgeBase();
                            synchronized (knowledgeBase) {
                                KnowledgeBase knowledgeBase2 = p.getInternalProjectKnowledgeBase();
                                synchronized (knowledgeBase2) {
                                    try {
                                        Server.this._projectPluginManager.beforeClose(p);
                                    }
                                    catch (Exception e) {
                                        Log.getLogger().log(Level.INFO, "Exception caught cleaning up", e);
                                    }
                                }
                            }
                        }
                    }
                }
                catch (Exception e) {
                    Log.getLogger().log(Level.INFO, "Exception caught", e);
                }
                finally {
                    System.exit(0);
                }
            }
        };
        thread.start();
    }

    @Override
    public synchronized void shutdown(String projectName, RemoteSession session) {
        if (!this.isServerOperationAllowed(session, MetaProjectConstants.OPERATION_ADMINISTER_SERVER) && !this.isOperationAllowed(session, MetaProjectConstants.OPERATION_STOP_REMOTE_PROJECT, projectName)) {
            log.warning("Unauthorized attempt to shutdown project " + projectName + " by " + session.getUserName() + " @ " + session.getUserIpAddress());
            return;
        }
        this.setProjectStatus(projectName, ServerProject.ProjectStatus.CLOSED_FOR_MAINTENANCE, session);
        this.closeProject(projectName);
    }

    @Override
    public synchronized void killOtherUserSession(RemoteSession sessionToKill, RemoteSession session) {
        this.killOtherUserSession(sessionToKill, session, 0);
    }

    @Override
    public void killOtherUserSession(final RemoteSession sessionToKill, final RemoteSession session, final int finalGracePeriod) {
        Thread killSessionThread = new Thread("Kill other session thread"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Collection projects;
                HashSet<ServerProject> projectsWithSessionRemoved = new HashSet<ServerProject>();
                HashSet<ServerProject> candidateProjectsToKill = new HashSet<ServerProject>();
                boolean partial = false;
                Server server = Server.this;
                synchronized (server) {
                    projects = (Collection)Server.this._sessionToProjectsMap.get(sessionToKill);
                    if (projects == null) {
                        Server.this._sessionToProjectsMap.remove(sessionToKill);
                        Server.this._sessions.remove(sessionToKill);
                        return;
                    }
                    for (ServerProject serverProject : projects) {
                        String projectName = serverProject.getMetaProjectInstance().getName();
                        if (!Server.this.isServerOperationAllowed(session, MetaProjectConstants.OPERATION_ADMINISTER_SERVER) && !Server.this.isOperationAllowed(session, MetaProjectConstants.OPERATION_KILL_OTHER_USER_SESSION, projectName)) continue;
                        candidateProjectsToKill.add(serverProject);
                        Project p = (Project)Server.this._nameToOpenProjectMap.get(projectName);
                        if (p != null) {
                            KnowledgeBase kb = p.getKnowledgeBase();
                            EventGeneratorFrameStore fs = kb.getFrameStoreManager().getFrameStoreFromClass(EventGeneratorFrameStore.class);
                            fs.addCustomEvent(new ServerProjectSessionClosedEvent(projectName, sessionToKill));
                            continue;
                        }
                        partial = true;
                    }
                }
                try {
                    6.sleep(finalGracePeriod * 1000);
                }
                catch (InterruptedException e) {
                    log.severe("Unexpected interrupt - you trying to kill me or what?");
                }
                server = Server.this;
                synchronized (server) {
                    for (ServerProject serverProject : candidateProjectsToKill) {
                        try {
                            serverProject.deregister(sessionToKill);
                            projectsWithSessionRemoved.add(serverProject);
                        }
                        catch (Throwable t) {
                            String projectName = "(unknown)";
                            try {
                                projectName = serverProject.getMetaProjectInstance().getName();
                            }
                            catch (Exception e) {
                                Log.emptyCatchBlock(e);
                            }
                            log.log(Level.WARNING, "Could not deregister session " + sessionToKill + " from project " + projectName, t);
                        }
                    }
                    if (partial) {
                        projects.removeAll(projectsWithSessionRemoved);
                    } else {
                        Server.this._sessionToProjectsMap.remove(sessionToKill);
                        Server.this._sessions.remove(sessionToKill);
                    }
                }
            }
        };
        killSessionThread.start();
    }

    @Override
    public void shutdownProject(RemoteSession session, String projectName, float warningTimeInSeconds) throws RemoteException {
        if (session == null) {
            log.warning("Can only shutdown the remote project " + projectName + " in multi-user mode.");
            return;
        }
        int lastWarning = 5;
        int finalGracePeriodInSeconds = 7;
        int t = (int)warningTimeInSeconds;
        ArrayList<Integer> ints = new ArrayList<Integer>();
        while (t > lastWarning) {
            ints.add(t);
            if (t >= 120) {
                t = t / 120 * 60;
                continue;
            }
            if (t >= 20) {
                t = t / 20 * 10;
                continue;
            }
            if (t >= 10) {
                t = t / 10 * 5;
                continue;
            }
            t = lastWarning;
        }
        ints.add(t);
        this.shutdownProject(session, projectName, ints.toArray(new Integer[ints.size()]), finalGracePeriodInSeconds);
    }

    @Override
    public synchronized void shutdownProject(RemoteSession session, String projectName, Integer[] warningTimesInSeconds, int finalGracePeriodInSeconds) throws RemoteException {
        if (session == null) {
            log.warning("Can only shutdown the remote project " + projectName + " in multi-user mode.");
            return;
        }
        if (!this.isServerOperationAllowed(session, MetaProjectConstants.OPERATION_ADMINISTER_SERVER) && !this.isOperationAllowed(session, MetaProjectConstants.OPERATION_STOP_REMOTE_PROJECT, projectName)) {
            throw new SecurityException("Operation not permitted: Shutdown remote project " + projectName + " for user: " + session.getUserName() + " (" + session.getUserIpAddress() + ")");
        }
        Arrays.sort(warningTimesInSeconds, new Comparator<Integer>(){

            @Override
            public int compare(Integer o1, Integer o2) {
                return o2.compareTo(o1);
            }
        });
        Runnable projShutdownNotificaitonThread = this.getProjectShutdownRunnable(session, projectName, warningTimesInSeconds, finalGracePeriodInSeconds);
        FutureTask<Object> task = new FutureTask<Object>(projShutdownNotificaitonThread, null);
        this.serverExecutor.submit(task);
        this.projectToShutdownTaskNotificationMap.put(projectName, task);
    }

    @Override
    public synchronized boolean cancelShutdownProject(RemoteSession session, String projectName) {
        boolean success = false;
        FutureTask<Object> task = null;
        task = this.projectToShutdownTaskNotificationMap.get(projectName);
        if (task == null || task.isDone()) {
            return false;
        }
        success = task.cancel(true);
        if (!success) {
            log.info("Could not cancel task: " + task);
        } else {
            log.info("Task canceled: " + task);
            this.projectToShutdownTaskNotificationMap.remove(projectName);
            this.setProjectStatus(projectName, ServerProject.ProjectStatus.READY);
            this.notifyProject(projectName, "Shut down of project " + projectName + " has been canceled by the administrator.", session);
        }
        return success;
    }

    private Runnable getProjectShutdownRunnable(final RemoteSession session, final String projectName, final Integer[] warningTimesInSeconds, final int finalGracePeriodInSeconds) {
        Runnable projShutdownNotificaitonThread = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Server.this.setProjectStatus(projectName, ServerProject.ProjectStatus.SHUTTING_DOWN, session);
                for (int i = 0; i < warningTimesInSeconds.length; ++i) {
                    int timeLeft = warningTimesInSeconds[i];
                    int timeToNextWarning = i == warningTimesInSeconds.length - 1 ? timeLeft : timeLeft - warningTimesInSeconds[i + 1];
                    String message = "Remote project " + projectName + " will be shut down in " + (timeLeft <= 60 ? "" + timeLeft + " seconds." : "" + timeLeft / 60 + " minutes.");
                    Server.this.notifyProject(projectName, message, session);
                    try {
                        Thread.sleep(timeToNextWarning * 1000);
                        continue;
                    }
                    catch (InterruptedException e) {
                        FutureTask task;
                        Server server = Server.this;
                        synchronized (server) {
                            task = (FutureTask)Server.this.projectToShutdownTaskNotificationMap.get(projectName);
                        }
                        if (task != null && task.isCancelled()) {
                            log.warning("Thread for shutting down project " + projectName + " has been interrupted.");
                        } else {
                            log.severe("Thread for shutting down project " + projectName + " has been interrupted for no good reason.");
                        }
                        return;
                    }
                }
                Server.this.setProjectStatus(projectName, ServerProject.ProjectStatus.CLOSED_FOR_MAINTENANCE, session);
                if (finalGracePeriodInSeconds != 0) {
                    try {
                        Thread.sleep(finalGracePeriodInSeconds * 1000);
                    }
                    catch (InterruptedException e) {
                        FutureTask task;
                        Server server = Server.this;
                        synchronized (server) {
                            task = (FutureTask)Server.this.projectToShutdownTaskNotificationMap.get(projectName);
                        }
                        if (task != null && task.isCancelled()) {
                            log.warning("Thread for shutting down project " + projectName + " has been interrupted.");
                        } else {
                            log.severe("Thread for shutting down project " + projectName + " has been interrupted for no good reason.");
                        }
                        return;
                    }
                }
                Server server = Server.this;
                synchronized (server) {
                    Server.this.shutdown(projectName, session);
                    Server.this.projectToShutdownTaskNotificationMap.remove(projectName);
                }
            }
        };
        return projShutdownNotificaitonThread;
    }

    @Override
    public boolean allowsCreateUsers() throws RemoteException {
        return ServerProperties.getAllowsCreateUsers();
    }

    @Override
    public synchronized boolean isOperationAllowed(RemoteSession session, Operation op, String projectName) {
        return this.isServerOperationAllowed(session, op, this.metaproject.getPolicy().getProjectInstanceByName(projectName));
    }

    @Override
    public synchronized boolean isServerOperationAllowed(RemoteSession session, Operation op) {
        ServerInstance firstServerInstance = this.metaproject.getPolicy().getFirstServerInstance();
        return firstServerInstance == null ? true : this.isServerOperationAllowed(session, op, firstServerInstance);
    }

    @Override
    public synchronized boolean isServerOperationAllowed(RemoteSession session, Operation op, String serverName) {
        return this.isServerOperationAllowed(session, op, this.metaproject.getPolicy().getServerInstanceByName(serverName));
    }

    @Override
    public synchronized boolean isGroupOperationAllowed(RemoteSession session, Operation op, String groupName) {
        return this.isServerOperationAllowed(session, op, this.metaproject.getGroup(groupName));
    }

    private boolean isServerOperationAllowed(RemoteSession session, Operation op, PolicyControlledObject policyControlledObject) {
        Policy policy = this.metaproject.getPolicy();
        User user = policy.getUserByName(session.getUserName());
        if (user == null || policyControlledObject == null) {
            return false;
        }
        return policy.isOperationAuthorized(user, op, policyControlledObject);
    }

    @Override
    public synchronized Collection<Operation> getAllowedOperations(RemoteSession session, String projectName, String userName) {
        ArrayList<Operation> allowedOps = new ArrayList<Operation>();
        Policy policy = this.metaproject.getPolicy();
        User user = policy.getUserByName(userName);
        ProjectInstance project = this.metaproject.getPolicy().getProjectInstanceByName(projectName);
        if (user == null || project == null) {
            return allowedOps;
        }
        for (Operation op : policy.getKnownOperations()) {
            if (!policy.isOperationAuthorized(user, op, project)) continue;
            allowedOps.add(op);
        }
        return allowedOps;
    }

    @Override
    public Object executeServerJob(ServerJob job, RemoteSession session) {
        job.fixLoader();
        return job.run();
    }
}

