/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.server;

import edu.stanford.smi.protege.resource.ResourceKey;
import edu.stanford.smi.protege.server.RegisterUserServerPanel;
import edu.stanford.smi.protege.server.RemoteServer;
import edu.stanford.smi.protege.server.RemoteSession;
import edu.stanford.smi.protege.server.Server;
import edu.stanford.smi.protege.server.socket.SSLFactory;
import edu.stanford.smi.protege.util.AllowableAction;
import edu.stanford.smi.protege.util.ApplicationProperties;
import edu.stanford.smi.protege.util.ComponentFactory;
import edu.stanford.smi.protege.util.LabeledComponent;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protege.util.ModalDialog;
import edu.stanford.smi.protege.util.SystemUtilities;
import edu.stanford.smi.protege.util.Validatable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.rmi.ConnectException;
import java.rmi.ConnectIOException;
import java.rmi.Naming;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.rmi.UnknownHostException;
import java.rmi.UnmarshalException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class ServerPanel
extends JPanel
implements Validatable {
    private static final long serialVersionUID = 4729412021203886589L;
    private static final transient Logger log = Log.getLogger(ServerPanel.class);
    private static String _lastPassword = null;
    private JTextField _usernameField = ComponentFactory.createTextField();
    private JTextField _passwordField;
    private JTextField _hostNameField;
    private JComponent _registerUserPanel;
    private JCheckBox _administerServerChekBox;
    private RemoteServer _server;
    private RemoteSession _session;
    private static final String USER_NAME = ServerPanel.class.getName() + ".user_name";
    private static final String HOST_NAME = ServerPanel.class.getName() + ".host_name";

    public ServerPanel() {
        this._usernameField.setText(ApplicationProperties.getString(USER_NAME, "Guest"));
        this._passwordField = ComponentFactory.createPasswordField();
        if (_lastPassword != null) {
            this._passwordField.setText(_lastPassword);
        } else if (this._usernameField.getText().equals("Guest")) {
            this._passwordField.setText("guest");
        }
        this._hostNameField = ComponentFactory.createTextField();
        this._hostNameField.setText(ApplicationProperties.getString(HOST_NAME, "localhost"));
        this.setLayout(new BorderLayout());
        JPanel panel = new JPanel(new GridLayout(5, 0));
        panel.add(new LabeledComponent("Host Machine Name", this._hostNameField));
        panel.add(new LabeledComponent("User Name", this._usernameField));
        panel.add(new LabeledComponent("Password", this._passwordField));
        this._registerUserPanel = this.getRegisterUserPanel();
        panel.add(this._registerUserPanel);
        this._administerServerChekBox = ComponentFactory.createCheckBox("Administer server (requires privileges)");
        this._administerServerChekBox.setSelected(false);
        panel.add(this._administerServerChekBox);
        this.add((Component)panel, "North");
    }

    public boolean validateContents() {
        boolean isValid = false;
        try {
            isValid = this.isValidConfiguration();
        }
        catch (Exception e) {
            log.log(Level.WARNING, "Could not log in", e);
        }
        return isValid;
    }

    private boolean isValidConfiguration() {
        boolean isValid = false;
        String serverName = this._hostNameField.getText();
        this._server = this.connectToHost(serverName);
        if (this._server != null) {
            String username = this._usernameField.getText();
            String password = this._passwordField.getText();
            this._session = this.createSession(username, password);
            isValid = this._session != null;
        }
        this.saveFields();
        return isValid;
    }

    public void saveContents() {
    }

    private void saveFields() {
        ApplicationProperties.setString(USER_NAME, this._usernameField.getText());
        ApplicationProperties.setString(HOST_NAME, this._hostNameField.getText());
        _lastPassword = this._passwordField.getText();
    }

    public RemoteServer getServer() {
        return this._server;
    }

    public RemoteSession getSession() {
        return this._session;
    }

    public boolean isAdminsterServerActivated() {
        return this._administerServerChekBox.isSelected();
    }

    private RemoteServer connectToHost(String serverName) {
        RemoteServer server = null;
        try {
            if (SSLFactory.useSSL(SSLFactory.Context.LOGIN)) {
                SSLFactory.resetAuth();
            }
            server = (RemoteServer)Naming.lookup("//" + serverName + "/" + Server.getBoundName());
            if (SSLFactory.useSSL(SSLFactory.Context.LOGIN) && !SSLFactory.checkAuth()) {
                log.severe("Requested ssl security but server is not secured.");
                return null;
            }
        }
        catch (UnknownHostException e) {
            this.log("Trying to connect to an unknown host: " + serverName, e);
            ModalDialog.showMessageDialog(this, "You are trying to connect to an unknown host: " + serverName + "\n\n" + "A possible cause of this error is that the specified hostname and port are not correct.", "Unkown host", 14);
        }
        catch (ConnectException e) {
            this.log("Cannot connect to: " + serverName + ". " + e.getMessage(), e);
            ModalDialog.showMessageDialog(this, "Cannot connect to: " + serverName + "\n\n" + "Possible causes of this error are firewall or network configuration problems.\n" + "Please check also that the hostname and port are correct.", "Unable to connect", 14);
        }
        catch (ConnectIOException e) {
            this.log("Cannot connect to: " + serverName + ". " + e.getMessage(), e);
            ModalDialog.showMessageDialog(this, "Cannot connect to: " + serverName + "\n\n" + "Possible causes of this error are firewall or network configuration problems.\n" + "Please check also that the hostname and port are correct.", "IO connection error", 14);
        }
        catch (UnmarshalException e) {
            this.log("Unmarshalling exception. Possibly, the server and client use different versions of Protege " + e.getMessage(), e);
            ModalDialog.showMessageDialog(this, "There was a connection problem to: " + serverName + "\n\n" + "Most likely cause is that the server and client are running different versions of Protege.", "Unmarshalling exception", 14);
        }
        catch (NotBoundException e) {
            this.log("Not bound exception: " + serverName + ". " + e.getMessage() + " Is the Protege server started?", e);
            ModalDialog.showMessageDialog(this, "Cannot connect to: " + serverName + "\n\n" + "Most likely cause of this problem is that the Protege server is not running.\n" + "Please check also that the hostname and port are correct.\n" + "This error can also be caused by firewall or network problems.", "Not bound exception", 14);
        }
        catch (Exception e) {
            this.log("Error at connecting to: " + serverName + ". " + e.getMessage(), e);
            ModalDialog.showMessageDialog(this, "An error occured at connecting to: " + serverName + "\n\n" + "See console for more details.", "Error at connect", 14);
        }
        return server;
    }

    private RemoteSession createSession(String username, String password) {
        try {
            this.getAllowsUserCreate(this._server);
        }
        catch (Exception e) {
            this.log("Firewall or network problems when connecting to the server. " + e.getMessage() + " Server ref: " + this._server, e);
            ModalDialog.showMessageDialog(this, "Cannot connect to server.\nPossible causes of this error are firewall or network configuration problems.\n", "Unable to connect", 14);
            return null;
        }
        RemoteSession session = null;
        try {
            session = this._server.openSession(username, SystemUtilities.getMachineIpAddress(), password);
            if (session == null) {
                this.log("Invalid login for " + username, null);
                ModalDialog.showMessageDialog((Component)this, "Invalid username and password. Please try again.", "Login failed");
            }
        }
        catch (UnknownHostException e) {
            this.log("Connection to RMI registry successful, but retrieved an unknown hostname from the RMI registry.\nMost probable cause is a misconfiguration of the java.rmi.server.hostname Java argument on the server.\nServer reference: " + this._server, e);
            ModalDialog.showMessageDialog(this, "Connection to RMI registry successful, but retrieved an unknown hostname from the RMI registry.\nMost probable cause is a misconfiguration of the java.rmi.server.hostname Java argument on the server.\nServer reference: " + this._server, "Unkown host", 14);
        }
        catch (ConnectException e) {
            this.log("Connection to RMI registry successful, but cannot connect to the server.\nPossible cause is a misconfiguration of the java.rmi.server.hostname Java argument on the server, or\na network or firwall problemServer reference: " + this._server, e);
            ModalDialog.showMessageDialog(this, "Connection to RMI registry successful, but retrieved an unknown hostname from the RMI registry.\nPossible cause is a misconfiguration of the java.rmi.server.hostname Java argument on the server, or\na network or firwall problemServer reference: " + this._server, "Unkown host", 14);
        }
        catch (ConnectIOException e) {
            this.log("Connection to RMI registry successful, but cannot connect to the server.\nPossible cause is a misconfiguration of the java.rmi.server.hostname Java argument on the server, or\na network or firwall problemServer reference: " + this._server, e);
            ModalDialog.showMessageDialog(this, "Connection to RMI registry successful, but retrieved an unknown hostname from the RMI registry.\nPossible cause is a misconfiguration of the java.rmi.server.hostname Java argument on the server, or\na network or firwall problemServer reference: " + this._server, "Unkown host", 14);
        }
        catch (UnmarshalException e) {
            this.log("Connection to RMI registry successful, but there was an unmarshalling exception connecting to the server.\nPossibly, the server and client use different versions of Protege." + e.getMessage(), e);
            ModalDialog.showMessageDialog(this, "Connection to RMI registry successful, but there was an unmarshalling exception connecting to the server.\nPossibly, the server and client use different versions of Protege.", "Unmarshalling exception", 14);
        }
        catch (RemoteException e) {
            log.log(Level.WARNING, "Connection to RMI registry successful, but at error at creating session for " + username + " Server ref: " + this._server, e);
            ModalDialog.showMessageDialog((Component)this, "There was an error at checking the login credentails.", "Error at login");
        }
        return session;
    }

    private JComponent getRegisterUserPanel() {
        AllowableAction registerUserAction = this.createRegisterUserAction();
        JButton registerUserButton = ComponentFactory.createButton(registerUserAction);
        registerUserButton.setText("New user");
        registerUserButton.setToolTipText("Register new user (Checks first if server allows the creation of new users)");
        LabeledComponent registerUserPanel = new LabeledComponent("", null);
        registerUserPanel.add((Component)registerUserButton, "East");
        return registerUserPanel;
    }

    private AllowableAction createRegisterUserAction() {
        AllowableAction action = new AllowableAction(new ResourceKey("Create new user")){
            private static final long serialVersionUID = -5124239014343816470L;

            public void actionPerformed(ActionEvent e) {
                String hostName = ServerPanel.this._hostNameField.getText();
                if (ServerPanel.this._hostNameField == null || hostName.length() == 0) {
                    ModalDialog.showMessageDialog((Component)ServerPanel.this, "Server host name is empty. Please set first the server host name before registering.", "Error: Empty Server Name");
                    return;
                }
                if (!ServerPanel.this.serverAllowsUserCreate(hostName)) {
                    return;
                }
                try {
                    ServerPanel.this._server = ServerPanel.this.connectToHost(hostName);
                }
                catch (Exception ex) {
                    log.log(Level.WARNING, "Error at connecting to host " + hostName, ex);
                    ModalDialog.showMessageDialog((Component)ServerPanel.this, "Cannot connect to server: " + hostName + "\nPlease check that the server name is correct." + "\nThis error may also indicate firewall problems.", "Error: Connect to server");
                    return;
                }
                RegisterUserServerPanel regUserPanel = new RegisterUserServerPanel(hostName);
                int ret = ModalDialog.showDialog(ServerPanel.this, regUserPanel, "Register new user", 11);
                if (ret == 1) {
                    ServerPanel.this._usernameField.setText(regUserPanel.getUsername());
                    ServerPanel.this._passwordField.setText(regUserPanel.getPassword());
                }
            }
        };
        return action;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean serverAllowsUserCreate(String serverName) {
        if (serverName == null) {
            return false;
        }
        if ((serverName = serverName.trim()).length() == 0) {
            return false;
        }
        this.setCursor(Cursor.getPredefinedCursor(3));
        RemoteServer server = this.connectToHost(serverName);
        if (server == null) {
            return false;
        }
        try {
            boolean allowsUserCreate = this.getAllowsUserCreate(server);
            if (!allowsUserCreate) {
                this.setCursor(Cursor.getDefaultCursor());
                ModalDialog.showMessageDialog((Component)this, "Server " + serverName + " does not allow the creation of new users.\n", "Warning");
            }
            boolean bl = allowsUserCreate;
            return bl;
        }
        catch (Exception e) {
            this.log("There was an error at querying the server whether it allows the creation of new users", e);
            this.setCursor(Cursor.getDefaultCursor());
            ModalDialog.showMessageDialog((Component)this, "There was an error at querying the server whether it allows the creation of users", "Warning");
            boolean bl = false;
            return bl;
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    private boolean getAllowsUserCreate(RemoteServer server) throws RemoteException {
        boolean allowsUserCreate = false;
        try {
            allowsUserCreate = server.allowsCreateUsers();
        }
        catch (RemoteException e) {
            this.log("Error at pinging server", e);
            throw e;
        }
        return allowsUserCreate;
    }

    private void log(String message, Exception e) {
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, message, e);
        }
        log.warning(message);
    }
}

