/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.server;

import edu.stanford.smi.protege.server.RemoteServer;
import edu.stanford.smi.protege.server.RemoteSession;
import edu.stanford.smi.protege.server.Session;
import edu.stanford.smi.protege.util.ApplicationProperties;
import edu.stanford.smi.protege.util.ComponentFactory;
import edu.stanford.smi.protege.util.Log;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.rmi.RemoteException;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;

public class ServerProjectPanel
extends JPanel {
    private static final long serialVersionUID = 1275501290404489474L;
    private RemoteServer _server;
    private RemoteSession _session;
    private JTable _projectTable;
    private String _lastOpenedPrj = "";
    public static final String SERVER_LAST_OPENED_PROJECT_PROP = "server.last.opened.project";

    public ServerProjectPanel(RemoteServer server, RemoteSession session) {
        this._server = server;
        this._session = session;
        this._projectTable = ComponentFactory.createTable(null);
        this._lastOpenedPrj = ApplicationProperties.getString(SERVER_LAST_OPENED_PROJECT_PROP, "");
        this.setLayout(new BorderLayout());
        this.add(ComponentFactory.createScrollPane(this._projectTable));
        this.loadTable();
        this.setMinimumSize(new Dimension(400, 300));
    }

    private void loadTable() {
        try {
            Collection<String> names = this._server.getAvailableProjectNames(this._session);
            Iterator<String> iterator = names.iterator();
            Object[][] data = new Object[names.size()][2];
            int lastOpenPrjIndex = 0;
            for (int i = 0; i < names.size(); ++i) {
                String name = iterator.next();
                if (name.equals(this._lastOpenedPrj)) {
                    lastOpenPrjIndex = i;
                }
                data[i][0] = name;
                data[i][1] = ServerProjectPanel.sessionsToString(this._server.getCurrentSessions(name, this._session));
            }
            Object[] columns = new Object[]{"Project", "Current Users"};
            this._projectTable.setModel(new DefaultTableModel(data, columns));
            this._projectTable.createDefaultColumnsFromModel();
            if (names.size() > 0) {
                this._projectTable.setRowSelectionInterval(lastOpenPrjIndex, lastOpenPrjIndex);
            }
        }
        catch (RemoteException e) {
            Log.getLogger().severe(Log.toString(e));
        }
    }

    private static String sessionsToString(Collection userNames) {
        StringBuffer s = new StringBuffer();
        for (Session session : userNames) {
            if (s.length() > 0) {
                s.append(", ");
            }
            s.append(session.getUserName() + " (" + session.getUserIpAddress() + ")");
        }
        return s.toString();
    }

    public String getProjectName() {
        String name;
        int row = this._projectTable.getSelectedRow();
        if (row < 0) {
            name = null;
        } else {
            name = (String)this._projectTable.getValueAt(row, 0);
            ApplicationProperties.setString(SERVER_LAST_OPENED_PROJECT_PROP, name);
        }
        return name;
    }
}

