/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.server;

import edu.stanford.smi.protege.server.RemoteSession;
import java.io.Serializable;
import java.util.UUID;

public class Session
implements RemoteSession,
Serializable {
    private static final long serialVersionUID = -7027997614420432217L;
    private static int nextPrettyId = 0;
    private int prettyId;
    private UUID id;
    private boolean allowDelegation;
    private String userName;
    private String delegateUserName;
    private String userIpAddress;
    private long startTime;

    public Session(String userName, String userIpAddress) {
        this(userName, userIpAddress, false);
    }

    public Session(String userName, String userIpAddress, boolean allowDelegation) {
        this.prettyId = nextPrettyId++;
        this.id = UUID.randomUUID();
        this.allowDelegation = allowDelegation;
        this.userName = userName;
        this.delegateUserName = null;
        this.userIpAddress = userIpAddress;
        this.startTime = Session.currentTime();
    }

    public Session() {
    }

    public int getId() {
        return this.prettyId;
    }

    public boolean allowDelegation() {
        return this.allowDelegation;
    }

    public void setDelegate(String delegateUserName) {
        if (!this.allowDelegation) {
            throw new IllegalAccessError("Not allowed to delegate");
        }
        this.delegateUserName = delegateUserName;
    }

    public String getUserName() {
        if (this.allowDelegation && this.delegateUserName != null) {
            return this.delegateUserName;
        }
        return this.userName;
    }

    public String getRealUserName() {
        return this.userName;
    }

    public String getUserIpAddress() {
        return this.userIpAddress;
    }

    public long getStartTime() {
        return this.startTime;
    }

    private static long currentTime() {
        return System.currentTimeMillis();
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof Session)) {
            return false;
        }
        Session other = (Session)o;
        return this.id.equals(other.id) && this.userName.equals(other.userName) && this.allowDelegation == other.allowDelegation;
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public String toString() {
        return "Session(id=" + this.prettyId + ", user=" + this.userName + ")";
    }
}

