/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.server;

import edu.stanford.smi.protege.server.RemoteSimpleStream;
import edu.stanford.smi.protege.server.socket.RmiSocketFactory;
import edu.stanford.smi.protege.server.socket.SSLFactory;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;

public class SimpleStream
implements RemoteSimpleStream {
    private final int bufferSize = 0x100000;
    private InputStream is;
    private URL url;

    public SimpleStream(URL url) throws RemoteException {
        this.url = url;
        try {
            this.is = url.openStream();
        }
        catch (IOException ioe) {
            throw new RemoteException("Could not open remote file " + url, ioe);
        }
        UnicastRemoteObject.exportObject(this, SSLFactory.getServerPort(SSLFactory.Context.ALWAYS), new RmiSocketFactory(SSLFactory.Context.ALWAYS), new RmiSocketFactory(SSLFactory.Context.ALWAYS));
    }

    public byte[] read() throws RemoteException {
        try {
            byte[] buffer = new byte[0x100000];
            int len = this.is.read(buffer);
            if (len > 0) {
                byte[] output = new byte[len];
                System.arraycopy(buffer, 0, output, 0, len);
                return output;
            }
            return null;
        }
        catch (IOException ioe) {
            throw new RemoteException("IO Exception reading remote file " + this.url, ioe);
        }
    }

    public void close() throws RemoteException {
        try {
            this.is.close();
            this.is = null;
        }
        catch (IOException ioe) {
            throw new RemoteException("IO Exception closing remote file for " + this.url, ioe);
        }
    }
}

