/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.server.admin;

import edu.stanford.smi.protege.server.RemoteServer;
import edu.stanford.smi.protege.server.RemoteSession;
import edu.stanford.smi.protege.server.admin.AbstractRefreshableServerPanel;
import edu.stanford.smi.protege.server.metaproject.MetaProjectConstants;
import edu.stanford.smi.protege.server.util.RemoteProjectUtil;
import edu.stanford.smi.protege.util.LabeledComponent;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protege.util.ModalDialog;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.rmi.RemoteException;
import java.util.logging.Level;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class ControlServerPanel
extends AbstractRefreshableServerPanel {
    private static final long serialVersionUID = 6214203367190208198L;

    public ControlServerPanel(RemoteServer server, RemoteSession session) {
        super(server, session);
    }

    protected JComponent createCenterComponent() {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        panel.add(Box.createVerticalStrut(10));
        JButton shutdownButton = new JButton(this.getShutdownAction());
        shutdownButton.setText("Shut down the Protege server");
        boolean hasShutdownRight = this.hasShutdownRight();
        shutdownButton.setEnabled(hasShutdownRight);
        if (!hasShutdownRight) {
            shutdownButton.setToolTipText("You do not have permission to shut down the server");
        }
        panel.add(shutdownButton);
        panel.add(Box.createVerticalStrut(20));
        boolean hasSaveRight = this.hasMetaProjectSaveRight();
        JButton saveMetaProjectButton = new JButton(this.getSaveMetaprojectAction());
        saveMetaProjectButton.setText("Save Metaproject");
        saveMetaProjectButton.setEnabled(hasSaveRight);
        if (!hasSaveRight) {
            saveMetaProjectButton.setToolTipText("You do not have permission to save the metaproject");
        }
        panel.add(saveMetaProjectButton);
        LabeledComponent lc = new LabeledComponent("Control server operation", panel, true);
        return lc;
    }

    protected void addRefreshButton() {
    }

    private Action getShutdownAction() {
        return new AbstractAction(){
            private static final long serialVersionUID = 1616026038020695181L;

            public void actionPerformed(ActionEvent arg0) {
                int ret = ModalDialog.showMessageDialog(ControlServerPanel.this, "The Protege server will shut down immediately.\nAll server projects will be saved.\nConnected Protege clients might loose work because of this.\n\nAre you really sure you want to shut down the server?", "Really shutdown?", 13);
                if (ret == 2) {
                    ControlServerPanel.this.shutdownServer();
                }
            }
        };
    }

    private void shutdownServer() {
        try {
            this.getServer().shutdown();
        }
        catch (RemoteException e) {
            Log.getLogger().log(Level.WARNING, "Server shutdown has failed.", e);
            ModalDialog.showMessageDialog(this, "Server shutdown has failed.\nSee console and logs for more information.");
            this.treatPossibleConnectionLostException(e);
            return;
        }
        ModalDialog.showMessageDialog((Component)this, "Server shutdown successful.", "Success");
    }

    private boolean hasShutdownRight() {
        return RemoteProjectUtil.isServerOperationAllowed(this.getServer(), this.getSession(), MetaProjectConstants.OPERATION_ADMINISTER_SERVER) || RemoteProjectUtil.isServerOperationAllowed(this.getServer(), this.getSession(), MetaProjectConstants.OPERATION_SHUTDOWN_SERVER);
    }

    private Action getSaveMetaprojectAction() {
        return new AbstractAction(){
            private static final long serialVersionUID = -3866525559837315333L;

            public void actionPerformed(ActionEvent ev) {
                boolean success = false;
                try {
                    success = ControlServerPanel.this.getServer().saveMetaProject(ControlServerPanel.this.getSession());
                }
                catch (RemoteException e) {
                    Log.getLogger().log(Level.WARNING, "Saving of metaproject has failed.", e);
                    ModalDialog.showMessageDialog(ControlServerPanel.this, "Saving of metaproject has failed.\nSee console and logs for more information.");
                    return;
                }
                ModalDialog.showMessageDialog((Component)ControlServerPanel.this, success ? "Saving of metaproject was successful." : "Saving of metaproject has failed.", success ? "Success" : "Failure");
            }
        };
    }

    private boolean hasMetaProjectSaveRight() {
        return RemoteProjectUtil.isServerOperationAllowed(this.getServer(), this.getSession(), MetaProjectConstants.OPERATION_ADMINISTER_SERVER);
    }
}

