/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.server.admin;

import edu.stanford.smi.protege.resource.Icons;
import edu.stanford.smi.protege.server.RemoteServer;
import edu.stanford.smi.protege.server.RemoteSession;
import edu.stanford.smi.protege.server.ServerProject;
import edu.stanford.smi.protege.server.admin.AbstractRefreshableServerPanel;
import edu.stanford.smi.protege.server.admin.UserInfoTableModel;
import edu.stanford.smi.protege.server.framestore.background.FrameCalculatorStats;
import edu.stanford.smi.protege.server.job.GetFrameCalculatorStatisticsJob;
import edu.stanford.smi.protege.server.job.GetProjectsStatusMapJob;
import edu.stanford.smi.protege.server.job.GetTransactionIsolationLevelJob;
import edu.stanford.smi.protege.server.job.GetUserInfoJob;
import edu.stanford.smi.protege.server.metaproject.MetaProjectConstants;
import edu.stanford.smi.protege.server.util.RemoteProjectUtil;
import edu.stanford.smi.protege.util.AllowableAction;
import edu.stanford.smi.protege.util.ComponentFactory;
import edu.stanford.smi.protege.util.LabeledComponent;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protege.util.ModalDialog;
import edu.stanford.smi.protege.util.Selectable;
import edu.stanford.smi.protege.util.SelectableTable;
import edu.stanford.smi.protege.util.SelectionEvent;
import edu.stanford.smi.protege.util.SelectionListener;
import edu.stanford.smi.protege.util.ViewAction;
import edu.stanford.smi.protege.util.transaction.TransactionIsolationLevel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.logging.Level;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.SpringLayout;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;

public class ProjectsServerPanel
extends AbstractRefreshableServerPanel {
    private static final long serialVersionUID = -3092833104709366831L;
    private DefaultTableModel prjsTableModel;
    private UserInfoTableModel userInfoTableModel;
    private JTextField serverRoundTripField;
    private JTextField transactionIsolationLevelField;
    private JTextField timeToFrameCacheField;
    private LabeledComponent userInfoLC;
    private AllowableAction stopProjectAction;
    private AllowableAction startProjectAction;
    private SelectableTable projectsTable;

    public ProjectsServerPanel(RemoteServer server, RemoteSession session) {
        super(server, session);
    }

    protected JComponent createCenterComponent() {
        this.projectsTable = this.createProjectsTable();
        this.projectsTable.addSelectionListener(new SelectionListener(){

            public void selectionChanged(SelectionEvent event) {
                int row = ProjectsServerPanel.this.projectsTable.getSelectedRow();
                ProjectsServerPanel.this.updateUserInfoPanel(row);
            }
        });
        LabeledComponent projectsLC = new LabeledComponent("Remote projects", new JScrollPane(this.projectsTable), true);
        projectsLC.addHeaderButton(this.getViewAction(this.projectsTable));
        projectsLC.addHeaderButton(this.getStopProjectAction(this.projectsTable));
        projectsLC.addHeaderButton(this.getStartProjectAction(this.projectsTable));
        projectsLC.setPreferredSize(new Dimension(800, 300));
        JComponent userInfoPanel = this.createUserInfoPanel();
        this.userInfoLC = new LabeledComponent("Details (no project selected)", new JScrollPane(userInfoPanel), true);
        this.userInfoLC.setPreferredSize(new Dimension(800, 300));
        JSplitPane sp = ComponentFactory.createTopBottomSplitPane(projectsLC, this.userInfoLC, false);
        sp.setOneTouchExpandable(true);
        return sp;
    }

    private JComponent createUserInfoPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        panel.setPreferredSize(new Dimension(750, 250));
        panel.add(new LabeledComponent("Statistics", this.createNumbersPanel(), true));
        panel.add(new LabeledComponent("Users", new JScrollPane(this.createUserInfoTable()), true));
        return panel;
    }

    private SelectableTable createUserInfoTable() {
        this.userInfoTableModel = new UserInfoTableModel();
        SelectableTable userPrjInfoTable = new SelectableTable();
        userPrjInfoTable.setModel(this.userInfoTableModel);
        return userPrjInfoTable;
    }

    private SelectableTable createProjectsTable() {
        SelectableTable projectsTable = ComponentFactory.createSelectableTable(null);
        projectsTable.setAutoCreateColumnsFromModel(true);
        projectsTable.setModel(this.createProjectsTableModel());
        return projectsTable;
    }

    private TableModel createProjectsTableModel() {
        this.prjsTableModel = new DefaultTableModel();
        this.prjsTableModel.addColumn("Project");
        this.prjsTableModel.addColumn("Status");
        this.prjsTableModel.addColumn("Sessions");
        this.fillProjectsTableModel();
        return this.prjsTableModel;
    }

    private JComponent createNumbersPanel() {
        int col2size = 8;
        JPanel panel = new JPanel(new GridLayout(3, 2, 5, 5));
        panel.add(new JLabel("Estimated round trip time for this admin client (ms):"));
        this.serverRoundTripField = this.createOutputTextField(col2size);
        panel.add(this.serverRoundTripField);
        panel.add(new JLabel("Milliseconds to calculate frame cache:"));
        this.timeToFrameCacheField = this.createOutputTextField(col2size);
        panel.add(this.timeToFrameCacheField);
        panel.add(new JLabel("Transaction Isolation Level:"));
        this.transactionIsolationLevelField = this.createOutputTextField(col2size);
        panel.add(this.transactionIsolationLevelField);
        return panel;
    }

    private JTextField createOutputTextField(int size) {
        JTextField field = new JTextField(size);
        field.setEnabled(false);
        field.setHorizontalAlignment(2);
        return field;
    }

    private void fillProjectsTableModel() {
        this.prjsTableModel.setRowCount(0);
        try {
            Map projectsToStatusMap = (Map)new GetProjectsStatusMapJob(this.getServer(), this.getSession()).execute();
            for (String project : projectsToStatusMap.keySet()) {
                Collection<Object> sessions = new ArrayList();
                try {
                    sessions = this.getServer().getCurrentSessions(project, this.getSession());
                }
                catch (RemoteException e) {
                    Log.getLogger().log(Level.WARNING, "Error at getting the sessions for the remote project " + project, e);
                    this.treatPossibleConnectionLostException(e);
                }
                this.prjsTableModel.addRow(new Object[]{project, projectsToStatusMap.get(project), sessions});
            }
        }
        catch (Exception e) {
            Log.getLogger().log(Level.WARNING, "Error at getting projects status from server.", e);
            this.treatPossibleConnectionLostException(e);
        }
    }

    private void updateUserInfoPanel(int row) {
        if (row < 0) {
            this.userInfoLC.setHeaderLabel("Details (no project selected)");
            this.userInfoTableModel.setUserInfo(null, null);
            return;
        }
        this.serverRoundTripField.setText("(not computed)");
        this.transactionIsolationLevelField.setText("(not computed)");
        this.timeToFrameCacheField.setText("(not computed)");
        String project = this.getProject(row);
        this.userInfoLC.setHeaderLabel("Details on project: " + project);
        Map userInfo = null;
        FrameCalculatorStats stats = null;
        try {
            TransactionIsolationLevel level;
            userInfo = (Map)new GetUserInfoJob(this.getServer(), this.getSession(), project).execute();
            long startTime = System.currentTimeMillis();
            stats = (FrameCalculatorStats)new GetFrameCalculatorStatisticsJob(this.getServer(), this.getSession(), project).execute();
            long interval = System.currentTimeMillis() - startTime;
            this.serverRoundTripField.setText("" + interval);
            if (stats != null) {
                this.timeToFrameCacheField.setText("" + stats.getPrecalculateTime());
            }
            if ((level = (TransactionIsolationLevel)new GetTransactionIsolationLevelJob(this.getServer(), this.getSession(), project).execute()) != null) {
                this.transactionIsolationLevelField.setText("" + level);
            }
        }
        catch (Throwable t) {
            Log.getLogger().log(Level.WARNING, "Failed to get user info from server for project " + project, t);
            this.treatPossibleConnectionLostException(t);
        }
        this.userInfoTableModel.setUserInfo(userInfo, stats);
    }

    private AllowableAction getStopProjectAction(final SelectableTable table) {
        this.stopProjectAction = new AllowableAction("Stop project(s)", Icons.getCancelIcon(), table){
            private static final long serialVersionUID = 4683660482257589346L;

            public void actionPerformed(ActionEvent arg0) {
                int[] rows = table.getSelectedRows();
                ArrayList<String> projects = new ArrayList<String>();
                for (int i = 0; i < rows.length; ++i) {
                    projects.add(ProjectsServerPanel.this.getProject(rows[i]));
                }
                ShutDownPanel shutDownPanel = new ShutDownPanel(projects);
                int opt = ModalDialog.showDialog(ProjectsServerPanel.this, shutDownPanel, "Shut down project(s)", 11);
                if (opt == 1) {
                    int secs = shutDownPanel.getShutdownInSec();
                    for (String project : projects) {
                        this.shutDownProject(project, secs);
                    }
                    ProjectsServerPanel.this.refresh();
                }
            }

            private void shutDownProject(String project, int secs) {
                try {
                    ProjectsServerPanel.this.getServer().shutdownProject(ProjectsServerPanel.this.getSession(), project, secs);
                }
                catch (RemoteException e) {
                    Log.getLogger().log(Level.WARNING, "Could not shut down remote project " + project, e);
                    ModalDialog.showMessageDialog(ProjectsServerPanel.this, "Shutting down the remote project " + project + " failed. \nSee console and log for more details.");
                    ProjectsServerPanel.this.treatPossibleConnectionLostException(e);
                }
            }

            public void onSelectionChange() {
                int[] rows = table.getSelectedRows();
                if (rows == null || rows.length <= 0) {
                    this.setAllowed(false);
                    return;
                }
                for (int i = 0; i < rows.length; ++i) {
                    if (ProjectsServerPanel.this.isStopAllowed(rows[i])) continue;
                    this.setAllowed(false);
                    return;
                }
                this.setAllowed(true);
            }
        };
        return this.stopProjectAction;
    }

    private AllowableAction getStartProjectAction(final SelectableTable table) {
        this.startProjectAction = new AllowableAction("Start project or cancel shut down", Icons.getOkIcon(), table){
            private static final long serialVersionUID = 4714705761432268351L;

            public void actionPerformed(ActionEvent arg0) {
                int row = table.getSelectedRow();
                String project = ProjectsServerPanel.this.getProject(row);
                ServerProject.ProjectStatus status = ProjectsServerPanel.this.getProjectStatus(row);
                if (status.equals(ServerProject.ProjectStatus.CLOSED_FOR_MAINTENANCE)) {
                    this.handleStartProject(project);
                    return;
                }
                if (status.equals(ServerProject.ProjectStatus.SHUTTING_DOWN)) {
                    this.handleCancelShutdown(project);
                    return;
                }
            }

            private void handleStartProject(String project) {
                int start = JOptionPane.showConfirmDialog(ProjectsServerPanel.this, "Start selected project(s)?", "Confirm start projects", 2);
                if (start == 0) {
                    try {
                        ProjectsServerPanel.this.getServer().setProjectStatus(project, ServerProject.ProjectStatus.READY, ProjectsServerPanel.this.getSession());
                    }
                    catch (RemoteException e) {
                        Log.getLogger().log(Level.WARNING, "Could not start remote project " + project, e);
                        ModalDialog.showMessageDialog(ProjectsServerPanel.this, "Could not start remote project " + project + ".\n" + "See console and logs for more information.");
                        ProjectsServerPanel.this.treatPossibleConnectionLostException(e);
                    }
                    ProjectsServerPanel.this.refresh();
                }
            }

            private void handleCancelShutdown(String project) {
                int cancelShutdown = JOptionPane.showConfirmDialog(ProjectsServerPanel.this, "Remote project " + project + " is in the process of shutting down.\n" + "Do you want to cancel the shut down operation?\n" + "Click on OK to cancel the operation.", "Cancel shut down", 2);
                boolean success = false;
                if (cancelShutdown == 0) {
                    try {
                        success = ProjectsServerPanel.this.getServer().cancelShutdownProject(ProjectsServerPanel.this.getSession(), project);
                    }
                    catch (RemoteException e) {
                        Log.getLogger().log(Level.WARNING, "Could not cancel shut down for remote project " + project, e);
                        ProjectsServerPanel.this.treatPossibleConnectionLostException(e);
                    }
                    if (!success) {
                        ModalDialog.showMessageDialog(ProjectsServerPanel.this, "Could not cancel shut down of project " + project);
                    } else {
                        ModalDialog.showMessageDialog(ProjectsServerPanel.this, "Canceling the shut down of project " + project + " was successful.");
                    }
                    ProjectsServerPanel.this.refresh();
                }
            }

            public void onSelectionChange() {
                int[] rows = table.getSelectedRows();
                if (rows == null || rows.length <= 0) {
                    this.setAllowed(false);
                    return;
                }
                for (int i = 0; i < rows.length; ++i) {
                    if (ProjectsServerPanel.this.isStartAllowed(rows[i])) continue;
                    this.setAllowed(false);
                    return;
                }
                this.setAllowed(true);
            }
        };
        return this.startProjectAction;
    }

    private AllowableAction getViewAction(final SelectableTable table) {
        return new ViewAction((Selectable)table){
            private static final long serialVersionUID = 4851439229648071746L;

            public void onView() {
                int row = table.getSelectedRow();
                ComponentFactory.showTableRowInDialog(table.getModel(), row, ProjectsServerPanel.this);
            }
        };
    }

    public void refresh() {
        String selectedProject = this.getSelectedProject();
        try {
            this.fillProjectsTableModel();
            this.prjsTableModel.fireTableDataChanged();
        }
        catch (Throwable t) {
            this.treatPossibleConnectionLostException(t);
        }
        this.setProjectTableSelection(selectedProject);
    }

    private String getSelectedProject() {
        int row = this.projectsTable.getSelectedRow();
        if (row == -1) {
            return null;
        }
        return (String)this.prjsTableModel.getValueAt(row, 0);
    }

    private void setProjectTableSelection(String selectedProject) {
        if (selectedProject == null) {
            return;
        }
        for (int i = 0; i < this.prjsTableModel.getRowCount(); ++i) {
            String prj = (String)this.prjsTableModel.getValueAt(i, 0);
            if (prj == null || !prj.equals(selectedProject)) continue;
            this.projectsTable.getSelectionModel().setSelectionInterval(i, i);
        }
    }

    private ServerProject.ProjectStatus getProjectStatus(int row) {
        return (ServerProject.ProjectStatus)this.prjsTableModel.getValueAt(row, 1);
    }

    private String getProject(int row) {
        return (String)this.prjsTableModel.getValueAt(row, 0);
    }

    private boolean isStopAllowed(int row) {
        return this.getProjectStatus(row).equals(ServerProject.ProjectStatus.READY) && (RemoteProjectUtil.isServerOperationAllowed(this.getServer(), this.getSession(), MetaProjectConstants.OPERATION_ADMINISTER_SERVER) || RemoteProjectUtil.isOperationAllowed(this.getServer(), this.getSession(), this.getProject(row), MetaProjectConstants.OPERATION_STOP_REMOTE_PROJECT));
    }

    private boolean isStartAllowed(int row) {
        return !(!this.getProjectStatus(row).equals(ServerProject.ProjectStatus.CLOSED_FOR_MAINTENANCE) && !this.getProjectStatus(row).equals(ServerProject.ProjectStatus.SHUTTING_DOWN) || !RemoteProjectUtil.isServerOperationAllowed(this.getServer(), this.getSession(), MetaProjectConstants.OPERATION_ADMINISTER_SERVER) && !RemoteProjectUtil.isOperationAllowed(this.getServer(), this.getSession(), this.getProject(row), MetaProjectConstants.OPERATION_START_REMOTE_PROJECT));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ShutDownPanel
    extends JPanel {
        private static final long serialVersionUID = 5895752980483951552L;
        private final JTextField minsTextField = new JTextField(5);

        ShutDownPanel(Collection<String> projects) {
            SpringLayout layout = new SpringLayout();
            this.setLayout(layout);
            JLabel shLabel = new JLabel("Shutdown time (in minutes):");
            layout.putConstraint("West", (Component)shLabel, 5, "West", (Component)this);
            layout.putConstraint("North", (Component)shLabel, 5, "North", (Component)this);
            layout.putConstraint("West", (Component)this.minsTextField, 5, "East", (Component)shLabel);
            layout.putConstraint("North", (Component)this.minsTextField, 3, "North", (Component)this);
            this.minsTextField.setText("10");
            StringBuffer projectsString = new StringBuffer();
            for (String project : projects) {
                projectsString.append(project);
                projectsString.append("<br>");
            }
            JLabel confLabel = new JLabel("<html><b>Are you sure you want to shut down the following project(s)? <br><br>" + projectsString + "</b><br>" + "This will affect all the users connected currently to the listed project(s).</html>");
            layout.putConstraint("West", (Component)confLabel, 5, "West", (Component)this);
            layout.putConstraint("North", (Component)confLabel, 20, "South", (Component)shLabel);
            layout.putConstraint("East", (Component)this, 5, "East", (Component)confLabel);
            layout.putConstraint("South", (Component)this, 5, "South", (Component)confLabel);
            this.add(shLabel);
            this.add(this.minsTextField);
            this.add(confLabel);
        }

        int getShutdownInSec() {
            String str = this.minsTextField.getText().trim();
            return (int)(Float.valueOf(str).floatValue() * 60.0f);
        }
    }
}

