/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.server.admin;

import edu.stanford.smi.protege.resource.Icons;
import edu.stanford.smi.protege.server.RemoteServer;
import edu.stanford.smi.protege.server.RemoteSession;
import edu.stanford.smi.protege.server.Session;
import edu.stanford.smi.protege.server.admin.AbstractRefreshableServerPanel;
import edu.stanford.smi.protege.server.job.GetProjectsForSessionJob;
import edu.stanford.smi.protege.server.job.GetSessionsJob;
import edu.stanford.smi.protege.server.metaproject.MetaProjectConstants;
import edu.stanford.smi.protege.server.util.RemoteProjectUtil;
import edu.stanford.smi.protege.util.AllowableAction;
import edu.stanford.smi.protege.util.ComponentFactory;
import edu.stanford.smi.protege.util.LabeledComponent;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protege.util.ModalDialog;
import edu.stanford.smi.protege.util.Selectable;
import edu.stanford.smi.protege.util.SelectableTable;
import edu.stanford.smi.protege.util.ViewAction;
import java.awt.event.ActionEvent;
import java.rmi.RemoteException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;

public class SessionServerPanel
extends AbstractRefreshableServerPanel {
    private static final long serialVersionUID = 8567269732489128636L;
    private static final String UNKNOWN_ENTRY = "(unknown)";
    private static final String NO_PROJECT = "(none)";
    private static SimpleDateFormat dateFormat = new SimpleDateFormat("HH:mm:ss, yyyy.MM.dd");
    private DefaultTableModel tableModel;
    private List<RemoteSession> remoteSessions;
    private AllowableAction killSessionAction;

    public SessionServerPanel(RemoteServer server, RemoteSession session) {
        super(server, session);
    }

    protected JComponent createCenterComponent() {
        this.remoteSessions = new ArrayList<RemoteSession>();
        SelectableTable sessionsTable = ComponentFactory.createSelectableTable(null);
        sessionsTable.setAutoCreateColumnsFromModel(true);
        sessionsTable.setModel(this.createTableModel());
        LabeledComponent lc = new LabeledComponent("Live sessions", new JScrollPane(sessionsTable), true);
        lc.addHeaderButton(this.getViewAction(sessionsTable));
        lc.addHeaderButton(this.getKillSessionAction(sessionsTable));
        return lc;
    }

    private TableModel createTableModel() {
        this.tableModel = new DefaultTableModel();
        this.tableModel.addColumn("Id");
        this.tableModel.addColumn("User name");
        this.tableModel.addColumn("User IP");
        this.tableModel.addColumn("Project");
        this.tableModel.addColumn("Login time");
        this.fillTableModel();
        return this.tableModel;
    }

    private void fillTableModel() {
        this.tableModel.setRowCount(0);
        this.remoteSessions.clear();
        RemoteSession mySession = this.getSession();
        try {
            Collection sessions = (Collection)new GetSessionsJob(this.getServer(), mySession).execute();
            for (RemoteSession session : sessions) {
                this.remoteSessions.add(session);
                ArrayList<String> prjs = (ArrayList<String>)new GetProjectsForSessionJob(this.getServer(), mySession, session).execute();
                if (prjs.size() == 0) {
                    prjs = new ArrayList<String>();
                    prjs.add(NO_PROJECT);
                }
                String loginTime = UNKNOWN_ENTRY;
                String sessionId = UNKNOWN_ENTRY;
                if (session instanceof Session) {
                    Date date = new Date(((Session)session).getStartTime());
                    loginTime = dateFormat.format(date);
                    sessionId = Integer.toString(((Session)session).getId());
                    if (session.equals(mySession)) {
                        sessionId = "*" + sessionId;
                    }
                }
                this.tableModel.addRow(new Object[]{sessionId, session.getUserName(), session.getUserIpAddress(), prjs, loginTime});
            }
        }
        catch (Exception e) {
            Log.getLogger().log(Level.WARNING, "Could not get remote sessions from server.", e);
            this.treatPossibleConnectionLostException(e);
        }
    }

    private AllowableAction getKillSessionAction(final SelectableTable table) {
        this.killSessionAction = new AllowableAction("Kill session(s)", Icons.getCancelIcon(), table){
            private static final long serialVersionUID = -845012769836420622L;

            public void actionPerformed(ActionEvent arg0) {
                int kill = JOptionPane.showConfirmDialog(SessionServerPanel.this, "Kill selected session(s)?\nUsers may lose work as a result of this action.", "Confirm Kill Sessions", 2);
                if (kill == 0) {
                    int[] rows = table.getSelectedRows();
                    for (int i = 0; i < rows.length; ++i) {
                        RemoteSession session = (RemoteSession)SessionServerPanel.this.remoteSessions.get(rows[i]);
                        try {
                            SessionServerPanel.this.getServer().killOtherUserSession(session, SessionServerPanel.this.getSession(), 10);
                            continue;
                        }
                        catch (RemoteException e) {
                            Log.getLogger().log(Level.WARNING, "Could not kill session " + session, e);
                            ModalDialog.showMessageDialog(SessionServerPanel.this, "Could not kill session " + session + ".\n" + "See console and logs for more information.");
                            SessionServerPanel.this.treatPossibleConnectionLostException(e);
                        }
                    }
                    SessionServerPanel.this.refresh();
                }
            }

            public void onSelectionChange() {
                int[] rows = table.getSelectedRows();
                if (rows == null || rows.length <= 0) {
                    this.setAllowed(false);
                    return;
                }
                for (int i = 0; i < rows.length; ++i) {
                    RemoteSession session = (RemoteSession)SessionServerPanel.this.remoteSessions.get(rows[i]);
                    if (SessionServerPanel.this.isKillAllowed(session)) continue;
                    this.setAllowed(false);
                    return;
                }
                this.setAllowed(true);
            }
        };
        return this.killSessionAction;
    }

    private AllowableAction getViewAction(final SelectableTable table) {
        return new ViewAction((Selectable)table){
            private static final long serialVersionUID = -2389054693945285483L;

            public void onView() {
                int row = table.getSelectedRow();
                ComponentFactory.showTableRowInDialog(table.getModel(), row, SessionServerPanel.this);
            }
        };
    }

    public void refresh() {
        try {
            this.fillTableModel();
            this.tableModel.fireTableDataChanged();
        }
        catch (Throwable t) {
            this.treatPossibleConnectionLostException(t);
        }
    }

    private boolean isKillAllowed(RemoteSession session) {
        if (session.equals(this.getSession())) {
            return false;
        }
        int row = this.remoteSessions.indexOf(session);
        if (row < 0) {
            return false;
        }
        if (RemoteProjectUtil.isServerOperationAllowed(this.getServer(), this.getSession(), MetaProjectConstants.OPERATION_ADMINISTER_SERVER)) {
            return true;
        }
        if (!RemoteProjectUtil.isServerOperationAllowed(this.getServer(), this.getSession(), MetaProjectConstants.OPERATION_KILL_OTHER_USER_SESSION)) {
            return false;
        }
        Collection prjsInSession = (Collection)this.tableModel.getValueAt(row, 3);
        for (String project : prjsInSession) {
            if (project.equals(NO_PROJECT) || RemoteProjectUtil.isOperationAllowed(this.getServer(), this.getSession(), project, MetaProjectConstants.OPERATION_KILL_OTHER_USER_SESSION)) continue;
            return false;
        }
        return true;
    }
}

