/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.server.admin;

import edu.stanford.smi.protege.server.RemoteSession;
import edu.stanford.smi.protege.server.Session;
import edu.stanford.smi.protege.server.framestore.background.FrameCalculatorStats;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.table.AbstractTableModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UserInfoTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = 7730063885739903457L;
    Map<RemoteSession, Boolean> userInfo = new HashMap<RemoteSession, Boolean>();
    FrameCalculatorStats stats = null;
    List<RemoteSession> sessions = new ArrayList<RemoteSession>();

    public void setUserInfo(Map<RemoteSession, Boolean> userInfo, FrameCalculatorStats stats) {
        this.userInfo = userInfo;
        this.stats = stats;
        this.sessions = new ArrayList<RemoteSession>();
        if (userInfo != null && stats != null) {
            for (RemoteSession session : userInfo.keySet()) {
                this.sessions.add(session);
            }
        }
        this.fireTableDataChanged();
    }

    @Override
    public int getRowCount() {
        return this.userInfo == null ? 0 : this.userInfo.size();
    }

    @Override
    public int getColumnCount() {
        return Column.values().length;
    }

    @Override
    public Object getValueAt(int rowIndex, int colIndex) {
        Column col = Column.values()[colIndex];
        switch (col) {
            case sessionId: {
                RemoteSession remoteSession = this.sessions.get(rowIndex);
                if (remoteSession instanceof Session) {
                    return ((Session)remoteSession).getId();
                }
                return "(none)";
            }
            case user: {
                return this.sessions.get(rowIndex).getUserName();
            }
            case ipAddr: {
                return this.sessions.get(rowIndex).getUserIpAddress();
            }
            case transaction: {
                return this.userInfo.get(this.sessions.get(rowIndex));
            }
            case backlog: {
                if (this.stats == null) {
                    return new Integer(-1);
                }
                RemoteSession session = this.sessions.get(rowIndex);
                Integer result = this.stats.getPreCacheBacklog().get(session);
                if (result == null) {
                    return 0;
                }
                return new Integer(result);
            }
        }
        throw new UnsupportedOperationException("Programmer Error");
    }

    public RemoteSession getSession(int row) {
        return this.sessions.get(row);
    }

    @Override
    public String getColumnName(int colIndex) {
        Column col = Column.values()[colIndex];
        return col.getColumnName();
    }

    public Class getColumnClass(int colIndex) {
        Column col = Column.values()[colIndex];
        switch (col) {
            case sessionId: 
            case user: 
            case ipAddr: {
                return String.class;
            }
            case transaction: {
                return Boolean.class;
            }
            case backlog: {
                return Integer.class;
            }
        }
        throw new UnsupportedOperationException("Programmer Error");
    }

    public RemoteSession getRemoteSession(int row) {
        return this.sessions.get(row);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Column {
        sessionId("Session ID"),
        user("User"),
        ipAddr("IP Adress"),
        transaction("In Transaction?"),
        backlog("Server Backlog");

        private String name;

        private Column(String name) {
            this.name = name;
        }

        public String getColumnName() {
            return this.name;
        }
    }
}

