/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.server.framestore;

import edu.stanford.smi.protege.util.ApplicationProperties;
import edu.stanford.smi.protege.util.Log;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class BandWidthPolicy {
    private static transient Logger log = Log.getLogger(BandWidthPolicy.class);
    public static final String BANDWIDTH_CAP_PROPERTY = "edu.stanford.smi.protege.server.max_value_update_rate";
    private long samplingInterval = 1000L;
    private int surgeCap;
    private int bandwidthCap;
    private int itemsWaitingToSend = 0;
    private List<SentItems> itemsSent = new ArrayList<SentItems>();

    public BandWidthPolicy() {
        this(BandWidthPolicy.getCap(), BandWidthPolicy.getCap());
    }

    public BandWidthPolicy(int surgeCap, int bandwidthCap) {
        this.surgeCap = surgeCap;
        this.bandwidthCap = bandwidthCap;
    }

    public static int getCap() {
        return ApplicationProperties.getIntegerProperty(BANDWIDTH_CAP_PROPERTY, 7000);
    }

    public synchronized void addItemToWaitList() {
        ++this.itemsWaitingToSend;
    }

    public synchronized void addItemsSent(int sent) {
        this.itemsSent.add(new SentItems(sent));
        this.itemsWaitingToSend = 0;
    }

    public synchronized boolean stopSending() {
        if (this.itemsWaitingToSend > this.surgeCap) {
            if (log.isLoggable(Level.FINE)) {
                log.fine("throttling back because we already have " + this.itemsWaitingToSend + " items to send.");
            }
            return true;
        }
        long now = System.currentTimeMillis();
        ArrayList<SentItems> sentItemsToForget = new ArrayList<SentItems>();
        int itemsSentInInterval = this.itemsWaitingToSend;
        for (SentItems si : this.itemsSent) {
            if (si.whenInMillis < now - this.samplingInterval) {
                sentItemsToForget.add(si);
                continue;
            }
            itemsSentInInterval += si.count;
        }
        this.itemsSent.removeAll(sentItemsToForget);
        if (log.isLoggable(Level.FINE) && itemsSentInInterval > this.bandwidthCap) {
            log.fine("Throttling back because we have " + this.itemsWaitingToSend + " items to send and we have recently sent the follwing");
            for (SentItems si : this.itemsSent) {
                log.fine("\t" + si.count + " items");
            }
        }
        return itemsSentInInterval > this.bandwidthCap;
    }

    private static class SentItems {
        long whenInMillis;
        int count;

        public SentItems(int count) {
            this.count = count;
            this.whenInMillis = System.currentTimeMillis();
        }
    }
}

