/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.server.framestore;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Facet;
import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.model.FrameID;
import edu.stanford.smi.protege.model.Model;
import edu.stanford.smi.protege.model.SimpleInstance;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.model.framestore.FrameStoreAdapter;
import edu.stanford.smi.protege.server.RemoteSession;
import edu.stanford.smi.protege.server.framestore.ServerFrameStore;
import edu.stanford.smi.protege.server.framestore.background.CacheRequestReason;
import edu.stanford.smi.protege.server.framestore.background.FrameCalculator;
import java.util.Collection;
import java.util.List;

public class FrameCalculatorFrameStore
extends FrameStoreAdapter {
    private FrameCalculator frameCalculator;

    public FrameCalculatorFrameStore(FrameCalculator frameCalculator) {
        this.frameCalculator = frameCalculator;
    }

    public FrameCalculator getFrameCalculator() {
        return this.frameCalculator;
    }

    public List getDirectTemplateSlotValues(Cls cls, Slot slot) {
        RemoteSession session = ServerFrameStore.getCurrentSession();
        this.frameCalculator.addRequest(cls, session, CacheRequestReason.USER_REQUESTED_FRAME_VALUES);
        return this.getDelegate().getDirectTemplateSlotValues(cls, slot);
    }

    public List getDirectTemplateFacetValues(Cls cls, Slot slot, Facet facet) {
        RemoteSession session = ServerFrameStore.getCurrentSession();
        this.frameCalculator.addRequest(cls, session, CacheRequestReason.USER_REQUESTED_FRAME_VALUES);
        return this.getDelegate().getDirectTemplateFacetValues(cls, slot, facet);
    }

    public Frame getFrame(String name) {
        Frame frame = this.getDelegate().getFrame(name);
        RemoteSession session = ServerFrameStore.getCurrentSession();
        if (frame != null) {
            this.frameCalculator.addRequest(frame, session, CacheRequestReason.USER_NAME_REQUEST);
        }
        return frame;
    }

    public int getDirectOwnSlotValuesCount(Frame frame, Slot slot) {
        RemoteSession session = ServerFrameStore.getCurrentSession();
        if (slot.getFrameID().equals(Model.SlotID.DIRECT_INSTANCES)) {
            this.frameCalculator.addRequest(frame, session, CacheRequestReason.USER_REQUESTED_FRAME_VALUES);
        }
        return this.getDelegate().getDirectOwnSlotValuesCount(frame, slot);
    }

    public List getDirectOwnSlotValues(Frame frame, Slot slot) {
        List values;
        block2: {
            RemoteSession session;
            block3: {
                values = this.getDelegate().getDirectOwnSlotValues(frame, slot);
                session = ServerFrameStore.getCurrentSession();
                if (this.frameCalculator.isDisabled(session)) break block2;
                this.frameCalculator.addRequest(frame, session, CacheRequestReason.USER_REQUESTED_FRAME_VALUES);
                if (!slot.getFrameID().equals(Model.SlotID.DIRECT_SUBCLASSES)) break block3;
                for (Object o : values) {
                    if (!(o instanceof Frame)) continue;
                    this.frameCalculator.addRequest((Frame)o, session, CacheRequestReason.SUBCLASS);
                }
                break block2;
            }
            if (!slot.getFrameID().equals(Model.SlotID.DIRECT_INSTANCES)) break block2;
            for (Object o : values) {
                if (!(o instanceof Frame)) continue;
                this.frameCalculator.addRequest((Frame)o, session, CacheRequestReason.DIRECT_INSTANCES);
            }
        }
        return values;
    }

    public Facet createFacet(FrameID id, Collection directTypes, boolean loadDefaults) {
        Facet facet = this.getDelegate().createFacet(id, directTypes, loadDefaults);
        RemoteSession session = ServerFrameStore.getCurrentSession();
        this.frameCalculator.addRequest(facet, session, CacheRequestReason.NEW_FRAME);
        return facet;
    }

    public Slot createSlot(FrameID id, Collection directTypes, Collection directSuperslots, boolean loadDefaults) {
        Slot slot = this.getDelegate().createSlot(id, directTypes, directSuperslots, loadDefaults);
        RemoteSession session = ServerFrameStore.getCurrentSession();
        this.frameCalculator.addRequest(slot, session, CacheRequestReason.NEW_FRAME);
        return slot;
    }

    public Cls createCls(FrameID id, Collection directTypes, Collection directSuperclasses, boolean loadDefaults) {
        Cls cls = this.getDelegate().createCls(id, directTypes, directSuperclasses, loadDefaults);
        RemoteSession session = ServerFrameStore.getCurrentSession();
        this.frameCalculator.addRequest(cls, session, CacheRequestReason.NEW_FRAME);
        return cls;
    }

    public SimpleInstance createSimpleInstance(FrameID id, Collection directTypes, boolean loadDefaults) {
        SimpleInstance si = this.getDelegate().createSimpleInstance(id, directTypes, loadDefaults);
        RemoteSession session = ServerFrameStore.getCurrentSession();
        this.frameCalculator.addRequest(si, session, CacheRequestReason.NEW_FRAME);
        return si;
    }
}

