/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.server.framestore;

import edu.stanford.smi.protege.exception.OntologyException;
import edu.stanford.smi.protege.exception.ProtegeError;
import edu.stanford.smi.protege.exception.ProtegeIOException;
import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.model.framestore.AbstractFrameStoreInvocationHandler;
import edu.stanford.smi.protege.model.query.Query;
import edu.stanford.smi.protege.model.query.QueryCallback;
import edu.stanford.smi.protege.server.RemoteSession;
import edu.stanford.smi.protege.server.ServerProperties;
import edu.stanford.smi.protege.server.framestore.ServerFrameStore;
import edu.stanford.smi.protege.server.framestore.background.FrameCalculator;
import edu.stanford.smi.protege.server.metaproject.MetaProject;
import edu.stanford.smi.protege.server.metaproject.ProjectInstance;
import edu.stanford.smi.protege.server.metaproject.User;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;

public class LastUsageInvocationHandler
extends AbstractFrameStoreInvocationHandler {
    private final MetaProject metaproject;
    private final Map<String, Date> lastAccessTimeMap = new HashMap<String, Date>();
    private final ScheduledExecutorService executor = Executors.newScheduledThreadPool(1, new ThreadFactory(){

        public Thread newThread(Runnable r) {
            Thread th = new Thread(r, "Update MetaProject Thread");
            th.setDaemon(true);
            return th;
        }
    });
    private FrameCalculator frameCalculator;

    public LastUsageInvocationHandler(ProjectInstance projectInstance, FrameCalculator frameCalculator) {
        this.frameCalculator = frameCalculator;
        this.metaproject = projectInstance.getMetaProject();
        long updateFrequency = ServerProperties.getMetaProjectLastAccessTimeUpdateFrequency();
        this.executor.scheduleWithFixedDelay(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                HashMap lastAccessTimeUpdates;
                Map map = LastUsageInvocationHandler.this.lastAccessTimeMap;
                synchronized (map) {
                    lastAccessTimeUpdates = new HashMap(LastUsageInvocationHandler.this.lastAccessTimeMap);
                    LastUsageInvocationHandler.this.lastAccessTimeMap.clear();
                }
                for (Map.Entry entry : lastAccessTimeUpdates.entrySet()) {
                    String userName = (String)entry.getKey();
                    Date date = (Date)entry.getValue();
                    User u = LastUsageInvocationHandler.this.metaproject.getUser(userName);
                    u.setLastAccess(date);
                }
            }
        }, updateFrequency, updateFrequency, TimeUnit.MILLISECONDS);
    }

    protected void executeQuery(Query q, final QueryCallback qc) {
        this.updateLastAccessTime();
        QueryCallback outerCallback = new QueryCallback(){

            @Override
            public void provideQueryResults(Collection<Frame> results) {
                LastUsageInvocationHandler.this.updateLastAccessTime();
                qc.provideQueryResults(results);
            }

            @Override
            public void handleError(ProtegeError error) {
                LastUsageInvocationHandler.this.updateLastAccessTime();
                qc.handleError(error);
            }

            @Override
            public void handleError(ProtegeIOException exception) {
                LastUsageInvocationHandler.this.updateLastAccessTime();
                qc.handleError(exception);
            }

            @Override
            public void handleError(OntologyException exception) {
                LastUsageInvocationHandler.this.updateLastAccessTime();
                qc.handleError(exception);
            }
        };
        this.getDelegate().executeQuery(q, outerCallback);
    }

    protected Object handleInvoke(Method method, Object[] args) {
        if (!method.getName().equals("getEvents")) {
            this.updateLastAccessTime();
        }
        return this.invoke(method, args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateLastAccessTime() {
        if (this.frameCalculator != null && this.frameCalculator.inFrameCalculatorThread()) {
            return;
        }
        RemoteSession session = ServerFrameStore.getCurrentSession();
        if (session == null) {
            return;
        }
        Date now = new Date();
        String userName = session.getUserName();
        Map<String, Date> map = this.lastAccessTimeMap;
        synchronized (map) {
            this.lastAccessTimeMap.put(userName, now);
        }
    }
}

