/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.server.framestore;

import edu.stanford.smi.protege.exception.OntologyException;
import edu.stanford.smi.protege.exception.ProtegeError;
import edu.stanford.smi.protege.exception.ProtegeException;
import edu.stanford.smi.protege.exception.ProtegeIOException;
import edu.stanford.smi.protege.exception.TransactionException;
import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.DefaultKnowledgeBase;
import edu.stanford.smi.protege.model.Facet;
import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.model.FrameID;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.Reference;
import edu.stanford.smi.protege.model.SimpleInstance;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.model.SystemFrames;
import edu.stanford.smi.protege.model.framestore.FrameStore;
import edu.stanford.smi.protege.model.framestore.FrameStoreManager;
import edu.stanford.smi.protege.model.framestore.Sft;
import edu.stanford.smi.protege.model.query.Query;
import edu.stanford.smi.protege.model.query.QueryCallback;
import edu.stanford.smi.protege.server.RemoteServer;
import edu.stanford.smi.protege.server.RemoteServerProject;
import edu.stanford.smi.protege.server.RemoteSession;
import edu.stanford.smi.protege.server.Server;
import edu.stanford.smi.protege.server.ServerProperties;
import edu.stanford.smi.protege.server.framestore.RemoteClientStats;
import edu.stanford.smi.protege.server.framestore.RemoteServerFrameStore;
import edu.stanford.smi.protege.server.framestore.ServerFrameStore;
import edu.stanford.smi.protege.server.framestore.ServerSessionLost;
import edu.stanford.smi.protege.server.framestore.background.FrameCalculatorStats;
import edu.stanford.smi.protege.server.metaproject.Operation;
import edu.stanford.smi.protege.server.socket.SimulateDelayAspect;
import edu.stanford.smi.protege.server.update.DeferredOperationCache;
import edu.stanford.smi.protege.server.update.OntologyUpdate;
import edu.stanford.smi.protege.server.update.RemoteResponse;
import edu.stanford.smi.protege.server.update.ValueUpdate;
import edu.stanford.smi.protege.server.util.FifoReader;
import edu.stanford.smi.protege.server.util.FifoWriter;
import edu.stanford.smi.protege.util.AbstractEvent;
import edu.stanford.smi.protege.util.CollectionUtilities;
import edu.stanford.smi.protege.util.LocalizeUtils;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protege.util.ProtegeJob;
import edu.stanford.smi.protege.util.SystemUtilities;
import edu.stanford.smi.protege.util.transaction.TransactionIsolationLevel;
import edu.stanford.smi.protege.util.transaction.TransactionMonitor;
import edu.stanford.smi.protege.util.transaction.cache.Cache;
import edu.stanford.smi.protege.util.transaction.cache.CacheFactory;
import edu.stanford.smi.protege.util.transaction.cache.CacheResult;
import edu.stanford.smi.protege.util.transaction.cache.serialize.CacheBeginTransaction;
import edu.stanford.smi.protege.util.transaction.cache.serialize.CacheCommitTransaction;
import edu.stanford.smi.protege.util.transaction.cache.serialize.CacheDelete;
import edu.stanford.smi.protege.util.transaction.cache.serialize.CacheModify;
import edu.stanford.smi.protege.util.transaction.cache.serialize.CacheRollbackTransaction;
import edu.stanford.smi.protege.util.transaction.cache.serialize.SerializedCacheUpdate;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.rmi.Naming;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoteClientFrameStore
implements FrameStore {
    private static transient Logger log = Log.getLogger(RemoteClientFrameStore.class);
    private static transient Logger cacheLog = ServerFrameStore.cacheLog;
    private static Method executeProtegeJobMethod;
    private KnowledgeBase kb;
    private ClassLoader kbClassLoader;
    private SystemFrames systemFrames;
    private RemoteSession session;
    private RemoteServer server;
    private RemoteServerFrameStore proxiedDelegate;
    private RemoteServerFrameStore remoteDelegate;
    private final FifoWriter<SerializedCacheUpdate<RemoteSession, Sft, List>> deferredTransactionsWriter = new FifoWriter();
    private final Map<Frame, DeferredOperationCache> cacheMap = new HashMap<Frame, DeferredOperationCache>();
    private TransactionIsolationLevel transactionLevel;
    private int transactionNesting = 0;
    private final Map<String, Frame> frameNameToFrameMap = new HashMap<String, Frame>();
    private final RemoteClientStatsImpl stats = new RemoteClientStatsImpl();
    private Set<Operation> allowedOps;
    private Set<Operation> knownOps;

    public RemoteClientFrameStore(String host, String user, String password, String projectName, KnowledgeBase kb, boolean preloadAll) {
        try {
            this.server = (RemoteServer)Naming.lookup("//" + host + "/" + Server.getBoundName());
            String ipAddress = SystemUtilities.getMachineIpAddress();
            this.session = this.server.openSession(user, ipAddress, password);
            RemoteServerProject project = this.server.openProject(projectName, this.session);
            this.remoteDelegate = project.getDomainKbFrameStore(this.session);
            this.kb = kb;
            this.initialize(preloadAll);
        }
        catch (Exception e) {
            Log.getLogger().severe(Log.toString(e));
            log.log(Level.FINE, "Exception caught", e);
        }
    }

    public RemoteClientFrameStore(RemoteServer server, RemoteServerFrameStore delegate, RemoteSession session, KnowledgeBase kb, boolean preloadAll) {
        try {
            this.server = server;
            this.session = session;
            this.kb = kb;
            this.remoteDelegate = delegate;
            this.initialize(preloadAll);
        }
        catch (Exception e) {
            Log.getLogger().severe(Log.toString(e));
            log.log(Level.FINE, "Exception caught", e);
        }
    }

    public void initialize(boolean preloadAll) throws RemoteException {
        this.systemFrames = this.kb.getSystemFrames();
        this.kbClassLoader = this.kb.getClass().getClassLoader();
        this.startHeartbeatThread();
        this.preload(preloadAll);
    }

    private static RemoteClientFrameStore getMeFromKb(KnowledgeBase kb) {
        if (!(kb instanceof DefaultKnowledgeBase)) {
            return null;
        }
        DefaultKnowledgeBase dkb = (DefaultKnowledgeBase)kb;
        for (FrameStore fs = dkb.getHeadFrameStore(); fs != null; fs = fs.getDelegate()) {
            if (!(fs instanceof RemoteClientFrameStore)) continue;
            return (RemoteClientFrameStore)fs;
        }
        return null;
    }

    public static boolean isCached(Frame frame, Slot slot, Facet facet, boolean isTemplate) {
        RemoteClientFrameStore rcfs = RemoteClientFrameStore.getMeFromKb(frame.getKnowledgeBase());
        if (rcfs == null) {
            return true;
        }
        return rcfs.isCachedInternal(frame, slot, facet, isTemplate);
    }

    public static boolean isCacheComplete(Frame frame) {
        RemoteClientFrameStore rcfs = RemoteClientFrameStore.getMeFromKb(frame.getKnowledgeBase());
        if (rcfs == null) {
            return true;
        }
        Cache cache = rcfs.cacheMap.get(frame);
        if (cache == null) {
            return false;
        }
        return cache.isCacheComplete();
    }

    public static RemoteSession getCurrentSession(KnowledgeBase kb) {
        FrameStoreManager framestore_manager = ((DefaultKnowledgeBase)kb).getFrameStoreManager();
        RemoteClientFrameStore remote_frame_store = framestore_manager.getFrameStoreFromClass(RemoteClientFrameStore.class);
        if (remote_frame_store == null) {
            return null;
        }
        return remote_frame_store.getSession();
    }

    private void startHeartbeatThread() {
        if (ServerProperties.heartbeatDisabled()) {
            return;
        }
        new Thread("Heartbeat thread [" + this.kb + "]"){

            public void run() {
                try {
                    while (true) {
                        RemoteServerFrameStore remote;
                        if ((remote = RemoteClientFrameStore.this.getRemoteDelegate()) != null) {
                            remote.heartBeat(RemoteClientFrameStore.this.session);
                        }
                        Thread.sleep(3000L);
                    }
                }
                catch (ServerSessionLost ssl) {
                    Log.emptyCatchBlock(ssl);
                }
                catch (Exception e) {
                    Log.getLogger().log(Level.SEVERE, "Heartbeat thread died - can't survive the heart for long...", e);
                }
            }
        }.start();
    }

    @Override
    public String getName() {
        return this.getClass().getName();
    }

    public synchronized RemoteServerFrameStore getRemoteDelegate() {
        if (this.proxiedDelegate == null) {
            this.fixLoader();
            InvocationHandler invoker = new InvocationHandler(){

                public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                    RemoteClientFrameStore remoteClientFrameStore = RemoteClientFrameStore.this;
                    synchronized (remoteClientFrameStore) {
                        if (!method.equals(executeProtegeJobMethod)) {
                            RemoteClientFrameStore.this.fixLoader();
                        } else {
                            ((ProtegeJob)args[0]).fixLoader();
                        }
                        try {
                            if (log.isLoggable(Level.FINE)) {
                                log.fine("Remote invoke: " + method.getName() + " Args:");
                                if (args != null) {
                                    for (Object obj : args) {
                                        log.fine("\t" + (obj instanceof Frame ? ((Frame)obj).getFrameID() : obj));
                                    }
                                }
                            }
                            long start = System.currentTimeMillis();
                            SimulateDelayAspect.delayForLatency();
                            Object val = method.invoke((Object)RemoteClientFrameStore.this.remoteDelegate, args);
                            LocalizeUtils.localize(val, RemoteClientFrameStore.this.kb);
                            if (log.isLoggable(Level.FINE)) {
                                log.fine("Invocation took " + (System.currentTimeMillis() - start) + " ms");
                                RemoteClientFrameStore.this.logSize(log, Level.FINEST, val);
                            }
                            return val;
                        }
                        catch (InvocationTargetException ite) {
                            throw ite.getCause();
                        }
                    }
                }
            };
            this.proxiedDelegate = (RemoteServerFrameStore)Proxy.newProxyInstance(this.kbClassLoader, new Class[]{RemoteServerFrameStore.class}, invoker);
        }
        return this.proxiedDelegate;
    }

    private void logSize(Logger log, Level level, Object o) {
        if (o instanceof OntologyUpdate) {
            OntologyUpdate response = (OntologyUpdate)o;
            int valueUpdateSize = 0;
            int valueUpdateCount = 0;
            for (ValueUpdate vu : response.getValueUpdates()) {
                valueUpdateSize += RemoteClientFrameStore.getSerializedSize(vu);
                ++valueUpdateCount;
            }
            log.log(level, "" + valueUpdateSize + " bytes of " + valueUpdateCount + " value updates");
            if (response instanceof RemoteResponse) {
                log.log(level, "" + RemoteClientFrameStore.getSerializedSize(((RemoteResponse)response).getResponse()) + " bytes of included object");
            }
        } else {
            log.log(level, "" + RemoteClientFrameStore.getSerializedSize(o) + " bytes for object of type " + o.getClass());
        }
    }

    public static int getSerializedSize(Object o) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(o);
            oos.close();
            return baos.size();
        }
        catch (IOException ioe) {
            if (log.isLoggable(Level.FINE)) {
                log.fine("trouble calculating size");
            }
            return 0;
        }
    }

    public Map<RemoteSession, Boolean> getUserInfo() {
        try {
            return this.getRemoteDelegate().getUserInfo();
        }
        catch (RemoteException re) {
            Log.getLogger().log(Level.WARNING, "Exception caught retrieving user data from remote server", re);
            return new HashMap<RemoteSession, Boolean>();
        }
    }

    public FrameCalculatorStats getServerStats() {
        try {
            return this.getRemoteDelegate().getStats();
        }
        catch (RemoteException re) {
            Log.getLogger().log(Level.INFO, "Remote exception getting server stats", re);
            return null;
        }
    }

    public synchronized RemoteClientStats getClientStats() {
        return this.stats;
    }

    private void fixLoader() {
        ClassLoader correctLoader;
        ClassLoader currentLoader = Thread.currentThread().getContextClassLoader();
        if (currentLoader != (correctLoader = this.kbClassLoader)) {
            if (log.isLoggable(Level.FINEST)) {
                log.finest("Changing loader from " + currentLoader + " to " + correctLoader);
            }
            Thread.currentThread().setContextClassLoader(correctLoader);
        }
    }

    @Override
    public void setDelegate(FrameStore delegate) {
        throw new UnsupportedOperationException();
    }

    @Override
    public FrameStore getDelegate() {
        return null;
    }

    @Override
    public void reinitialize() {
        this.flushCache();
    }

    private static RuntimeException convertException(Exception e) {
        return new RuntimeException(e);
    }

    @Override
    public int getClsCount() {
        try {
            return this.getRemoteDelegate().getClsCount(this.session);
        }
        catch (RemoteException e) {
            throw RemoteClientFrameStore.convertException(e);
        }
    }

    @Override
    public int getSlotCount() {
        try {
            return this.getRemoteDelegate().getSlotCount(this.session);
        }
        catch (RemoteException e) {
            throw RemoteClientFrameStore.convertException(e);
        }
    }

    @Override
    public int getFacetCount() {
        try {
            return this.getRemoteDelegate().getFacetCount(this.session);
        }
        catch (RemoteException e) {
            throw RemoteClientFrameStore.convertException(e);
        }
    }

    @Override
    public int getSimpleInstanceCount() {
        try {
            return this.getRemoteDelegate().getSimpleInstanceCount(this.session);
        }
        catch (RemoteException e) {
            throw RemoteClientFrameStore.convertException(e);
        }
    }

    @Override
    public int getFrameCount() {
        try {
            return this.getRemoteDelegate().getFrameCount(this.session);
        }
        catch (RemoteException e) {
            throw RemoteClientFrameStore.convertException(e);
        }
    }

    @Override
    public Set<Cls> getClses() {
        try {
            Set<Cls> clses = this.getRemoteDelegate().getClses(this.session);
            return clses;
        }
        catch (RemoteException e) {
            throw RemoteClientFrameStore.convertException(e);
        }
    }

    @Override
    public Set<Slot> getSlots() {
        Cls rootSlotClass = this.getSystemFrames().getRootSlotMetaCls();
        return this.getInstances(rootSlotClass);
    }

    @Override
    public Set<Facet> getFacets() {
        try {
            Set<Facet> facets = this.getRemoteDelegate().getFacets(this.session);
            return facets;
        }
        catch (RemoteException e) {
            throw RemoteClientFrameStore.convertException(e);
        }
    }

    @Override
    public Set<Frame> getFrames() {
        try {
            Set<Frame> frames = this.getRemoteDelegate().getFrames(this.session);
            return frames;
        }
        catch (RemoteException e) {
            throw RemoteClientFrameStore.convertException(e);
        }
    }

    @Override
    public Frame getFrame(FrameID id) {
        try {
            Frame frame = this.getRemoteDelegate().getFrame(id, this.session);
            return frame;
        }
        catch (RemoteException e) {
            throw RemoteClientFrameStore.convertException(e);
        }
    }

    @Override
    public synchronized Frame getFrame(String name) {
        try {
            boolean containsFrame = true;
            Frame frame = this.frameNameToFrameMap.get(name);
            if (frame == null) {
                containsFrame = this.frameNameToFrameMap.containsKey(name);
            } else if (!this.isCachedInternal(frame, this.systemFrames.getNameSlot(), null, false)) {
                frame = null;
                this.frameNameToFrameMap.remove(name);
                containsFrame = false;
            }
            if (frame == null && !containsFrame) {
                if (log.isLoggable(Level.FINE)) {
                    log.fine("Cache miss for frame named " + name);
                }
                RemoteResponse<Frame> response = this.getRemoteDelegate().getFrame(name, this.session);
                this.processValueUpdate(response);
                frame = response.getResponse();
            }
            if (this.transactionNesting == 0) {
                this.frameNameToFrameMap.put(name, frame);
            }
            return frame;
        }
        catch (RemoteException e) {
            throw RemoteClientFrameStore.convertException(e);
        }
    }

    @Override
    public synchronized String getFrameName(Frame frame) {
        try {
            List values = this.getCacheDirectOwnSlotValues(frame, this.getSystemFrames().getNameSlot());
            return (String)CollectionUtilities.getFirstItem(values);
        }
        catch (RemoteException e) {
            throw RemoteClientFrameStore.convertException(e);
        }
    }

    @Override
    public synchronized Cls createCls(FrameID id, Collection directTypes, Collection directSuperclasses, boolean loadDefaultValues) {
        try {
            RemoteResponse<Cls> wrappedCls = this.getRemoteDelegate().createCls(id, directTypes, directSuperclasses, loadDefaultValues, this.session);
            this.processValueUpdate(wrappedCls);
            return wrappedCls.getResponse();
        }
        catch (RemoteException e) {
            throw RemoteClientFrameStore.convertException(e);
        }
    }

    @Override
    public synchronized Slot createSlot(FrameID id, Collection directTypes, Collection directSuperslots, boolean loadDefaultValues) {
        try {
            RemoteResponse<Slot> wrappedSlot = this.getRemoteDelegate().createSlot(id, directTypes, directSuperslots, loadDefaultValues, this.session);
            this.processValueUpdate(wrappedSlot);
            return wrappedSlot.getResponse();
        }
        catch (RemoteException e) {
            throw RemoteClientFrameStore.convertException(e);
        }
    }

    @Override
    public synchronized Facet createFacet(FrameID id, Collection directTypes, boolean loadDefaultValues) {
        try {
            RemoteResponse<Facet> wrappedFacet = this.getRemoteDelegate().createFacet(id, directTypes, loadDefaultValues, this.session);
            this.processValueUpdate(wrappedFacet);
            return wrappedFacet.getResponse();
        }
        catch (RemoteException e) {
            throw RemoteClientFrameStore.convertException(e);
        }
    }

    @Override
    public synchronized SimpleInstance createSimpleInstance(FrameID id, Collection directTypes, boolean loadDefaultValues) {
        try {
            RemoteResponse<SimpleInstance> wrappedSimpleInstance = this.getRemoteDelegate().createSimpleInstance(id, directTypes, loadDefaultValues, this.session);
            this.processValueUpdate(wrappedSimpleInstance);
            return wrappedSimpleInstance.getResponse();
        }
        catch (RemoteException e) {
            throw RemoteClientFrameStore.convertException(e);
        }
    }

    @Override
    public synchronized void deleteCls(Cls cls) {
        try {
            OntologyUpdate vu = this.getRemoteDelegate().deleteCls(cls, this.session);
            this.processValueUpdate(vu);
        }
        catch (RemoteException e) {
            throw RemoteClientFrameStore.convertException(e);
        }
    }

    @Override
    public synchronized void deleteSlot(Slot slot) {
        try {
            OntologyUpdate vu = this.getRemoteDelegate().deleteSlot(slot, this.session);
            this.processValueUpdate(vu);
        }
        catch (RemoteException e) {
            throw RemoteClientFrameStore.convertException(e);
        }
    }

    @Override
    public synchronized void deleteFacet(Facet facet) {
        try {
            OntologyUpdate vu = this.getRemoteDelegate().deleteFacet(facet, this.session);
            this.processValueUpdate(vu);
        }
        catch (RemoteException e) {
            throw RemoteClientFrameStore.convertException(e);
        }
    }

    @Override
    public synchronized void deleteSimpleInstance(SimpleInstance simpleInstance) {
        try {
            OntologyUpdate vu = this.getRemoteDelegate().deleteSimpleInstance(simpleInstance, this.session);
            this.processValueUpdate(vu);
        }
        catch (RemoteException e) {
            throw RemoteClientFrameStore.convertException(e);
        }
    }

    @Override
    public synchronized Set<Slot> getOwnSlots(Frame frame) {
        return this.getCacheOwnSlots(frame);
    }

    @Override
    public synchronized Collection getOwnSlotValues(Frame frame, Slot slot) {
        return this.getCacheOwnSlotValues(frame, slot);
    }

    @Override
    public synchronized List getDirectOwnSlotValues(Frame frame, Slot slot) {
        try {
            return this.getCacheDirectOwnSlotValues(frame, slot);
        }
        catch (RemoteException e) {
            throw RemoteClientFrameStore.convertException(e);
        }
    }

    @Override
    public synchronized int getDirectOwnSlotValuesCount(Frame frame, Slot slot) {
        try {
            return this.getCacheDirectOwnSlotValues(frame, slot).size();
        }
        catch (RemoteException e) {
            throw RemoteClientFrameStore.convertException(e);
        }
    }

    @Override
    public synchronized void moveDirectOwnSlotValue(Frame frame, Slot slot, int from, int to) {
        try {
            OntologyUpdate vu = this.getRemoteDelegate().moveDirectOwnSlotValue(frame, slot, from, to, this.session);
            this.processValueUpdate(vu);
        }
        catch (RemoteException e) {
            throw RemoteClientFrameStore.convertException(e);
        }
    }

    @Override
    public synchronized void setDirectOwnSlotValues(Frame frame, Slot slot, Collection values) {
        try {
            OntologyUpdate vu = this.getRemoteDelegate().setDirectOwnSlotValues(frame, slot, values, this.session);
            this.processValueUpdate(vu);
        }
        catch (RemoteException e) {
            throw RemoteClientFrameStore.convertException(e);
        }
    }

    @Override
    public synchronized Set getOwnFacets(Frame frame, Slot slot) {
        return this.getCacheOwnFacets(frame, slot);
    }

    @Override
    public synchronized Collection getOwnFacetValues(Frame frame, Slot slot, Facet facet) {
        return this.getCacheOwnFacetValues(frame, slot, facet);
    }

    @Override
    public synchronized Set getTemplateSlots(Cls cls) {
        return this.getCacheTemplateSlots(cls);
    }

    @Override
    public synchronized List getDirectTemplateSlots(Cls cls) {
        try {
            return this.getCacheDirectOwnSlotValues(cls, this.getSystemFrames().getDirectTemplateSlotsSlot());
        }
        catch (RemoteException e) {
            throw RemoteClientFrameStore.convertException(e);
        }
    }

    @Override
    public synchronized List getDirectDomain(Slot slot) {
        try {
            return this.getCacheDirectOwnSlotValues(slot, this.getSystemFrames().getDirectDomainSlot());
        }
        catch (RemoteException e) {
            throw RemoteClientFrameStore.convertException(e);
        }
    }

    @Override
    public synchronized Set getDomain(Slot slot) {
        try {
            return this.getCacheDomain(slot);
        }
        catch (RemoteException e) {
            throw RemoteClientFrameStore.convertException(e);
        }
    }

    @Override
    public Set getOverriddenTemplateSlots(Cls cls) {
        try {
            Set slots = this.getRemoteDelegate().getOverriddenTemplateSlots(cls, this.session);
            return slots;
        }
        catch (RemoteException e) {
            throw RemoteClientFrameStore.convertException(e);
        }
    }

    @Override
    public Set getDirectlyOverriddenTemplateSlots(Cls cls) {
        try {
            Set slots = this.getRemoteDelegate().getDirectlyOverriddenTemplateSlots(cls, this.session);
            return slots;
        }
        catch (RemoteException e) {
            throw RemoteClientFrameStore.convertException(e);
        }
    }

    @Override
    public synchronized void addDirectTemplateSlot(Cls cls, Slot slot) {
        try {
            OntologyUpdate vu = this.getRemoteDelegate().addDirectTemplateSlot(cls, slot, this.session);
            this.processValueUpdate(vu);
        }
        catch (RemoteException e) {
            throw RemoteClientFrameStore.convertException(e);
        }
    }

    @Override
    public synchronized void removeDirectTemplateSlot(Cls cls, Slot slot) {
        try {
            OntologyUpdate vu = this.getRemoteDelegate().removeDirectTemplateSlot(cls, slot, this.session);
            this.processValueUpdate(vu);
        }
        catch (RemoteException e) {
            throw RemoteClientFrameStore.convertException(e);
        }
    }

    @Override
    public synchronized void moveDirectTemplateSlot(Cls cls, Slot slot, int index) {
        try {
            OntologyUpdate vu = this.getRemoteDelegate().moveDirectTemplateSlot(cls, slot, index, this.session);
            this.processValueUpdate(vu);
        }
        catch (RemoteException e) {
            throw RemoteClientFrameStore.convertException(e);
        }
    }

    @Override
    public synchronized Collection getTemplateSlotValues(Cls cls, Slot slot) {
        return this.getCacheTemplateSlotValues(cls, slot);
    }

    @Override
    public synchronized List getDirectTemplateSlotValues(Cls cls, Slot slot) {
        try {
            return this.getCacheValues(cls, slot, this.getSystemFrames().getValuesFacet(), true);
        }
        catch (RemoteException e) {
            throw RemoteClientFrameStore.convertException(e);
        }
    }

    @Override
    public synchronized void setDirectTemplateSlotValues(Cls cls, Slot slot, Collection values) {
        try {
            OntologyUpdate vu = this.getRemoteDelegate().setDirectTemplateSlotValues(cls, slot, values, this.session);
            this.processValueUpdate(vu);
        }
        catch (RemoteException e) {
            throw RemoteClientFrameStore.convertException(e);
        }
    }

    @Override
    public Set<Facet> getTemplateFacets(Cls cls, Slot slot) {
        try {
            Set<Facet> facets = this.getRemoteDelegate().getTemplateFacets(cls, slot, this.session);
            return facets;
        }
        catch (RemoteException e) {
            throw RemoteClientFrameStore.convertException(e);
        }
    }

    @Override
    public Set getOverriddenTemplateFacets(Cls cls, Slot slot) {
        try {
            Set facets = this.getRemoteDelegate().getOverriddenTemplateFacets(cls, slot, this.session);
            return facets;
        }
        catch (RemoteException e) {
            throw RemoteClientFrameStore.convertException(e);
        }
    }

    @Override
    public Set getDirectlyOverriddenTemplateFacets(Cls cls, Slot slot) {
        try {
            Set facets = this.getRemoteDelegate().getDirectlyOverriddenTemplateFacets(cls, slot, this.session);
            return facets;
        }
        catch (RemoteException e) {
            throw RemoteClientFrameStore.convertException(e);
        }
    }

    @Override
    public synchronized void removeDirectTemplateFacetOverrides(Cls cls, Slot slot) {
        try {
            OntologyUpdate vu = this.getRemoteDelegate().removeDirectTemplateFacetOverrides(cls, slot, this.session);
            this.processValueUpdate(vu);
        }
        catch (RemoteException e) {
            throw RemoteClientFrameStore.convertException(e);
        }
    }

    @Override
    public synchronized Collection getTemplateFacetValues(Cls cls, Slot slot, Facet facet) {
        return this.getCacheTemplateFacetValues(cls, slot, facet);
    }

    @Override
    public synchronized List getDirectTemplateFacetValues(Cls cls, Slot slot, Facet facet) {
        try {
            return this.getCacheValues(cls, slot, facet, true);
        }
        catch (RemoteException e) {
            throw RemoteClientFrameStore.convertException(e);
        }
    }

    @Override
    public synchronized void setDirectTemplateFacetValues(Cls cls, Slot slot, Facet facet, Collection values) {
        try {
            OntologyUpdate vu = this.getRemoteDelegate().setDirectTemplateFacetValues(cls, slot, facet, values, this.session);
            this.processValueUpdate(vu);
        }
        catch (RemoteException e) {
            throw RemoteClientFrameStore.convertException(e);
        }
    }

    @Override
    public synchronized List<Cls> getDirectSuperclasses(Cls cls) {
        try {
            return this.getCacheDirectOwnSlotValues(cls, this.getSystemFrames().getDirectSuperclassesSlot());
        }
        catch (RemoteException e) {
            throw RemoteClientFrameStore.convertException(e);
        }
    }

    @Override
    public synchronized Set getSuperclasses(Cls cls) {
        try {
            return this.getCacheOwnSlotValueClosure(cls, this.getSystemFrames().getDirectSuperclassesSlot());
        }
        catch (RemoteException e) {
            throw RemoteClientFrameStore.convertException(e);
        }
    }

    private SystemFrames getSystemFrames() {
        return this.systemFrames;
    }

    @Override
    public synchronized List<Cls> getDirectSubclasses(Cls cls) {
        try {
            return this.getCacheDirectOwnSlotValues(cls, this.getSystemFrames().getDirectSubclassesSlot());
        }
        catch (RemoteException e) {
            throw RemoteClientFrameStore.convertException(e);
        }
    }

    @Override
    public synchronized Set<Cls> getSubclasses(Cls cls) {
        try {
            return this.getCacheOwnSlotValueClosure(cls, this.getSystemFrames().getDirectSubclassesSlot());
        }
        catch (RemoteException e) {
            throw RemoteClientFrameStore.convertException(e);
        }
    }

    @Override
    public synchronized void addDirectSuperclass(Cls cls, Cls superclass) {
        try {
            OntologyUpdate vu = this.getRemoteDelegate().addDirectSuperclass(cls, superclass, this.session);
            this.processValueUpdate(vu);
        }
        catch (RemoteException e) {
            throw RemoteClientFrameStore.convertException(e);
        }
    }

    @Override
    public synchronized void removeDirectSuperclass(Cls cls, Cls superclass) {
        try {
            OntologyUpdate vu = this.getRemoteDelegate().removeDirectSuperclass(cls, superclass, this.session);
            this.processValueUpdate(vu);
        }
        catch (RemoteException e) {
            throw RemoteClientFrameStore.convertException(e);
        }
    }

    @Override
    public synchronized void moveDirectSubclass(Cls cls, Cls subclass, int index) {
        try {
            OntologyUpdate vu = this.getRemoteDelegate().moveDirectSubclass(cls, subclass, index, this.session);
            this.processValueUpdate(vu);
        }
        catch (RemoteException e) {
            throw RemoteClientFrameStore.convertException(e);
        }
    }

    @Override
    public synchronized List getDirectSuperslots(Slot slot) {
        try {
            return this.getCacheDirectOwnSlotValues(slot, this.getSystemFrames().getDirectSuperslotsSlot());
        }
        catch (RemoteException e) {
            throw RemoteClientFrameStore.convertException(e);
        }
    }

    @Override
    public synchronized Set getSuperslots(Slot slot) {
        try {
            return this.getCacheOwnSlotValueClosure(slot, this.getSystemFrames().getDirectSuperslotsSlot());
        }
        catch (RemoteException e) {
            throw RemoteClientFrameStore.convertException(e);
        }
    }

    @Override
    public synchronized List getDirectSubslots(Slot slot) {
        try {
            return this.getCacheDirectOwnSlotValues(slot, this.getSystemFrames().getDirectSubslotsSlot());
        }
        catch (RemoteException e) {
            throw RemoteClientFrameStore.convertException(e);
        }
    }

    @Override
    public synchronized Set getSubslots(Slot slot) {
        try {
            return this.getCacheOwnSlotValueClosure(slot, this.getSystemFrames().getDirectSubslotsSlot());
        }
        catch (RemoteException e) {
            throw RemoteClientFrameStore.convertException(e);
        }
    }

    @Override
    public synchronized void addDirectSuperslot(Slot slot, Slot superslot) {
        try {
            OntologyUpdate vu = this.getRemoteDelegate().addDirectSuperslot(slot, superslot, this.session);
            this.processValueUpdate(vu);
        }
        catch (RemoteException e) {
            throw RemoteClientFrameStore.convertException(e);
        }
    }

    @Override
    public synchronized void removeDirectSuperslot(Slot slot, Slot superslot) {
        try {
            OntologyUpdate vu = this.getRemoteDelegate().removeDirectSuperslot(slot, superslot, this.session);
            this.processValueUpdate(vu);
        }
        catch (RemoteException e) {
            throw RemoteClientFrameStore.convertException(e);
        }
    }

    @Override
    public synchronized void moveDirectSubslot(Slot slot, Slot subslot, int index) {
        try {
            OntologyUpdate vu = this.getRemoteDelegate().moveDirectSubslot(slot, subslot, index, this.session);
            this.processValueUpdate(vu);
        }
        catch (RemoteException e) {
            throw RemoteClientFrameStore.convertException(e);
        }
    }

    @Override
    public synchronized List getDirectTypes(Instance instance) {
        try {
            return this.getCacheDirectOwnSlotValues(instance, this.getSystemFrames().getDirectTypesSlot());
        }
        catch (RemoteException e) {
            throw RemoteClientFrameStore.convertException(e);
        }
    }

    @Override
    public synchronized Set getTypes(Instance instance) {
        try {
            return this.getCacheOwnSlotValueClosure(this.getDirectTypes(instance), this.getSystemFrames().getDirectSuperclassesSlot());
        }
        catch (RemoteException e) {
            throw RemoteClientFrameStore.convertException(e);
        }
    }

    @Override
    public synchronized List<Instance> getDirectInstances(Cls cls) {
        try {
            return this.getCacheDirectOwnSlotValues(cls, this.getSystemFrames().getDirectInstancesSlot());
        }
        catch (RemoteException e) {
            throw RemoteClientFrameStore.convertException(e);
        }
    }

    @Override
    public synchronized Set<Instance> getInstances(Cls cls) {
        HashSet<Cls> subClasses = new HashSet<Cls>();
        subClasses.addAll(this.getSubclasses(cls));
        subClasses.add(cls);
        HashSet<Instance> values = new HashSet<Instance>();
        HashSet<Cls> missingClasses = new HashSet<Cls>();
        for (Cls subClass : subClasses) {
            if (this.isCachedInternal(subClass, this.getSystemFrames().getDirectInstancesSlot(), null, false)) {
                values.addAll(this.getDirectInstances(subClass));
                continue;
            }
            missingClasses.add(subClass);
        }
        if (missingClasses.isEmpty()) {
            return values;
        }
        if (missingClasses.size() == 1) {
            Cls subClass = (Cls)missingClasses.iterator().next();
            values.addAll(this.getDirectInstances(subClass));
            return values;
        }
        try {
            RemoteResponse<Set<Instance>> instances = this.getRemoteDelegate().getInstances(cls, this.session);
            this.processValueUpdate(instances);
            return instances.getResponse();
        }
        catch (RemoteException e) {
            throw RemoteClientFrameStore.convertException(e);
        }
    }

    @Override
    public synchronized void addDirectType(Instance instance, Cls type) {
        try {
            OntologyUpdate vu = this.getRemoteDelegate().addDirectType(instance, type, this.session);
            this.processValueUpdate(vu);
        }
        catch (RemoteException e) {
            throw RemoteClientFrameStore.convertException(e);
        }
    }

    @Override
    public synchronized void removeDirectType(Instance instance, Cls type) {
        try {
            OntologyUpdate vu = this.getRemoteDelegate().removeDirectType(instance, type, this.session);
            this.processValueUpdate(vu);
        }
        catch (RemoteException e) {
            throw RemoteClientFrameStore.convertException(e);
        }
    }

    @Override
    public synchronized void moveDirectType(Instance instance, Cls type, int index) {
        try {
            OntologyUpdate vu = this.getRemoteDelegate().moveDirectType(instance, type, index, this.session);
            this.processValueUpdate(vu);
        }
        catch (RemoteException e) {
            throw RemoteClientFrameStore.convertException(e);
        }
    }

    @Override
    public synchronized List<AbstractEvent> getEvents() {
        if (this.transactionNesting > 0) {
            return new ArrayList<AbstractEvent>();
        }
        List<AbstractEvent> receivedEvents = null;
        try {
            RemoteResponse<List<AbstractEvent>> response = this.getRemoteDelegate().getEvents(this.session);
            this.processValueUpdate(response);
            receivedEvents = response.getResponse();
            return receivedEvents;
        }
        catch (RemoteException e) {
            Log.getLogger().log(Level.SEVERE, "Exception caught - local cache may be out of date", e);
            throw new RuntimeException(e);
        }
    }

    @Override
    public void executeQuery(final Query query, final QueryCallback callback) {
        new Thread("Remote Client Callback thread"){

            public void run() {
                try {
                    RemoteResponse<Collection<Frame>> response = RemoteClientFrameStore.this.getRemoteDelegate().executeQuery(query, RemoteClientFrameStore.this.session);
                    RemoteClientFrameStore.this.processValueUpdate(response);
                    callback.provideQueryResults(response.getResponse());
                }
                catch (OntologyException oe) {
                    callback.handleError(oe);
                }
                catch (ProtegeIOException ioe) {
                    callback.handleError(ioe);
                }
                catch (RemoteException re) {
                    Log.getLogger().log(Level.WARNING, "Exception accessing remote host", re);
                    callback.handleError(new ProtegeIOException(re));
                }
                catch (ProtegeError pe) {
                    callback.handleError(pe);
                }
                catch (Throwable t) {
                    Log.getLogger().log(Level.WARNING, "Developer error", t);
                    callback.handleError(new ProtegeError(t));
                }
            }
        }.start();
    }

    @Override
    public synchronized Set<Reference> getReferences(Object object) {
        try {
            Set<Reference> references = this.getRemoteDelegate().getReferences(object, this.session);
            return references;
        }
        catch (RemoteException e) {
            throw RemoteClientFrameStore.convertException(e);
        }
    }

    @Override
    public Set<Cls> getClsesWithMatchingBrowserText(String text, Collection superclasses, int maxMatches) {
        try {
            Set<Cls> clses = this.getRemoteDelegate().getClsesWithMatchingBrowserText(text, superclasses, maxMatches, this.session);
            return clses;
        }
        catch (RemoteException e) {
            throw RemoteClientFrameStore.convertException(e);
        }
    }

    @Override
    public Set<Reference> getMatchingReferences(String string, int maxMatches) {
        try {
            Set<Reference> references = this.getRemoteDelegate().getMatchingReferences(string, maxMatches, this.session);
            return references;
        }
        catch (RemoteException e) {
            throw RemoteClientFrameStore.convertException(e);
        }
    }

    @Override
    public Set<Frame> getFramesWithDirectOwnSlotValue(Slot slot, Object value) {
        try {
            Set<Frame> frames = this.getRemoteDelegate().getFramesWithDirectOwnSlotValue(slot, value, this.session);
            return frames;
        }
        catch (RemoteException e) {
            throw RemoteClientFrameStore.convertException(e);
        }
    }

    @Override
    public Set<Frame> getFramesWithAnyDirectOwnSlotValue(Slot slot) {
        try {
            Set<Frame> frames = this.getRemoteDelegate().getFramesWithAnyDirectOwnSlotValue(slot, this.session);
            return frames;
        }
        catch (RemoteException e) {
            throw RemoteClientFrameStore.convertException(e);
        }
    }

    @Override
    public Set<Frame> getFramesWithMatchingDirectOwnSlotValue(Slot slot, String value, int maxMatches) {
        try {
            Set<Frame> frames = this.getRemoteDelegate().getFramesWithMatchingDirectOwnSlotValue(slot, value, maxMatches, this.session);
            return frames;
        }
        catch (RemoteException e) {
            throw RemoteClientFrameStore.convertException(e);
        }
    }

    @Override
    public Set getClsesWithDirectTemplateSlotValue(Slot slot, Object value) {
        try {
            Set clses = this.getRemoteDelegate().getClsesWithDirectTemplateSlotValue(slot, value, this.session);
            return clses;
        }
        catch (RemoteException e) {
            throw RemoteClientFrameStore.convertException(e);
        }
    }

    @Override
    public Set<Cls> getClsesWithAnyDirectTemplateSlotValue(Slot slot) {
        try {
            Set<Cls> clses = this.getRemoteDelegate().getClsesWithAnyDirectTemplateSlotValue(slot, this.session);
            return clses;
        }
        catch (RemoteException e) {
            throw RemoteClientFrameStore.convertException(e);
        }
    }

    @Override
    public Set getClsesWithMatchingDirectTemplateSlotValue(Slot slot, String value, int maxMatches) {
        try {
            Set clses = this.getRemoteDelegate().getClsesWithMatchingDirectTemplateSlotValue(slot, value, maxMatches, this.session);
            return clses;
        }
        catch (RemoteException e) {
            throw RemoteClientFrameStore.convertException(e);
        }
    }

    @Override
    public Set getClsesWithDirectTemplateFacetValue(Slot slot, Facet facet, Object value) {
        try {
            Set clses = this.getRemoteDelegate().getClsesWithDirectTemplateFacetValue(slot, facet, value, this.session);
            return clses;
        }
        catch (RemoteException e) {
            throw RemoteClientFrameStore.convertException(e);
        }
    }

    @Override
    public Set getClsesWithMatchingDirectTemplateFacetValue(Slot slot, Facet facet, String value, int maxMatches) {
        try {
            Set clses = this.getRemoteDelegate().getClsesWithMatchingDirectTemplateFacetValue(slot, facet, value, maxMatches, this.session);
            return clses;
        }
        catch (RemoteException e) {
            throw RemoteClientFrameStore.convertException(e);
        }
    }

    @Override
    public synchronized Set getDirectOwnSlotValuesClosure(Frame frame, Slot slot) {
        try {
            return this.getCacheClosure(frame, slot);
        }
        catch (RemoteException e) {
            throw RemoteClientFrameStore.convertException(e);
        }
    }

    @Override
    public synchronized boolean beginTransaction(String name) {
        if (cacheLog.isLoggable(Level.FINE)) {
            cacheLog.fine("Begin Transaction");
        }
        try {
            RemoteResponse<Boolean> ret = this.getRemoteDelegate().beginTransaction(name, this.session);
            this.processValueUpdate(ret);
            ++this.transactionNesting;
            return ret.getResponse();
        }
        catch (RemoteException e) {
            throw RemoteClientFrameStore.convertException(e);
        }
    }

    @Override
    public synchronized boolean commitTransaction() {
        if (cacheLog.isLoggable(Level.FINE)) {
            cacheLog.fine("Commit Transaction");
        }
        try {
            RemoteResponse<Boolean> ret = this.getRemoteDelegate().commitTransaction(this.session);
            this.processValueUpdate(ret);
            --this.transactionNesting;
            return ret.getResponse();
        }
        catch (RemoteException e) {
            throw RemoteClientFrameStore.convertException(e);
        }
    }

    @Override
    public synchronized boolean rollbackTransaction() {
        if (cacheLog.isLoggable(Level.FINE)) {
            cacheLog.fine("Rollback Transaction");
        }
        try {
            RemoteResponse<Boolean> ret = this.getRemoteDelegate().rollbackTransaction(this.session);
            this.processValueUpdate(ret);
            --this.transactionNesting;
            return ret.getResponse();
        }
        catch (RemoteException e) {
            throw RemoteClientFrameStore.convertException(e);
        }
    }

    @Override
    public TransactionMonitor getTransactionStatusMonitor() {
        throw new UnsupportedOperationException("Shouldn't be doing this on the client side");
    }

    public static TransactionIsolationLevel getTransactionIsolationLevel(KnowledgeBase kb) throws TransactionException {
        RemoteClientFrameStore frameStore = RemoteClientFrameStore.getMeFromKb(kb);
        if (frameStore == null) {
            return TransactionIsolationLevel.NONE;
        }
        return frameStore.getTransactionIsolationLevel();
    }

    public synchronized TransactionIsolationLevel getTransactionIsolationLevel() throws TransactionException {
        if (this.transactionLevel != null) {
            return this.transactionLevel;
        }
        try {
            this.transactionLevel = this.getRemoteDelegate().getTransactionIsolationLevel();
            return this.transactionLevel;
        }
        catch (RemoteException re) {
            throw new TransactionException(re);
        }
    }

    public static boolean setTransactionIsolationLevel(KnowledgeBase kb, TransactionIsolationLevel level) throws TransactionException {
        RemoteClientFrameStore frameStore = RemoteClientFrameStore.getMeFromKb(kb);
        if (frameStore == null) {
            return false;
        }
        return frameStore.setTransactionIsolationLevel(level);
    }

    public synchronized boolean setTransactionIsolationLevel(TransactionIsolationLevel level) throws TransactionException {
        try {
            this.transactionLevel = null;
            return this.getRemoteDelegate().setTransactionIsolationLevel(level);
        }
        catch (RemoteException re) {
            throw new TransactionException(re);
        }
    }

    @Override
    public synchronized void close() {
        try {
            if (this.server != null) {
                this.server.closeSession(this.session);
                this.server = null;
            }
            this.remoteDelegate = null;
        }
        catch (RemoteException e) {
            throw RemoteClientFrameStore.convertException(e);
        }
    }

    public synchronized void preload(boolean preloadAll) throws RemoteException {
        boolean skip = ServerProperties.skipPreload();
        if (skip) {
            return;
        }
        Log.getLogger().config("Preloading frame values: " + this.kb);
        Set<String> frames = ServerProperties.preloadUserFrames();
        OntologyUpdate vu = this.getRemoteDelegate().preload(frames, preloadAll, this.session);
        this.processValueUpdate(vu);
    }

    private Set getCacheOwnSlotValueClosure(Frame frame, Slot slot) throws RemoteException {
        return this.getCacheClosure(frame, slot);
    }

    private Set getCacheOwnSlotValueClosure(Collection<Frame> frames, Slot slot) throws RemoteException {
        return this.getCacheClosure(frames, slot);
    }

    private Set getCacheClosure(Frame frame, Slot slot) throws RemoteException {
        Set closure = new LinkedHashSet();
        HashSet<Frame> missing = new HashSet<Frame>();
        this.calculateClosureFromCacheOnly(frame, slot, closure, missing);
        if (!missing.isEmpty()) {
            if (log.isLoggable(Level.FINE)) {
                log.fine("not in closure cache: " + frame.getFrameID() + ", " + slot.getFrameID());
            }
            ++this.stats.closureMiss;
            RemoteResponse<Set> wrappedClosure = this.getRemoteDelegate().getDirectOwnSlotValuesClosure(frame, slot, missing, this.session);
            this.processValueUpdate(wrappedClosure);
            closure = wrappedClosure.getResponse();
            if (log.isLoggable(Level.FINE)) {
                for (Object o : closure) {
                    if (o instanceof Frame) {
                        log.fine("\t closure frame = " + ((Frame)o).getFrameID());
                        continue;
                    }
                    log.fine("other closure " + o);
                }
            }
        } else {
            ++this.stats.closureHit;
        }
        return closure;
    }

    private void calculateClosureFromCacheOnly(Frame frame, Slot slot, Set closure, Set<Frame> missing) throws RemoteException {
        if (this.isCachedInternal(frame, slot, null, false)) {
            List values = this.getCacheValues(frame, slot, null, false);
            for (Object value : values) {
                boolean changed = closure.add(value);
                if (!changed || !(value instanceof Frame)) continue;
                this.calculateClosureFromCacheOnly((Frame)value, slot, closure, missing);
            }
        } else {
            missing.add(frame);
        }
    }

    private Set getCacheClosure(Collection<Frame> frames, Slot slot) throws RemoteException {
        Set<Frame> closure = new LinkedHashSet<Frame>(frames);
        HashSet<Frame> missing = new HashSet<Frame>();
        for (Frame frame : frames) {
            this.calculateClosureFromCacheOnly(frame, slot, closure, missing);
        }
        if (!missing.isEmpty()) {
            ++this.stats.closureMiss;
            RemoteResponse<Set> wrappedClosure = this.getRemoteDelegate().getDirectOwnSlotValuesClosure(frames, slot, missing, this.session);
            this.processValueUpdate(wrappedClosure);
            closure = wrappedClosure.getResponse();
            closure.addAll(frames);
            return closure;
        }
        ++this.stats.closureHit;
        return closure;
    }

    private List getCacheDirectOwnSlotValues(Frame frame, Slot slot) throws RemoteException {
        return this.getCacheValues(frame, slot, null, false);
    }

    public Collection getCacheOwnFacetValues(Frame frame, Slot slot, Facet facet) {
        Collection values = new ArrayList();
        for (Cls cls : this.getDirectTypes((Instance)frame)) {
            Collection typeValues = this.getTemplateFacetValues(cls, slot, facet);
            values = RemoteClientFrameStore.resolveValues(values, typeValues, facet);
        }
        return values;
    }

    private Collection getCacheTemplateFacetValues(Cls localCls, Slot slot, Facet facet) {
        Collection values = new ArrayList(this.getDirectTemplateFacetValues(localCls, slot, facet));
        for (Cls cls : this.getSuperclasses(localCls)) {
            List superclassValues = this.getDirectTemplateFacetValues(cls, slot, facet);
            values = RemoteClientFrameStore.resolveValues(values, superclassValues, facet);
        }
        Slot associatedSlot = (Slot)this.getDirectOwnSlotValue(facet, this.getSystemFrames().getAssociatedSlotSlot());
        if (associatedSlot != null) {
            List topLevelValues = this.getDirectOwnSlotValues(slot, associatedSlot);
            values = RemoteClientFrameStore.resolveValues(values, topLevelValues, facet);
        }
        return values;
    }

    private Object getDirectOwnSlotValue(Frame frame, Slot slot) {
        List values = this.getDirectOwnSlotValues(frame, slot);
        return CollectionUtilities.getFirstItem(values);
    }

    private static Collection resolveValues(Collection values, Collection newValues, Facet facet) {
        if (!newValues.isEmpty()) {
            if (values.isEmpty()) {
                values.addAll(newValues);
            } else if ((values = facet.resolveValues(values, newValues)) == newValues) {
                values = new ArrayList(values);
            }
        }
        return values;
    }

    public Collection getCacheOwnSlotValues(Frame frame, Slot slot) {
        ArrayList values = new ArrayList();
        this.addOwnSlotValues(frame, slot, values);
        return values;
    }

    private void addOwnSlotValues(Frame frame, Slot slot, Collection values) {
        values.addAll(this.getDirectOwnSlotValues(frame, slot));
        this.addInheritedTemplateSlotValues(frame, slot, values);
        this.addSubslotValues(frame, slot, values);
        if (frame instanceof Slot && values.isEmpty() && this.isInheritedSuperslotSlot(slot)) {
            this.addInheritedSuperslotValues((Slot)frame, slot, values);
        }
    }

    private boolean isInheritedSuperslotSlot(Slot slot) {
        return slot.equals(this.getSystemFrames().getDirectDomainSlot()) || slot.equals(this.getSystemFrames().getValueTypeSlot()) || slot.equals(this.getSystemFrames().getMaximumCardinalitySlot()) || slot.equals(this.getSystemFrames().getMinimumValueSlot()) || slot.equals(this.getSystemFrames().getMaximumValueSlot());
    }

    private void addInheritedSuperslotValues(Slot slotFrame, Slot slot, Collection values) {
        Facet facet = (Facet)this.getDirectOwnSlotValue(slot, this.getSystemFrames().getAssociatedFacetSlot());
        for (Slot superslot : this.getSuperslots(slotFrame)) {
            List superslotValues = this.getDirectOwnSlotValues(superslot, slot);
            if (facet == null) {
                values.addAll(superslotValues);
                continue;
            }
            Collection resolvedValues = facet.resolveValues(values, superslotValues);
            if (((Object)resolvedValues).equals(values)) continue;
            values.clear();
            values.addAll(resolvedValues);
        }
    }

    private void addInheritedTemplateSlotValues(Frame frame, Slot slot, Collection values) {
        if (frame instanceof Instance) {
            LinkedHashSet templateSlotValues = new LinkedHashSet();
            Instance instance = (Instance)frame;
            for (Cls type : this.getTypes(instance)) {
                templateSlotValues.addAll(this.getDirectTemplateSlotValues(type, slot));
            }
            values.addAll(templateSlotValues);
        }
    }

    private void addSubslotValues(Frame frame, Slot slot, Collection values) {
        for (Slot subslot : this.getSubslots(slot)) {
            values.addAll(this.getDirectOwnSlotValues(frame, subslot));
        }
    }

    private Set getCacheOwnFacets(Frame frame, Slot slot) {
        HashSet<Facet> facets = new HashSet<Facet>();
        for (Slot ownSlot : this.getOwnSlots(slot)) {
            Facet facet = (Facet)this.getDirectOwnSlotValue(ownSlot, this.getSystemFrames().getAssociatedFacetSlot());
            if (facet == null) continue;
            facets.add(facet);
        }
        return facets;
    }

    private Collection getCacheTemplateSlotValues(Cls cls, Slot slot) {
        return this.getTemplateFacetValues(cls, slot, this.getSystemFrames().getValuesFacet());
    }

    private Set<Slot> getCacheOwnSlots(Frame frame) {
        Set types = this.getTypes((Instance)frame);
        Set<Slot> ownSlots = this.collectOwnSlotValues(types, this.getSystemFrames().getDirectTemplateSlotsSlot());
        ownSlots.add(this.getSystemFrames().getNameSlot());
        ownSlots.add(this.getSystemFrames().getDirectTypesSlot());
        return ownSlots;
    }

    private Set<Slot> collectOwnSlotValues(Collection frames, Slot slot) {
        LinkedHashSet<Slot> values = new LinkedHashSet<Slot>();
        Object[] frameArray = frames.toArray();
        for (int i = 0; i < frameArray.length; ++i) {
            Frame frame = (Frame)frameArray[i];
            values.addAll(this.getDirectOwnSlotValues(frame, slot));
        }
        return values;
    }

    private Set getCacheTemplateSlots(Cls cls) {
        LinkedHashSet<Cls> clses = new LinkedHashSet<Cls>(this.getSuperclasses(cls));
        clses.add(cls);
        Set<Slot> values = this.collectOwnSlotValues(clses, this.getSystemFrames().getDirectTemplateSlotsSlot());
        return values;
    }

    private Set getCacheDomain(Slot slot) throws RemoteException {
        return this.getCacheOwnSlotValueClosure(this.getDirectDomain(slot), this.getSystemFrames().getDirectSubclassesSlot());
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private List getCacheValues(Frame frame, Slot slot, Facet facet, boolean isTemplate) throws RemoteException {
        void var5_10;
        void var5_8;
        Object var5_5 = null;
        CacheResult<List> cachedResult = this.readCache(frame, slot, facet, isTemplate);
        if (cachedResult.isValid()) {
            List list = cachedResult.getResult();
        } else {
            if (log.isLoggable(Level.FINE)) {
                log.fine("cache miss for frame " + frame.getFrameID() + " slot " + slot.getFrameID() + (facet == null ? "null" : "" + facet.getFrameID()) + " template " + isTemplate);
            }
            RemoteResponse<List> vu = null;
            if (facet != null) {
                if (!isTemplate) throw new UnsupportedOperationException("We don't cache this information...");
                vu = this.getRemoteDelegate().getDirectTemplateFacetValues((Cls)frame, slot, facet, this.session);
            } else {
                vu = isTemplate ? this.getRemoteDelegate().getDirectTemplateSlotValues((Cls)frame, slot, this.session) : this.getRemoteDelegate().getDirectOwnSlotValues(frame, slot, this.session);
            }
            this.processValueUpdate(vu);
            List list = vu.getResponse();
        }
        if (var5_8 != null) return var5_10;
        ArrayList arrayList = new ArrayList();
        return var5_10;
    }

    private boolean isCachedInternal(Frame frame, Slot slot, Facet facet, boolean isTemplate) {
        return this.readCache(frame, slot, facet, isTemplate).isValid();
    }

    private CacheResult<List> readCache(Frame frame, Slot slot, Facet facet, boolean isTemplate) {
        CacheResult<List> ret;
        Cache cache = this.cacheMap.get(frame);
        if (cacheLog.isLoggable(Level.FINEST) && cache != null) {
            cacheLog.finest("Using cache " + cache.getCacheId() + " for " + frame.getFrameID().getName());
        }
        if (cache == null) {
            ret = CacheResult.getInvalid();
        } else if (cache.isInvalid()) {
            if (cacheLog.isLoggable(Level.FINEST)) {
                cacheLog.finest("Cache is deleted");
            }
            this.cacheMap.remove(frame);
            cache = null;
            ret = CacheResult.getInvalid();
        } else {
            ret = cache.readCache(this.session, new Sft(slot, facet, isTemplate));
        }
        if (cacheLog.isLoggable(Level.FINEST)) {
            cacheLog.finest("Cache Result for " + frame.getFrameID().getName() + ", " + slot.getFrameID().getName() + ", " + (facet == null ? "null" : facet.getFrameID().getName()) + ", " + isTemplate + " returns = " + ret);
        }
        if (ret.isValid()) {
            ++this.stats.hit;
        } else {
            ++this.stats.miss;
        }
        return ret;
    }

    private void processValueUpdate(OntologyUpdate updates) {
        if (cacheLog.isLoggable(Level.FINE) && updates.getValueUpdates().size() != 0) {
            cacheLog.fine("received " + updates.getValueUpdates().size() + " value updates for Knowledge base " + this.kb);
        }
        FifoReader<SerializedCacheUpdate<RemoteSession, Sft, List>> deferredTransactionsReader = new FifoReader<SerializedCacheUpdate<RemoteSession, Sft, List>>(this.deferredTransactionsWriter);
        for (ValueUpdate vu : updates.getValueUpdates()) {
            SerializedCacheUpdate<RemoteSession, Sft, List> cacheUpdate;
            if (cacheLog.isLoggable(Level.FINER)) {
                cacheLog.finer("processing " + vu);
            }
            if ((cacheUpdate = vu.getUpdate()) instanceof CacheBeginTransaction || cacheUpdate instanceof CacheCommitTransaction || cacheUpdate instanceof CacheRollbackTransaction) {
                this.deferredTransactionsWriter.write(cacheUpdate);
                continue;
            }
            Frame frame = vu.getFrame();
            if (frame == null && cacheUpdate instanceof CacheDelete) {
                this.deferredTransactionsWriter.write(cacheUpdate);
                continue;
            }
            if (this.frameNameToFrameMap.get(frame.getName()) == null || cacheUpdate instanceof CacheDelete || cacheUpdate instanceof CacheModify) {
                this.frameNameToFrameMap.remove(frame.getName());
            }
            try {
                DeferredOperationCache cache = this.cacheMap.get(frame);
                if (cache != null && cache.isInvalid()) {
                    cache = null;
                    this.cacheMap.remove(frame);
                }
                if (cache == null) {
                    cache = CacheFactory.createEmptyCache(this.getTransactionIsolationLevel());
                    FifoReader<SerializedCacheUpdate<RemoteSession, Sft, List>> reader = new FifoReader<SerializedCacheUpdate<RemoteSession, Sft, List>>(deferredTransactionsReader);
                    cache = new DeferredOperationCache(cache, reader);
                    this.cacheMap.put(frame, cache);
                    if (cacheLog.isLoggable(Level.FINEST)) {
                        cacheLog.finest("Created cache " + cache.getCacheId() + " for frame " + frame.getFrameID().getName());
                    }
                }
                cacheUpdate.performUpdate(cache);
            }
            catch (Throwable t) {
                this.cacheMap.remove(frame);
                log.log(Level.WARNING, "Exception caught processing cache for " + frame.getFrameID().getName(), t);
            }
        }
    }

    public synchronized void flushCache() {
        if (cacheLog.isLoggable(Level.FINE)) {
            cacheLog.fine("Flushing client cache");
        }
        this.frameNameToFrameMap.clear();
        for (DeferredOperationCache c : this.cacheMap.values()) {
            c.flush();
        }
    }

    public Object executeProtegeJob(ProtegeJob job) throws ProtegeException {
        try {
            Object result = this.getRemoteDelegate().executeProtegeJob(job, this.session);
            LocalizeUtils.localize(result, this.kb);
            return result;
        }
        catch (RemoteException remote) {
            throw new ProtegeIOException(remote);
        }
    }

    public Set<Operation> getAllowedOperations() throws ProtegeIOException {
        if (this.allowedOps == null) {
            try {
                this.allowedOps = this.getRemoteDelegate().getAllowedOperations(this.session);
            }
            catch (RemoteException e) {
                throw new ProtegeIOException(e);
            }
        }
        return this.allowedOps;
    }

    public Set<Operation> getKnownOperations() throws ProtegeIOException {
        if (this.knownOps == null) {
            try {
                this.knownOps = this.getRemoteDelegate().getKnownOperations(this.session);
            }
            catch (RemoteException re) {
                throw new ProtegeIOException(re);
            }
        }
        return this.knownOps;
    }

    public static boolean isOperationAllowed(KnowledgeBase kb, Operation op) throws ProtegeIOException {
        DefaultKnowledgeBase dkb = (DefaultKnowledgeBase)kb;
        FrameStore terminalFS = dkb.getTerminalFrameStore();
        if (!(terminalFS instanceof RemoteClientFrameStore)) {
            return true;
        }
        RemoteClientFrameStore remoteFS = (RemoteClientFrameStore)terminalFS;
        return !remoteFS.getKnownOperations().contains(op) || remoteFS.getAllowedOperations().contains(op);
    }

    public RemoteServer getRemoteServer() {
        return this.server;
    }

    public RemoteSession getSession() {
        return this.session;
    }

    @Override
    public void replaceFrame(Frame original, Frame replacement) {
        try {
            OntologyUpdate vu = this.getRemoteDelegate().replaceFrame(original, replacement, this.session);
            this.processValueUpdate(vu);
            DeferredOperationCache replacementCache = this.cacheMap.get(replacement);
            if (replacementCache != null) {
                replacementCache.invalidate(this.session);
            }
        }
        catch (RemoteException e) {
            throw RemoteClientFrameStore.convertException(e);
        }
    }

    static {
        try {
            executeProtegeJobMethod = RemoteServerFrameStore.class.getDeclaredMethod("executeProtegeJob", ProtegeJob.class, RemoteSession.class);
        }
        catch (NoSuchMethodException nsme) {
            Log.getLogger().log(Level.SEVERE, "No such method ", nsme);
        }
    }

    public class RemoteClientStatsImpl
    implements RemoteClientStats {
        int miss = 0;
        int hit = 0;
        int closureMiss = 0;
        int closureHit = 0;

        public int getCacheHits() {
            return this.hit;
        }

        public int getCacheMisses() {
            return this.miss;
        }

        public int getClosureCacheHits() {
            return this.closureHit;
        }

        public int getClosureCacheMisses() {
            return this.closureMiss;
        }
    }
}

