/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.server.framestore;

import edu.stanford.smi.protege.event.ClsEvent;
import edu.stanford.smi.protege.event.FrameEvent;
import edu.stanford.smi.protege.event.KnowledgeBaseEvent;
import edu.stanford.smi.protege.exception.ProtegeException;
import edu.stanford.smi.protege.exception.TransactionException;
import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.DefaultKnowledgeBase;
import edu.stanford.smi.protege.model.Facet;
import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.model.FrameID;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.Reference;
import edu.stanford.smi.protege.model.SimpleInstance;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.model.framestore.FrameStore;
import edu.stanford.smi.protege.model.framestore.FrameStoreManager;
import edu.stanford.smi.protege.model.framestore.Sft;
import edu.stanford.smi.protege.model.query.Query;
import edu.stanford.smi.protege.model.query.SynchronizeQueryCallback;
import edu.stanford.smi.protege.server.RemoteSession;
import edu.stanford.smi.protege.server.Server;
import edu.stanford.smi.protege.server.ServerProperties;
import edu.stanford.smi.protege.server.framestore.FrameCalculatorFrameStore;
import edu.stanford.smi.protege.server.framestore.LastUsageInvocationHandler;
import edu.stanford.smi.protege.server.framestore.ReadAccessEnforcementFrameStore;
import edu.stanford.smi.protege.server.framestore.Registration;
import edu.stanford.smi.protege.server.framestore.RemoteServerFrameStore;
import edu.stanford.smi.protege.server.framestore.ServerSessionLost;
import edu.stanford.smi.protege.server.framestore.background.CacheRequestReason;
import edu.stanford.smi.protege.server.framestore.background.FrameCalculator;
import edu.stanford.smi.protege.server.framestore.background.FrameCalculatorStats;
import edu.stanford.smi.protege.server.framestore.background.WorkInfo;
import edu.stanford.smi.protege.server.metaproject.Operation;
import edu.stanford.smi.protege.server.metaproject.Policy;
import edu.stanford.smi.protege.server.metaproject.ProjectInstance;
import edu.stanford.smi.protege.server.metaproject.User;
import edu.stanford.smi.protege.server.metaproject.impl.UnbackedOperationImpl;
import edu.stanford.smi.protege.server.socket.RmiSocketFactory;
import edu.stanford.smi.protege.server.socket.SSLFactory;
import edu.stanford.smi.protege.server.update.OntologyUpdate;
import edu.stanford.smi.protege.server.update.RemoteResponse;
import edu.stanford.smi.protege.server.update.ValueUpdate;
import edu.stanford.smi.protege.server.util.FifoReader;
import edu.stanford.smi.protege.server.util.FifoWriter;
import edu.stanford.smi.protege.util.AbstractEvent;
import edu.stanford.smi.protege.util.LocalizeUtils;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protege.util.ProtegeJob;
import edu.stanford.smi.protege.util.transaction.TransactionIsolationLevel;
import edu.stanford.smi.protege.util.transaction.TransactionMonitor;
import edu.stanford.smi.protege.util.transaction.cache.CacheResult;
import edu.stanford.smi.protege.util.transaction.cache.impl.CompleteableCache;
import edu.stanford.smi.protege.util.transaction.cache.serialize.CacheBeginTransaction;
import edu.stanford.smi.protege.util.transaction.cache.serialize.CacheCommitTransaction;
import edu.stanford.smi.protege.util.transaction.cache.serialize.CacheDelete;
import edu.stanford.smi.protege.util.transaction.cache.serialize.CacheModify;
import edu.stanford.smi.protege.util.transaction.cache.serialize.CacheRead;
import edu.stanford.smi.protege.util.transaction.cache.serialize.CacheRollbackTransaction;
import edu.stanford.smi.protege.util.transaction.cache.serialize.SerializedCacheUpdate;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServerFrameStore
extends UnicastRemoteObject
implements RemoteServerFrameStore {
    private static final long serialVersionUID = 2965578539383364549L;
    private static transient Logger log = Log.getLogger(ServerFrameStore.class);
    public static final transient Logger cacheLog = Logger.getLogger(CompleteableCache.class.getPackage().getName() + ".ClientServer");
    private final FrameStore _delegate;
    private final KnowledgeBase _kb;
    private final TransactionMonitor transactionMonitor;
    private ProjectInstance projectInstance;
    private final FifoWriter<AbstractEvent> _eventWriter = new FifoWriter();
    private final Map<RemoteSession, Registration> _sessionToRegistrationMap;
    private boolean _isDirty;
    private final Object _kbLock;
    private final Facet valuesFacet;
    private static Map<Thread, RemoteSession> sessionMap = new HashMap<Thread, RemoteSession>();
    private final FrameCalculator frameCalculator;
    private static Set<KnowledgeBase> requiresEventDispatch = new HashSet<KnowledgeBase>();
    private final Set<Thread> runningClientThreads;

    public ServerFrameStore(KnowledgeBase kb) throws RemoteException {
        super(SSLFactory.getServerPort(SSLFactory.Context.ALWAYS), new RmiSocketFactory(SSLFactory.Context.ALWAYS), new RmiSocketFactory(SSLFactory.Context.ALWAYS));
        this._eventWriter.setLogger(cacheLog, "New Event");
        this._sessionToRegistrationMap = new HashMap<RemoteSession, Registration>();
        this.runningClientThreads = new HashSet<Thread>();
        this._kb = kb;
        this._kbLock = kb;
        FrameStoreManager fsm = ((DefaultKnowledgeBase)kb).getFrameStoreManager();
        if (!requiresEventDispatch.contains(kb)) {
            kb.setDispatchEventsEnabled(false);
        } else {
            kb.getFrameStoreManager().setDispatchEventsPassThrough(true);
            requiresEventDispatch.remove(kb);
        }
        this.valuesFacet = this._kb.getSystemFrames().getValuesFacet();
        this.frameCalculator = new FrameCalculator(fsm.getHeadFrameStore(), ((DefaultKnowledgeBase)this._kb).getCacheMachine(), this._kbLock, this, this._sessionToRegistrationMap);
        fsm.insertFrameStore(new FrameCalculatorFrameStore(this.frameCalculator), 1);
        this._delegate = fsm.getHeadFrameStore();
        this.transactionMonitor = this._delegate.getTransactionStatusMonitor();
        if (ServerProperties.delayInMilliseconds() != 0) {
            Log.getLogger().config("Simulated delay of " + ServerProperties.delayInMilliseconds() + " msec/call");
        }
        this.startHeartbeatThread(this._kb.toString());
    }

    public static void requestEventDispatch(KnowledgeBase kb) {
        kb.setDispatchEventsEnabled(true);
        kb.getFrameStoreManager().setDispatchEventsPassThrough(true);
        requiresEventDispatch.add(kb);
    }

    private void startHeartbeatThread(String name) {
        if (!ServerProperties.heartbeatDisabled()) {
            new Thread("Heartbeat checker [" + name + "]"){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                public void run() {
                    try {
                        while (true) {
                            Thread.sleep(3000L);
                            long now = System.currentTimeMillis();
                            Object object = ServerFrameStore.this._kbLock;
                            synchronized (object) {
                                for (Map.Entry entry : ServerFrameStore.this._sessionToRegistrationMap.entrySet()) {
                                    Registration registration = (Registration)entry.getValue();
                                    long lastHeartbeat = registration.getLastHeartbeat();
                                    if (lastHeartbeat == 0L || lastHeartbeat > now - 24000L) continue;
                                    RemoteSession session = (RemoteSession)entry.getKey();
                                    Log.getLogger().info("Session disconnected because of timeout");
                                    ServerFrameStore.this.deregister(session);
                                }
                            }
                        }
                    }
                    catch (Exception e) {
                        Log.getLogger().log(Level.WARNING, "Heartbeat thread died", e);
                        return;
                    }
                }
            }.start();
        }
    }

    @Override
    public Map<RemoteSession, Boolean> getUserInfo() {
        HashMap<RemoteSession, Boolean> results = new HashMap<RemoteSession, Boolean>();
        for (RemoteSession session : this._sessionToRegistrationMap.keySet()) {
            if (this.transactionMonitor != null) {
                results.put(session, this.transactionMonitor.getNesting(session) > 0);
                continue;
            }
            results.put(session, Boolean.FALSE);
        }
        return results;
    }

    @Override
    public FrameCalculatorStats getStats() {
        return this.frameCalculator.getStats();
    }

    private FrameStore getDelegate() {
        return this._delegate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recordCall(RemoteSession session) throws ServerSessionLost {
        Object object = sessionMap;
        synchronized (object) {
            if (!this._sessionToRegistrationMap.containsKey(session)) {
                throw new ServerSessionLost("Dropped connection due to timeout");
            }
        }
        ServerFrameStore.recordCallNoCheck(session);
        object = this.runningClientThreads;
        synchronized (object) {
            this.runningClientThreads.add(Thread.currentThread());
        }
    }

    public static void recordCallNoCheck(RemoteSession session) {
        ServerFrameStore.setCurrentSession(session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unrecordCall() {
        Set<Thread> set = this.runningClientThreads;
        synchronized (set) {
            this.runningClientThreads.remove(Thread.currentThread());
            if (this.runningClientThreads.isEmpty()) {
                this.runningClientThreads.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void letOtherThreadsRun() {
        Set<Thread> set = this.runningClientThreads;
        synchronized (set) {
            while (!this.runningClientThreads.isEmpty()) {
                try {
                    if (log.isLoggable(Level.FINE)) {
                        log.fine("waitig on threads " + this.runningClientThreads);
                    }
                    this.runningClientThreads.wait();
                }
                catch (InterruptedException e) {
                    log.log(Level.WARNING, "Unexpected Interrupt - please don't press that red button again", e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setCurrentSession(RemoteSession session) {
        Map<Thread, RemoteSession> map = sessionMap;
        synchronized (map) {
            sessionMap.put(Thread.currentThread(), session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RemoteSession getCurrentSession() {
        Map<Thread, RemoteSession> map = sessionMap;
        synchronized (map) {
            return sessionMap.get(Thread.currentThread());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getClsCount(RemoteSession session) throws ServerSessionLost {
        this.recordCall(session);
        try {
            Object object = this._kbLock;
            synchronized (object) {
                int n = this.getDelegate().getClsCount();
                return n;
            }
        }
        finally {
            this.unrecordCall();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getSlotCount(RemoteSession session) throws ServerSessionLost {
        this.recordCall(session);
        try {
            Object object = this._kbLock;
            synchronized (object) {
                int n = this.getDelegate().getSlotCount();
                return n;
            }
        }
        finally {
            this.unrecordCall();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getFacetCount(RemoteSession session) throws ServerSessionLost {
        this.recordCall(session);
        try {
            Object object = this._kbLock;
            synchronized (object) {
                int n = this.getDelegate().getFacetCount();
                return n;
            }
        }
        finally {
            this.unrecordCall();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getSimpleInstanceCount(RemoteSession session) throws ServerSessionLost {
        this.recordCall(session);
        try {
            Object object = this._kbLock;
            synchronized (object) {
                int n = this.getDelegate().getSimpleInstanceCount();
                return n;
            }
        }
        finally {
            this.unrecordCall();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getFrameCount(RemoteSession session) throws ServerSessionLost {
        this.recordCall(session);
        try {
            Object object = this._kbLock;
            synchronized (object) {
                int n = this.getDelegate().getFrameCount();
                return n;
            }
        }
        finally {
            this.unrecordCall();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OntologyUpdate removeDirectTemplateSlot(Cls cls, Slot slot, RemoteSession session) throws ServerSessionLost {
        this.recordCall(session);
        try {
            Object object = this._kbLock;
            synchronized (object) {
                this.getDelegate().removeDirectTemplateSlot(cls, slot);
                this.markDirty();
                OntologyUpdate ontologyUpdate = new OntologyUpdate(this.getValueUpdates(session));
                return ontologyUpdate;
            }
        }
        finally {
            this.unrecordCall();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OntologyUpdate moveDirectTemplateSlot(Cls cls, Slot slot, int index, RemoteSession session) throws ServerSessionLost {
        this.recordCall(session);
        try {
            Object object = this._kbLock;
            synchronized (object) {
                this.getDelegate().moveDirectTemplateSlot(cls, slot, index);
                this.markDirty();
                OntologyUpdate ontologyUpdate = new OntologyUpdate(this.getValueUpdates(session));
                return ontologyUpdate;
            }
        }
        finally {
            this.unrecordCall();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OntologyUpdate addDirectSuperclass(Cls cls, Cls superclass, RemoteSession session) throws ServerSessionLost {
        this.recordCall(session);
        try {
            Object object = this._kbLock;
            synchronized (object) {
                this.getDelegate().addDirectSuperclass(cls, superclass);
                this.markDirty();
                OntologyUpdate ontologyUpdate = new OntologyUpdate(this.getValueUpdates(session));
                return ontologyUpdate;
            }
        }
        finally {
            this.unrecordCall();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OntologyUpdate removeDirectSuperslot(Slot slot, Slot superslot, RemoteSession session) throws ServerSessionLost {
        this.recordCall(session);
        try {
            Object object = this._kbLock;
            synchronized (object) {
                this.getDelegate().removeDirectSuperslot(slot, superslot);
                this.markDirty();
                OntologyUpdate ontologyUpdate = new OntologyUpdate(this.getValueUpdates(session));
                return ontologyUpdate;
            }
        }
        finally {
            this.unrecordCall();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OntologyUpdate removeDirectSuperclass(Cls cls, Cls superclass, RemoteSession session) throws ServerSessionLost {
        this.recordCall(session);
        try {
            Object object = this._kbLock;
            synchronized (object) {
                this.getDelegate().removeDirectSuperclass(cls, superclass);
                this.markDirty();
                OntologyUpdate ontologyUpdate = new OntologyUpdate(this.getValueUpdates(session));
                return ontologyUpdate;
            }
        }
        finally {
            this.unrecordCall();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OntologyUpdate moveDirectSubclass(Cls cls, Cls subclass, int index, RemoteSession session) throws ServerSessionLost {
        this.recordCall(session);
        try {
            Object object = this._kbLock;
            synchronized (object) {
                this.getDelegate().moveDirectSubclass(cls, subclass, index);
                this.markDirty();
                OntologyUpdate ontologyUpdate = new OntologyUpdate(this.getValueUpdates(session));
                return ontologyUpdate;
            }
        }
        finally {
            this.unrecordCall();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OntologyUpdate replaceFrame(Frame original, Frame replacement, RemoteSession session) throws ServerSessionLost {
        this.recordCall(session);
        try {
            Object object = this._kbLock;
            synchronized (object) {
                Set<Reference> references = this.getDelegate().getReferences(original);
                this.getDelegate().replaceFrame(original, replacement);
                this.markDirty();
                this.wipeReferencingFrames(original, references, session);
                OntologyUpdate ontologyUpdate = new OntologyUpdate(this.getValueUpdates(session));
                return ontologyUpdate;
            }
        }
        finally {
            this.unrecordCall();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RemoteResponse<List> getDirectTemplateSlotValues(Cls cls, Slot slot, RemoteSession session) throws ServerSessionLost {
        this.recordCall(session);
        try {
            LocalizeUtils.localize(cls, this._kb);
            Object object = this._kbLock;
            synchronized (object) {
                List values = this.getDelegate().getDirectTemplateSlotValues(cls, slot);
                Sft sft = new Sft(slot, null, true);
                CacheResult<List> cacheValues = new CacheResult<List>(values, true);
                this.addReadUpdate(session, cls, new CacheRead<RemoteSession, Sft, List>(session, sft, cacheValues));
                RemoteResponse<List> remoteResponse = new RemoteResponse<List>(values, this.getValueUpdates(session));
                return remoteResponse;
            }
        }
        finally {
            this.unrecordCall();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RemoteResponse<Set<Instance>> getInstances(Cls cls, RemoteSession session) throws ServerSessionLost {
        this.recordCall(session);
        try {
            Object object = this._kbLock;
            synchronized (object) {
                Set<Instance> instances = this.getDelegate().getInstances(cls);
                RemoteResponse<Set<Instance>> remoteResponse = new RemoteResponse<Set<Instance>>(instances, this.getValueUpdates(session));
                return remoteResponse;
            }
        }
        finally {
            this.unrecordCall();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<Slot> getOwnSlots(Frame frame, RemoteSession session) throws ServerSessionLost {
        this.recordCall(session);
        try {
            Object object = this._kbLock;
            synchronized (object) {
                Set<Slot> set = this.getDelegate().getOwnSlots(frame);
                return set;
            }
        }
        finally {
            this.unrecordCall();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized Set<Frame> getFramesWithDirectOwnSlotValue(Slot slot, Object value, RemoteSession session) throws ServerSessionLost {
        this.recordCall(session);
        try {
            Object object = this._kbLock;
            synchronized (object) {
                Set<Frame> set = this.getDelegate().getFramesWithDirectOwnSlotValue(slot, value);
                return set;
            }
        }
        finally {
            this.unrecordCall();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set getClsesWithDirectTemplateSlotValue(Slot slot, Object value, RemoteSession session) throws ServerSessionLost {
        this.recordCall(session);
        try {
            Object object = this._kbLock;
            synchronized (object) {
                Set set = this.getDelegate().getClsesWithDirectTemplateSlotValue(slot, value);
                return set;
            }
        }
        finally {
            this.unrecordCall();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set getClsesWithDirectTemplateFacetValue(Slot slot, Facet facet, Object value, RemoteSession session) throws ServerSessionLost {
        this.recordCall(session);
        try {
            Object object = this._kbLock;
            synchronized (object) {
                Set set = this.getDelegate().getClsesWithDirectTemplateFacetValue(slot, facet, value);
                return set;
            }
        }
        finally {
            this.unrecordCall();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<Frame> getFramesWithMatchingDirectOwnSlotValue(Slot slot, String value, int maxMatches, RemoteSession session) throws ServerSessionLost {
        this.recordCall(session);
        try {
            Object object = this._kbLock;
            synchronized (object) {
                Set<Frame> set = this.getDelegate().getFramesWithMatchingDirectOwnSlotValue(slot, value, maxMatches);
                return set;
            }
        }
        finally {
            this.unrecordCall();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set getClsesWithMatchingDirectTemplateFacetValue(Slot slot, Facet facet, String value, int maxMatches, RemoteSession session) throws ServerSessionLost {
        this.recordCall(session);
        try {
            Object object = this._kbLock;
            synchronized (object) {
                Set set = this.getDelegate().getClsesWithMatchingDirectTemplateFacetValue(slot, facet, value, maxMatches);
                return set;
            }
        }
        finally {
            this.unrecordCall();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set getClsesWithMatchingDirectTemplateSlotValue(Slot slot, String value, int maxMatches, RemoteSession session) throws ServerSessionLost {
        this.recordCall(session);
        try {
            Object object = this._kbLock;
            synchronized (object) {
                Set set = this.getDelegate().getClsesWithMatchingDirectTemplateSlotValue(slot, value, maxMatches);
                return set;
            }
        }
        finally {
            this.unrecordCall();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RemoteResponse<List> getDirectTemplateFacetValues(Cls cls, Slot slot, Facet facet, RemoteSession session) throws ServerSessionLost {
        this.recordCall(session);
        try {
            LocalizeUtils.localize(cls, this._kb);
            Object object = this._kbLock;
            synchronized (object) {
                List values = this.getDelegate().getDirectTemplateFacetValues(cls, slot, facet);
                Sft sft = new Sft(slot, facet, true);
                CacheResult<List> cacheValues = new CacheResult<List>(values, true);
                this.addReadUpdate(session, cls, new CacheRead<RemoteSession, Sft, List>(session, sft, cacheValues));
                RemoteResponse<List> remoteResponse = new RemoteResponse<List>(values, this.getValueUpdates(session));
                return remoteResponse;
            }
        }
        finally {
            this.unrecordCall();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<Cls> getClses(RemoteSession session) throws ServerSessionLost {
        this.recordCall(session);
        try {
            Object object = this._kbLock;
            synchronized (object) {
                Set<Cls> set = this.getDelegate().getClses();
                return set;
            }
        }
        finally {
            this.unrecordCall();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<Facet> getTemplateFacets(Cls cls, Slot slot, RemoteSession session) throws ServerSessionLost {
        this.recordCall(session);
        try {
            Object object = this._kbLock;
            synchronized (object) {
                Set<Facet> set = this.getDelegate().getTemplateFacets(cls, slot);
                return set;
            }
        }
        finally {
            this.unrecordCall();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RemoteResponse<Frame> getFrame(String name, RemoteSession session) throws ServerSessionLost {
        this.recordCall(session);
        try {
            Object object = this._kbLock;
            synchronized (object) {
                Frame frame = this.getDelegate().getFrame(name);
                RemoteResponse<Frame> remoteResponse = new RemoteResponse<Frame>(frame, this.getValueUpdates(session));
                return remoteResponse;
            }
        }
        finally {
            this.unrecordCall();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Frame getFrame(FrameID id, RemoteSession session) throws ServerSessionLost {
        this.recordCall(session);
        try {
            Object object = this._kbLock;
            synchronized (object) {
                Frame frame = this.getDelegate().getFrame(id);
                return frame;
            }
        }
        finally {
            this.unrecordCall();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getDirectOwnSlotValuesCount(Frame frame, Slot slot, RemoteSession session) throws ServerSessionLost {
        this.recordCall(session);
        try {
            LocalizeUtils.localize(frame, this._kb);
            Object object = this._kbLock;
            synchronized (object) {
                int n = this.getDelegate().getDirectOwnSlotValuesCount(frame, slot);
                return n;
            }
        }
        finally {
            this.unrecordCall();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RemoteResponse<List> getDirectOwnSlotValues(Frame frame, Slot slot, RemoteSession session) throws ServerSessionLost {
        this.recordCall(session);
        try {
            if (log.isLoggable(Level.FINE)) {
                log.fine("getDirectOwnSlotValues for frame " + frame.getFrameID() + " slot " + slot.getFrameID());
            }
            LocalizeUtils.localize(frame, this._kb);
            LocalizeUtils.localize(slot, this._kb);
            Object object = this._kbLock;
            synchronized (object) {
                List values = this.getDelegate().getDirectOwnSlotValues(frame, slot);
                Sft sft = new Sft(slot, null, false);
                CacheResult<List> cacheValues = new CacheResult<List>(values, true);
                this.addReadUpdate(session, frame, new CacheRead<RemoteSession, Sft, List>(session, sft, cacheValues));
                RemoteResponse<List> remoteResponse = new RemoteResponse<List>(values, this.getValueUpdates(session));
                return remoteResponse;
            }
        }
        finally {
            this.unrecordCall();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OntologyUpdate setDirectTemplateFacetValues(Cls cls, Slot slot, Facet facet, Collection values, RemoteSession session) throws ServerSessionLost {
        this.recordCall(session);
        try {
            Object object = this._kbLock;
            synchronized (object) {
                if (!(values instanceof List)) {
                    values = new ArrayList(values);
                }
                this.getDelegate().setDirectTemplateFacetValues(cls, slot, facet, values);
                this.markDirty();
                Sft sft = new Sft(slot, facet, true);
                CacheResult<List> cacheValues = new CacheResult<List>(values, true);
                this.addWriteUpdate(session, cls, new CacheModify<RemoteSession, Sft, List>(session, sft, cacheValues));
                OntologyUpdate ontologyUpdate = new OntologyUpdate(this.getValueUpdates(session));
                return ontologyUpdate;
            }
        }
        finally {
            this.unrecordCall();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RemoteResponse<Facet> createFacet(FrameID id, Collection directTypes, boolean loadDefaults, RemoteSession session) throws ServerSessionLost {
        this.recordCall(session);
        try {
            Object object = this._kbLock;
            synchronized (object) {
                this.markDirty();
                Facet facet = this.getDelegate().createFacet(id, directTypes, loadDefaults);
                RemoteResponse<Facet> remoteResponse = new RemoteResponse<Facet>(facet, this.getValueUpdates(session));
                return remoteResponse;
            }
        }
        finally {
            this.unrecordCall();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<Frame> getFrames(RemoteSession session) throws ServerSessionLost {
        this.recordCall(session);
        try {
            Object object = this._kbLock;
            synchronized (object) {
                Set<Frame> set = this.getDelegate().getFrames();
                return set;
            }
        }
        finally {
            this.unrecordCall();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OntologyUpdate setDirectTemplateSlotValues(Cls cls, Slot slot, Collection values, RemoteSession session) throws ServerSessionLost {
        this.recordCall(session);
        try {
            if (!(values instanceof List)) {
                values = new ArrayList(values);
            }
            Object object = this._kbLock;
            synchronized (object) {
                this.markDirty();
                this.getDelegate().setDirectTemplateSlotValues(cls, slot, values);
                Sft sft = new Sft(slot, null, true);
                CacheResult<List> cacheValues = new CacheResult<List>(values, true);
                this.addWriteUpdate(session, cls, new CacheModify<RemoteSession, Sft, List>(session, sft, cacheValues));
                OntologyUpdate ontologyUpdate = new OntologyUpdate(this.getValueUpdates(session));
                return ontologyUpdate;
            }
        }
        finally {
            this.unrecordCall();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection getTemplateFacetValues(Cls cls, Slot slot, Facet facet, RemoteSession session) throws ServerSessionLost {
        this.recordCall(session);
        try {
            Object object = this._kbLock;
            synchronized (object) {
                Collection collection = this.getDelegate().getTemplateFacetValues(cls, slot, facet);
                return collection;
            }
        }
        finally {
            this.unrecordCall();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OntologyUpdate deleteCls(Cls cls, RemoteSession session) throws ServerSessionLost {
        this.recordCall(session);
        try {
            Object object = this._kbLock;
            synchronized (object) {
                this.getDelegate().deleteCls(cls);
                this.markDirty();
                OntologyUpdate ontologyUpdate = new OntologyUpdate(this.getValueUpdates(session));
                return ontologyUpdate;
            }
        }
        finally {
            this.unrecordCall();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OntologyUpdate deleteSlot(Slot slot, RemoteSession session) throws ServerSessionLost {
        this.recordCall(session);
        try {
            Object object = this._kbLock;
            synchronized (object) {
                this.getDelegate().deleteSlot(slot);
                this.markDirty();
                OntologyUpdate ontologyUpdate = new OntologyUpdate(this.getValueUpdates(session));
                return ontologyUpdate;
            }
        }
        finally {
            this.unrecordCall();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OntologyUpdate deleteFacet(Facet facet, RemoteSession session) throws ServerSessionLost {
        this.recordCall(session);
        try {
            Object object = this._kbLock;
            synchronized (object) {
                this.getDelegate().deleteFacet(facet);
                this.markDirty();
                OntologyUpdate ontologyUpdate = new OntologyUpdate(this.getValueUpdates(session));
                return ontologyUpdate;
            }
        }
        finally {
            this.unrecordCall();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OntologyUpdate deleteSimpleInstance(SimpleInstance simpleInstance, RemoteSession session) throws ServerSessionLost {
        this.recordCall(session);
        try {
            Object object = this._kbLock;
            synchronized (object) {
                this.getDelegate().deleteSimpleInstance(simpleInstance);
                this.markDirty();
                OntologyUpdate ontologyUpdate = new OntologyUpdate(this.getValueUpdates(session));
                return ontologyUpdate;
            }
        }
        finally {
            this.unrecordCall();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RemoteResponse<Slot> createSlot(FrameID id, Collection directTypes, Collection directSuperslots, boolean loadDefaults, RemoteSession session) throws ServerSessionLost {
        this.recordCall(session);
        try {
            Object object = this._kbLock;
            synchronized (object) {
                this.markDirty();
                Slot slot = this.getDelegate().createSlot(id, directTypes, directSuperslots, loadDefaults);
                RemoteResponse<Slot> remoteResponse = new RemoteResponse<Slot>(slot, this.getValueUpdates(session));
                return remoteResponse;
            }
        }
        finally {
            this.unrecordCall();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OntologyUpdate addDirectSuperslot(Slot slot, Slot superslot, RemoteSession session) throws ServerSessionLost {
        this.recordCall(session);
        try {
            Object object = this._kbLock;
            synchronized (object) {
                this.getDelegate().addDirectSuperslot(slot, superslot);
                this.markDirty();
                OntologyUpdate ontologyUpdate = new OntologyUpdate(this.getValueUpdates(session));
                return ontologyUpdate;
            }
        }
        finally {
            this.unrecordCall();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OntologyUpdate addDirectTemplateSlot(Cls cls, Slot slot, RemoteSession session) throws ServerSessionLost {
        this.recordCall(session);
        try {
            Object object = this._kbLock;
            synchronized (object) {
                this.getDelegate().addDirectTemplateSlot(cls, slot);
                this.markDirty();
                OntologyUpdate ontologyUpdate = new OntologyUpdate(this.getValueUpdates(session));
                return ontologyUpdate;
            }
        }
        finally {
            this.unrecordCall();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OntologyUpdate moveDirectOwnSlotValue(Frame frame, Slot slot, int from, int to, RemoteSession session) throws ServerSessionLost {
        this.recordCall(session);
        try {
            Object object = this._kbLock;
            synchronized (object) {
                this.getDelegate().moveDirectOwnSlotValue(frame, slot, from, to);
                this.markDirty();
                OntologyUpdate ontologyUpdate = new OntologyUpdate(this.getValueUpdates(session));
                return ontologyUpdate;
            }
        }
        finally {
            this.unrecordCall();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OntologyUpdate setDirectOwnSlotValues(Frame frame, Slot slot, Collection values, RemoteSession session) throws ServerSessionLost {
        this.recordCall(session);
        try {
            if (!(values instanceof List)) {
                values = new ArrayList(values);
            }
            Object object = this._kbLock;
            synchronized (object) {
                this.getDelegate().setDirectOwnSlotValues(frame, slot, values);
                this.markDirty();
                Sft sft = new Sft(slot, null, true);
                CacheResult<List> cacheValues = new CacheResult<List>(values, true);
                this.addReadUpdate(session, frame, new CacheModify<RemoteSession, Sft, List>(session, sft, cacheValues));
                OntologyUpdate ontologyUpdate = new OntologyUpdate(this.getValueUpdates(session));
                return ontologyUpdate;
            }
        }
        finally {
            this.unrecordCall();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RemoteResponse<Cls> createCls(FrameID id, Collection directTypes, Collection directSuperclasses, boolean loadDefaults, RemoteSession session) throws ServerSessionLost {
        this.recordCall(session);
        try {
            Object object = this._kbLock;
            synchronized (object) {
                this.markDirty();
                Cls cls = this.getDelegate().createCls(id, directTypes, directSuperclasses, loadDefaults);
                RemoteResponse<Cls> remoteResponse = new RemoteResponse<Cls>(cls, this.getValueUpdates(session));
                return remoteResponse;
            }
        }
        finally {
            this.unrecordCall();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<Facet> getFacets(RemoteSession session) throws ServerSessionLost {
        this.recordCall(session);
        try {
            Object object = this._kbLock;
            synchronized (object) {
                Set<Facet> set = this.getDelegate().getFacets();
                return set;
            }
        }
        finally {
            this.unrecordCall();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RemoteResponse<Collection<Frame>> executeQuery(Query query, RemoteSession session) throws ProtegeException, ServerSessionLost {
        this.recordCall(session);
        try {
            SynchronizeQueryCallback callback = new SynchronizeQueryCallback(this._kbLock);
            RemoteResponse<Collection<Frame>> remoteResponse = this._kbLock;
            synchronized (remoteResponse) {
                this.getDelegate().executeQuery(query, callback);
            }
            remoteResponse = new RemoteResponse<Collection<Frame>>(callback.waitForResults(), this.getValueUpdates(session));
            return remoteResponse;
        }
        finally {
            this.unrecordCall();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OntologyUpdate removeDirectType(Instance instance, Cls directType, RemoteSession session) throws ServerSessionLost {
        this.recordCall(session);
        try {
            Object object = this._kbLock;
            synchronized (object) {
                this.getDelegate().removeDirectType(instance, directType);
                this.markDirty();
                OntologyUpdate ontologyUpdate = new OntologyUpdate(this.getValueUpdates(session));
                return ontologyUpdate;
            }
        }
        finally {
            this.unrecordCall();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<Reference> getReferences(Object value, RemoteSession session) throws ServerSessionLost {
        this.recordCall(session);
        try {
            Object object = this._kbLock;
            synchronized (object) {
                Set<Reference> set = this.getDelegate().getReferences(value);
                return set;
            }
        }
        finally {
            this.unrecordCall();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<Reference> getMatchingReferences(String value, int maxMatches, RemoteSession session) throws ServerSessionLost {
        this.recordCall(session);
        try {
            Object object = this._kbLock;
            synchronized (object) {
                Set<Reference> set = this.getDelegate().getMatchingReferences(value, maxMatches);
                return set;
            }
        }
        finally {
            this.unrecordCall();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<Cls> getClsesWithMatchingBrowserText(String value, Collection superclasses, int maxMatches, RemoteSession session) throws ServerSessionLost {
        this.recordCall(session);
        try {
            Object object = this._kbLock;
            synchronized (object) {
                Set<Cls> set = this.getDelegate().getClsesWithMatchingBrowserText(value, superclasses, maxMatches);
                return set;
            }
        }
        finally {
            this.unrecordCall();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RemoteResponse<SimpleInstance> createSimpleInstance(FrameID id, Collection directTypes, boolean loadDefaults, RemoteSession session) throws ServerSessionLost {
        this.recordCall(session);
        try {
            Object object = this._kbLock;
            synchronized (object) {
                this.recordCall(session);
                this.markDirty();
                SimpleInstance si = this.getDelegate().createSimpleInstance(id, directTypes, loadDefaults);
                RemoteResponse<SimpleInstance> remoteResponse = new RemoteResponse<SimpleInstance>(si, this.getValueUpdates(session));
                return remoteResponse;
            }
        }
        finally {
            this.unrecordCall();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OntologyUpdate addDirectType(Instance instance, Cls type, RemoteSession session) throws ServerSessionLost {
        this.recordCall(session);
        try {
            Object object = this._kbLock;
            synchronized (object) {
                this.getDelegate().addDirectType(instance, type);
                this.markDirty();
                OntologyUpdate ontologyUpdate = new OntologyUpdate(this.getValueUpdates(session));
                return ontologyUpdate;
            }
        }
        finally {
            this.unrecordCall();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OntologyUpdate moveDirectType(Instance instance, Cls cls, int index, RemoteSession session) throws ServerSessionLost {
        this.recordCall(session);
        try {
            Object object = this._kbLock;
            synchronized (object) {
                this.getDelegate().moveDirectType(instance, cls, index);
                this.markDirty();
                OntologyUpdate ontologyUpdate = new OntologyUpdate(this.getValueUpdates(session));
                return ontologyUpdate;
            }
        }
        finally {
            this.unrecordCall();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getFrameName(Frame frame, RemoteSession session) throws ServerSessionLost {
        this.recordCall(session);
        try {
            Object object = this._kbLock;
            synchronized (object) {
                String string = this.getDelegate().getFrameName(frame);
                return string;
            }
        }
        finally {
            this.unrecordCall();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set getOverriddenTemplateSlots(Cls cls, RemoteSession session) throws ServerSessionLost {
        this.recordCall(session);
        try {
            Object object = this._kbLock;
            synchronized (object) {
                Set set = this.getDelegate().getOverriddenTemplateSlots(cls);
                return set;
            }
        }
        finally {
            this.unrecordCall();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set getDirectlyOverriddenTemplateSlots(Cls cls, RemoteSession session) throws ServerSessionLost {
        this.recordCall(session);
        try {
            Object object = this._kbLock;
            synchronized (object) {
                Set set = this.getDelegate().getDirectlyOverriddenTemplateSlots(cls);
                return set;
            }
        }
        finally {
            this.unrecordCall();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set getOverriddenTemplateFacets(Cls cls, Slot slot, RemoteSession session) throws ServerSessionLost {
        this.recordCall(session);
        try {
            Object object = this._kbLock;
            synchronized (object) {
                Set set = this.getDelegate().getOverriddenTemplateFacets(cls, slot);
                return set;
            }
        }
        finally {
            this.unrecordCall();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set getDirectlyOverriddenTemplateFacets(Cls cls, Slot slot, RemoteSession session) throws ServerSessionLost {
        this.recordCall(session);
        try {
            Object object = this._kbLock;
            synchronized (object) {
                Set set = this.getDelegate().getOverriddenTemplateFacets(cls, slot);
                return set;
            }
        }
        finally {
            this.unrecordCall();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OntologyUpdate removeDirectTemplateFacetOverrides(Cls cls, Slot slot, RemoteSession session) throws ServerSessionLost {
        this.recordCall(session);
        try {
            Object object = this._kbLock;
            synchronized (object) {
                this.getDelegate().removeDirectTemplateFacetOverrides(cls, slot);
                this.markDirty();
                OntologyUpdate ontologyUpdate = new OntologyUpdate(this.getValueUpdates(session));
                return ontologyUpdate;
            }
        }
        finally {
            this.unrecordCall();
        }
    }

    @Override
    public void close(RemoteSession session) throws ServerSessionLost {
        ServerFrameStore.recordCallNoCheck(session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object executeProtegeJob(ProtegeJob job, RemoteSession session) throws ProtegeException, ServerSessionLost {
        this.recordCall(session);
        try {
            Object object = this._kbLock;
            synchronized (object) {
                job.localize(this._kb);
            }
            object = job.run();
            return object;
        }
        catch (ProtegeException pe) {
            Log.getLogger().log(Level.WARNING, "Exception on remote execution", pe);
            throw pe;
        }
        finally {
            this.unrecordCall();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(RemoteSession session) throws ServerSessionLost {
        Object object = this._kbLock;
        synchronized (object) {
            Registration registration = new Registration(this._eventWriter);
            this._sessionToRegistrationMap.put(session, registration);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deregister(RemoteSession session) throws ServerSessionLost {
        this.recordCall(session);
        try {
            Object object = this._kbLock;
            synchronized (object) {
                while (this.inTransaction()) {
                    this.rollbackTransaction(session);
                }
                this._sessionToRegistrationMap.remove(session);
                this.frameCalculator.deregister(session);
            }
        }
        finally {
            this.unrecordCall();
        }
    }

    @Override
    public String toString() {
        return "ServerFrameStore[" + this._kb + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RemoteResponse<List<AbstractEvent>> getEvents(RemoteSession session) throws ServerSessionLost {
        this.recordCall(session);
        try {
            Object object = this._kbLock;
            synchronized (object) {
                this.updateEvents(session);
                ArrayList<AbstractEvent> events = new ArrayList<AbstractEvent>();
                Registration reg = this._sessionToRegistrationMap.get(session);
                if (reg == null) {
                    throw new IllegalStateException("Not registered");
                }
                FifoReader<AbstractEvent> clientEvents = reg.getEvents();
                AbstractEvent eo = null;
                while ((eo = clientEvents.read()) != null) {
                    events.add(eo);
                }
                RemoteResponse<List<AbstractEvent>> remoteResponse = new RemoteResponse<List<AbstractEvent>>(events, this.getValueUpdates(session));
                return remoteResponse;
            }
        }
        finally {
            this.unrecordCall();
        }
    }

    public void updateEvents(RemoteSession session) {
        Registration registration = this._sessionToRegistrationMap.get(session);
        TransactionIsolationLevel level = this.getTransactionIsolationLevel();
        for (AbstractEvent eo : this.getDelegate().getEvents()) {
            this.addEvent(session, registration, level, eo);
        }
    }

    private void addEvent(RemoteSession session, Registration registration, TransactionIsolationLevel level, AbstractEvent eo) {
        if (log.isLoggable(Level.FINER)) {
            log.finer("Server Processing event " + eo);
        }
        this.processEvent(session, registration, level, eo);
        this._eventWriter.write(eo);
    }

    private List<ValueUpdate> getValueUpdates(RemoteSession session) {
        this.updateEvents(session);
        List<ValueUpdate> ret = this._sessionToRegistrationMap.get(session).getAndClearValueUpdates();
        int size = ret.size();
        if (size != 0) {
            this._sessionToRegistrationMap.get(session).getBandWidthPolicy().addItemsSent(ret.size());
        }
        return ret;
    }

    private void processEvent(RemoteSession session, Registration registration, TransactionIsolationLevel level, AbstractEvent event) {
        if (event.getEventType() != 101 && event.isReplacementEvent()) {
            return;
        }
        if (event instanceof FrameEvent) {
            this.handleFrameEvent(session, (FrameEvent)event);
        } else if (event instanceof ClsEvent) {
            this.handleClsEvent(session, (ClsEvent)event);
        }
        if (event instanceof KnowledgeBaseEvent) {
            this.handleKnowledgeBaseEvent(session, (KnowledgeBaseEvent)event);
        }
    }

    private void handleFrameEvent(RemoteSession session, FrameEvent frameEvent) {
        Frame frame = frameEvent.getFrame();
        int type = frameEvent.getEventType();
        Sft sft = null;
        if (type == 101 || type == 102) {
            if (frame instanceof Slot || frame instanceof Facet) {
                this.addWriteUpdate(session, null, new CacheDelete<RemoteSession, Sft, List>(session));
            } else {
                this.wipeReferencingFrames(frame, this.getDelegate().getReferences(frame), session);
            }
            return;
        }
        if (type == 106) {
            Slot slot = frameEvent.getSlot();
            CacheResult result = CacheResult.getInvalid();
            sft = new Sft(slot, null, false);
            this.addWriteUpdate(session, frame, new CacheModify<RemoteSession, Sft, List>(session, sft, result));
        } else if (type == 110) {
            Slot slot = frameEvent.getSlot();
            CacheResult result = CacheResult.getInvalid();
            sft = new Sft(slot, null, false);
            this.addWriteUpdate(session, frame, new CacheModify<RemoteSession, Sft, List>(session, sft, result));
        } else if (type == 107) {
            Slot slot = frameEvent.getSlot();
            CacheResult result = new CacheResult(new ArrayList(), true);
            sft = new Sft(slot, null, false);
            this.addWriteUpdate(session, frame, new CacheModify<RemoteSession, Sft, List>(session, sft, result));
        }
    }

    private void wipeReferencingFrames(Frame frame, Collection<Reference> references, RemoteSession session) {
        HashSet<Frame> framesToWipe = new HashSet<Frame>();
        framesToWipe.add(frame);
        for (Reference ref : references) {
            framesToWipe.add(ref.getFrame());
        }
        for (Frame f : framesToWipe) {
            this.addWriteUpdate(session, f, new CacheDelete<RemoteSession, Sft, List>(session));
        }
    }

    private void handleClsEvent(RemoteSession session, ClsEvent clsEvent) {
        Slot slot;
        Cls frame = clsEvent.getCls();
        int type = clsEvent.getEventType();
        Sft sft = null;
        if (type == 310) {
            slot = clsEvent.getSlot();
            sft = new Sft(slot, this.valuesFacet, true);
        } else if (type == 311) {
            slot = clsEvent.getSlot();
            Facet facet = clsEvent.getFacet();
            sft = new Sft(slot, facet, false);
        } else if (type == 313) {
            slot = clsEvent.getSlot();
            Facet facet = clsEvent.getFacet();
            sft = new Sft(slot, facet, true);
        }
        if (sft != null) {
            CacheResult result = CacheResult.getInvalid();
            this.addWriteUpdate(session, frame, new CacheModify<RemoteSession, Sft, List>(session, sft, result));
        }
    }

    private void addWriteUpdate(RemoteSession session, Frame frame, SerializedCacheUpdate<RemoteSession, Sft, List> update) {
        ValueUpdate vu = new ValueUpdate(frame, update);
        TransactionIsolationLevel level = this.getTransactionIsolationLevel();
        if (TransactionMonitor.updatesSeenByUntransactedClients(this.transactionMonitor, level)) {
            for (Registration r : this._sessionToRegistrationMap.values()) {
                r.addUpdate(vu);
            }
        } else {
            Registration r = this._sessionToRegistrationMap.get(ServerFrameStore.getCurrentSession());
            r.addUpdate(vu);
            r.addCommittableUpdate(vu);
        }
    }

    public void addReadUpdate(RemoteSession session, Frame frame, SerializedCacheUpdate<RemoteSession, Sft, List> update) {
        Registration r = this._sessionToRegistrationMap.get(ServerFrameStore.getCurrentSession());
        ValueUpdate vu = new ValueUpdate(frame, update);
        r.addUpdate(vu);
    }

    private void handleKnowledgeBaseEvent(RemoteSession session, KnowledgeBaseEvent event) {
        int type = event.getEventType();
        if (type == 601 || type == 603 || type == 605 || type == 607 || type == 602 || type == 604 || type == 606 || type == 608) {
            Frame deletedFrame = event.getFrame();
            this.addWriteUpdate(session, deletedFrame, new CacheDelete<RemoteSession, Sft, List>(session));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RemoteResponse<Boolean> beginTransaction(String name, RemoteSession session) throws ServerSessionLost {
        this.recordCall(session);
        try {
            if (cacheLog.isLoggable(Level.FINE)) {
                cacheLog.fine("Begin Transaction for session " + session);
            }
            Object object = this._kbLock;
            synchronized (object) {
                this.updateEvents(session);
                boolean success = this.getDelegate().beginTransaction(name);
                this.addWriteUpdate(session, null, new CacheBeginTransaction<RemoteSession, Sft, List>(session));
                RemoteResponse<Boolean> remoteResponse = new RemoteResponse<Boolean>(success, this.getValueUpdates(session));
                return remoteResponse;
            }
        }
        finally {
            this.unrecordCall();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RemoteResponse<Boolean> commitTransaction(RemoteSession session) throws ServerSessionLost {
        this.recordCall(session);
        try {
            if (cacheLog.isLoggable(Level.FINE)) {
                cacheLog.fine("Commit Transaction for Session " + session);
            }
            Object object = this._kbLock;
            synchronized (object) {
                this.addWriteUpdate(session, null, new CacheCommitTransaction<RemoteSession, Sft, List>(session));
                boolean success = this.getDelegate().commitTransaction();
                this.updateEvents(session);
                if (!this.inTransaction()) {
                    Registration registration = this._sessionToRegistrationMap.get(session);
                    List<ValueUpdate> committedUpdates = registration.getCommits();
                    for (Registration otherRegistration : this._sessionToRegistrationMap.values()) {
                        if (otherRegistration.equals(registration)) continue;
                        for (ValueUpdate committedUpdate : committedUpdates) {
                            otherRegistration.addUpdate(committedUpdate);
                        }
                    }
                    registration.endTransaction();
                }
                if (!this.existsTransaction()) {
                    this._kbLock.notifyAll();
                }
                RemoteResponse<Boolean> remoteResponse = new RemoteResponse<Boolean>(success, this.getValueUpdates(session));
                return remoteResponse;
            }
        }
        finally {
            this.unrecordCall();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RemoteResponse<Boolean> rollbackTransaction(RemoteSession session) throws ServerSessionLost {
        this.recordCall(session);
        try {
            if (cacheLog.isLoggable(Level.FINE)) {
                cacheLog.fine("Rollback Transaction for session " + session);
            }
            Object object = this._kbLock;
            synchronized (object) {
                this.updateEvents(session);
                this.addWriteUpdate(session, null, new CacheRollbackTransaction<RemoteSession, Sft, List>(session));
                boolean success = this.getDelegate().rollbackTransaction();
                if (!this.inTransaction()) {
                    Registration registration = this._sessionToRegistrationMap.get(session);
                    registration.endTransaction();
                }
                if (!this.existsTransaction()) {
                    this._kbLock.notifyAll();
                }
                RemoteResponse<Boolean> remoteResponse = new RemoteResponse<Boolean>(success, this.getValueUpdates(session));
                return remoteResponse;
            }
        }
        finally {
            this.unrecordCall();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TransactionIsolationLevel getTransactionIsolationLevel() {
        try {
            Object object = this._kbLock;
            synchronized (object) {
                if (this.transactionMonitor == null) {
                    return TransactionIsolationLevel.NONE;
                }
                return this.transactionMonitor.getTransationIsolationLevel();
            }
        }
        catch (TransactionException te) {
            Log.getLogger().log(Level.WARNING, "Exception caught finding transaction isolation level", te);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean setTransactionIsolationLevel(TransactionIsolationLevel level) throws TransactionException {
        Object object = this._kbLock;
        synchronized (object) {
            if (this.transactionMonitor == null) {
                return false;
            }
            this.transactionMonitor.setTransactionIsolationLevel(level);
        }
        return true;
    }

    public boolean inTransaction() {
        return this.transactionMonitor != null && this.transactionMonitor.inTransaction();
    }

    public boolean existsTransaction() {
        return this.transactionMonitor != null && this.transactionMonitor.existsTransaction();
    }

    public boolean exclusiveTransaction() {
        return this.transactionMonitor != null && this.transactionMonitor.exclusiveTransaction();
    }

    public TransactionMonitor getTransactionStatusMonitor() {
        return this.transactionMonitor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForTransactionsToComplete() {
        Object object = this._kbLock;
        synchronized (object) {
            while (this.existsTransaction()) {
                try {
                    this._kbLock.wait();
                }
                catch (InterruptedException e) {
                    log.log(Level.WARNING, "Interrupted waiting for transactions to complete", e);
                }
            }
        }
    }

    public boolean isDirty() {
        return this._isDirty;
    }

    private void markDirty() {
        this._isDirty = true;
    }

    public void markClean() {
        this._isDirty = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OntologyUpdate moveDirectSubslot(Slot slot, Slot subslot, int index, RemoteSession session) throws ServerSessionLost {
        this.recordCall(session);
        try {
            Object object = this._kbLock;
            synchronized (object) {
                this.getDelegate().moveDirectSubslot(slot, subslot, index);
                OntologyUpdate ontologyUpdate = new OntologyUpdate(this.getValueUpdates(session));
                return ontologyUpdate;
            }
        }
        finally {
            this.unrecordCall();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<Frame> getFramesWithAnyDirectOwnSlotValue(Slot slot, RemoteSession session) throws ServerSessionLost {
        this.recordCall(session);
        try {
            Object object = this._kbLock;
            synchronized (object) {
                Set<Frame> set = this.getDelegate().getFramesWithAnyDirectOwnSlotValue(slot);
                return set;
            }
        }
        finally {
            this.unrecordCall();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<Cls> getClsesWithAnyDirectTemplateSlotValue(Slot slot, RemoteSession session) throws ServerSessionLost {
        this.recordCall(session);
        try {
            Object object = this._kbLock;
            synchronized (object) {
                Set<Cls> set = this.getDelegate().getClsesWithAnyDirectTemplateSlotValue(slot);
                return set;
            }
        }
        finally {
            this.unrecordCall();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RemoteResponse<Set> getDirectOwnSlotValuesClosure(Frame frame, Slot slot, Set<Frame> missing, RemoteSession session) throws ServerSessionLost {
        this.recordCall(session);
        try {
            Set values = null;
            RemoteResponse<Set> remoteResponse = this._kbLock;
            synchronized (remoteResponse) {
                values = this.getDelegate().getDirectOwnSlotValuesClosure(frame, slot);
            }
            LocalizeUtils.localize(missing, this._kb);
            if (!this.frameCalculator.isDisabled(session)) {
                for (Frame value : missing) {
                    this.frameCalculator.addRequest(value, session, CacheRequestReason.USER_CLOSURE_REQUEST);
                }
            }
            remoteResponse = new RemoteResponse<Set>(values, this.getValueUpdates(session));
            return remoteResponse;
        }
        finally {
            this.unrecordCall();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RemoteResponse<Set> getDirectOwnSlotValuesClosure(Collection<Frame> frames, Slot slot, Set<Frame> missing, RemoteSession session) throws ServerSessionLost {
        this.recordCall(session);
        try {
            HashSet values = new HashSet();
            RemoteResponse<Set> remoteResponse = this._kbLock;
            synchronized (remoteResponse) {
                for (Frame frame : frames) {
                    Set newValues = this.getDelegate().getDirectOwnSlotValuesClosure(frame, slot);
                    if (newValues == null) continue;
                    values.addAll(newValues);
                }
            }
            LocalizeUtils.localize(missing, this._kb);
            if (!this.frameCalculator.isDisabled(session)) {
                for (Frame value : missing) {
                    this.frameCalculator.addRequest(value, session, CacheRequestReason.USER_CLOSURE_REQUEST);
                }
            }
            remoteResponse = new RemoteResponse<Set>(values, this.getValueUpdates(session));
            return remoteResponse;
        }
        finally {
            this.unrecordCall();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OntologyUpdate preload(Set<String> userFrames, boolean all, RemoteSession session) throws ServerSessionLost {
        this.recordCall(session);
        try {
            if (all) {
                int preloadFrameLimit = ServerProperties.getPreloadFrameLimit();
                int preloaded = 0;
                Object object = this._kbLock;
                synchronized (object) {
                    for (Frame frame : this.getDelegate().getFrames()) {
                        if (++preloaded > preloadFrameLimit) break;
                        this.frameCalculator.addRequest(frame, session, CacheRequestReason.PRELOAD);
                    }
                }
            } else {
                this.addUserFrames(session, userFrames);
                this.addSystemClasses(session);
            }
            OntologyUpdate ontologyUpdate = new OntologyUpdate(this.getValueUpdates(session));
            return ontologyUpdate;
        }
        finally {
            this.unrecordCall();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addSystemClasses(RemoteSession session) {
        LinkedHashSet<Frame> frames = new LinkedHashSet<Frame>();
        frames.addAll(this._kb.getSystemFrames().getFrames());
        if (!this.frameCalculator.isDisabled(session)) {
            for (Frame frame : frames) {
                Object object = this.frameCalculator.getRequestLock();
                synchronized (object) {
                    WorkInfo wi = this.frameCalculator.addRequest(frame, session, CacheRequestReason.PRELOAD);
                    if (wi != null) {
                        wi.setSkipDirectInstances(true);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addSystemClasses(Set<Frame> frames, Cls cls) {
        if (!cls.isSystem() || frames.contains(cls)) {
            return;
        }
        List<Cls> subClasses = null;
        Object object = this._kbLock;
        synchronized (object) {
            subClasses = this._delegate.getDirectSubclasses(cls);
        }
        Set<Slot> slots = null;
        Object object2 = this._kbLock;
        synchronized (object2) {
            slots = this._delegate.getOwnSlots(cls);
            slots.addAll(this._delegate.getTemplateSlots(cls));
        }
        for (Slot slot : slots) {
            if (!slot.isSystem()) continue;
            frames.add(slot);
        }
        for (Cls subclass : subClasses) {
            this.addSystemClasses(frames, subclass);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addUserFrames(RemoteSession session, Set<String> userFrames) {
        HashSet<Frame> frames = new HashSet<Frame>();
        for (String frameName : userFrames) {
            Frame frame = null;
            Object object = this._kbLock;
            synchronized (object) {
                frame = this._delegate.getFrame(frameName);
            }
            if (frame == null) continue;
            frames.add(frame);
            if (!(frame instanceof Cls)) continue;
            Cls cls = (Cls)frame;
            for (Object o : this._kb.getSuperclasses(cls)) {
                Cls superCls = (Cls)o;
                frames.add(superCls);
                frames.addAll(superCls.getDirectSubclasses());
            }
            Object object2 = this._kbLock;
            synchronized (object2) {
                frames.addAll(this._kb.getSuperclasses((Cls)frame));
                frames.addAll(this._kb.getDirectSubclasses((Cls)frame));
            }
        }
        if (!this.frameCalculator.isDisabled(session)) {
            for (Frame frame : frames) {
                this.frameCalculator.addRequest(frame, session, CacheRequestReason.IMMEDIATE_PRELOAD);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void requestValueCache(Set<Frame> frames, boolean skipDirectInstances, RemoteSession session) {
        Object object = this.frameCalculator.getRequestLock();
        synchronized (object) {
            for (Frame frame : frames) {
                LocalizeUtils.localize(frame, this._kb);
                WorkInfo wi = this.frameCalculator.addRequest(frame, session, CacheRequestReason.USER_SPECIFIC_FRAMES);
                if (wi == null) continue;
                wi.setSkipDirectInstances(skipDirectInstances);
            }
        }
    }

    public FrameCalculator getFrameCalculator() {
        return this.frameCalculator;
    }

    public void setFrameCalculatorDisabled(boolean disabled) {
        FrameCalculator.setDisabled(disabled);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void heartBeat(RemoteSession session) throws ServerSessionLost {
        this.recordCall(session);
        try {
            Object object = this._kbLock;
            synchronized (object) {
                Registration registration = this._sessionToRegistrationMap.get(session);
                registration.setLastHeartbeat(System.currentTimeMillis());
            }
        }
        finally {
            this.unrecordCall();
        }
    }

    public void setMetaProjectInstance(ProjectInstance projectInstance) {
        this.projectInstance = projectInstance;
        if (projectInstance != null) {
            FrameStoreManager fsm = this._kb.getFrameStoreManager();
            ReadAccessEnforcementFrameStore readAccessEnforcement = new ReadAccessEnforcementFrameStore(this);
            if (readAccessEnforcement.isApplicable()) {
                fsm.insertFrameStore((FrameStore)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{FrameStore.class}, (InvocationHandler)readAccessEnforcement), 1);
            }
            LastUsageInvocationHandler lastUsageFrameStore = new LastUsageInvocationHandler(projectInstance, this.frameCalculator);
            fsm.insertFrameStore((FrameStore)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{FrameStore.class}, (InvocationHandler)lastUsageFrameStore), 1);
        }
    }

    public ProjectInstance getMetaProjectInstance() {
        return this.projectInstance;
    }

    @Override
    public Set<Operation> getAllowedOperations(RemoteSession session) {
        Policy policy = Server.getPolicy();
        User user = policy.getUserByName(session.getUserName());
        return ServerFrameStore.unbackOperations(policy.getAllowedOperations(user, this.projectInstance));
    }

    @Override
    public Set<Operation> getKnownOperations(RemoteSession session) {
        return ServerFrameStore.unbackOperations(Server.getPolicy().getKnownOperations());
    }

    private static Set<Operation> unbackOperations(Set<Operation> operations) {
        HashSet<Operation> unbacked = new HashSet<Operation>();
        for (Operation op : operations) {
            unbacked.add(new UnbackedOperationImpl(op));
        }
        return unbacked;
    }
}

